/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.DbObject;
import workbench.db.SubPartitionState;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;

public class TablePartition
implements DbObject {
    private String catalog;
    private String schema;
    private String partitionName;
    private String comment;
    private boolean isSubPartition;
    private List<? extends TablePartition> subPartitions;
    private SubPartitionState subPartitionState = SubPartitionState.unknown;
    private String definition;
    private String subPartitionsStrategy;
    private String partitionStrategy;

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getSubPartitionStrategy() {
        return this.subPartitionsStrategy;
    }

    public void setSubPartitionStrategy(String string) {
        this.subPartitionsStrategy = string;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public void setPartitionStrategy(String string) {
        this.partitionStrategy = string;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    @Override
    public void setName(String string) {
        this.partitionName = string;
    }

    public SubPartitionState getSubPartitionState() {
        return this.subPartitionState;
    }

    public void setSubPartitionState(SubPartitionState subPartitionState) {
        this.subPartitionState = subPartitionState == null ? SubPartitionState.unknown : subPartitionState;
    }

    public void setComments(String string) {
        this.comment = string;
    }

    public void setIsSubPartition(boolean bl) {
        this.isSubPartition = bl;
    }

    public boolean isSubPartition() {
        return this.isSubPartition;
    }

    public void setSubPartitions(List<? extends TablePartition> list) {
        this.subPartitions = list == null ? null : new ArrayList<TablePartition>(list);
    }

    public List<? extends TablePartition> getSubPartitions() {
        if (this.subPartitions == null) {
            return null;
        }
        return Collections.unmodifiableList(this.subPartitions);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getObjectType() {
        return "PARTITION";
    }

    @Override
    public String getObjectName() {
        return this.partitionName;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        if (wbConnection == null) {
            return SqlUtil.quoteObjectname(this.partitionName);
        }
        return wbConnection.getMetadata().quoteObjectname(this.partitionName);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return new TableIdentifier(this.catalog, this.schema, this.partitionName).getObjectExpression(wbConnection);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return this.definition;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public boolean supportsGetSource() {
        return this.definition != null;
    }
}

