/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbSettings;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class TableSelectBuilder {
    public static final String COLUMN_PLACEHOLDER = "${column}";
    public static final String TABLEDATA_TEMPLATE_NAME = "tabledata";
    public static final String ROWCOUNT_TEMPLATE_NAME = "tablerowcount";
    public static final String LIMIT_EXPRESSION_PLACEHOLDER = "%limit_expression%";
    public static final String ORDER_BY_PLACEHOLDER = "%order_by%";
    public static final String MAX_ROWS_PLACEHOLDER = "%max_rows%";
    private WbConnection dbConnection;
    private boolean includeBLOBColumns = true;
    private boolean includeCLOBColumns = true;
    private boolean useColumnAlias;
    private boolean sortPksFirst;
    private String sqlTemplate;
    private String limitClause;
    private boolean neverUseFQN = false;

    public TableSelectBuilder(WbConnection wbConnection) {
        this(wbConnection, null, null);
    }

    public TableSelectBuilder(WbConnection wbConnection, String string) {
        this(wbConnection, string, null);
    }

    public TableSelectBuilder(WbConnection wbConnection, String string, String string2) {
        this.dbConnection = wbConnection;
        if (this.dbConnection != null) {
            if (StringUtil.isNonBlank(string)) {
                this.sqlTemplate = this.dbConnection.getDbSettings().getTableSelectTemplate(string.toLowerCase());
            }
            if (StringUtil.isBlank(this.sqlTemplate) && StringUtil.isNonBlank(string2)) {
                this.sqlTemplate = this.dbConnection.getDbSettings().getTableSelectTemplate(string2.toLowerCase());
            }
            this.limitClause = this.dbConnection.getDbSettings().getLimitClause();
        }
        if (StringUtil.isBlank(this.sqlTemplate)) {
            this.sqlTemplate = "SELECT %columnlist%\nFROM %table_expression%";
        }
    }

    public void setNeverUseFQN(boolean bl) {
        this.neverUseFQN = bl;
    }

    public void setSortPksFirst(boolean bl) {
        this.sortPksFirst = bl;
    }

    void setSqlTemplate(String string) {
        this.sqlTemplate = string;
    }

    public void setIncludeBLOBColumns(boolean bl) {
        this.includeBLOBColumns = bl;
    }

    public void setIncludeCLOBColumns(boolean bl) {
        this.includeCLOBColumns = bl;
    }

    public void setUseColumnAlias(boolean bl) {
        this.useColumnAlias = bl;
    }

    public String getSelectForCount(TableIdentifier tableIdentifier) {
        if (tableIdentifier == null) {
            LogMgr.logWarning(new CallerInfo(){}, "Not table supplied!");
            return null;
        }
        String string = this.replacePlaceholders(tableIdentifier, "count(*)", -1);
        string = TemplateHandler.removePlaceholder(string, ORDER_BY_PLACEHOLDER, false);
        return string;
    }

    public String getSelectForTable(TableIdentifier tableIdentifier, int n) throws SQLException {
        TableIdentifier tableIdentifier2 = null;
        if (!tableIdentifier.getNeverAdjustCase() || tableIdentifier.getType() == null || tableIdentifier.getSchema() == null) {
            tableIdentifier2 = this.dbConnection.getMetadata().getSynonymTable(tableIdentifier);
        }
        TableDefinition tableDefinition = this.dbConnection.getMetadata().getTableDefinition(tableIdentifier2 == null ? tableIdentifier : tableIdentifier2, false);
        return this.getSelectForColumns(tableDefinition.getTable(), tableDefinition.getColumns(), n);
    }

    public String getSelectForTableData(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, boolean bl) {
        String string = this.getSelectForColumns(tableIdentifier, list, -1);
        StringBuilder stringBuilder = new StringBuilder(string.length() + 40);
        if (bl) {
            stringBuilder.append("-- @");
            stringBuilder.append("WbResult");
            stringBuilder.append(' ');
            stringBuilder.append(tableIdentifier.getTableName());
            stringBuilder.append('\n');
        }
        stringBuilder.append(string.trim());
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    public String getSelectForColumns(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, int n) {
        return this.getSelectForColumns(tableIdentifier, list, null, n);
    }

    public String getSelectForColumns(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, String string, int n) {
        if (tableIdentifier == null) {
            LogMgr.logWarning(new CallerInfo(){}, "No table supplied!");
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(list == null ? 5 : list.size() * 15);
        if (CollectionUtil.isEmpty(list)) {
            stringBuilder.append("*");
        } else {
            int n2 = 0;
            if (this.sortPksFirst) {
                list = ColumnIdentifier.sortPksFirst(list);
            }
            for (ColumnIdentifier columnIdentifier : list) {
                String string2 = null;
                int n3 = columnIdentifier.getDataType();
                String string3 = columnIdentifier.getDbmsType();
                if (string3 == null) {
                    string3 = SqlUtil.getTypeName(n3);
                }
                boolean bl = SqlUtil.isBlobType(n3);
                boolean bl2 = SqlUtil.isClobType(n3);
                if (bl2) {
                    if (this.includeCLOBColumns) {
                        string2 = this.getColumnExpression(columnIdentifier);
                    }
                } else if (bl) {
                    if (this.includeBLOBColumns) {
                        string2 = this.getColumnExpression(columnIdentifier);
                    }
                } else {
                    string2 = this.getColumnExpression(columnIdentifier);
                }
                if (string2 == null) continue;
                if (n2 > 0) {
                    stringBuilder.append(",\n");
                }
                if (n2 > 0) {
                    stringBuilder.append("       ");
                }
                stringBuilder.append(string2);
                ++n2;
            }
        }
        String string4 = this.replacePlaceholders(tableIdentifier, stringBuilder, n);
        string4 = this.applyOrderBy(string4, string);
        return string4;
    }

    private String applyOrderBy(String string, String string2) {
        if (StringUtil.isNonBlank(string2)) {
            String string3 = " \nORDER BY " + string2;
            string = string.contains(ORDER_BY_PLACEHOLDER) ? TemplateHandler.replacePlaceholder(string, ORDER_BY_PLACEHOLDER, string3, true) : string + string3;
        } else {
            string = TemplateHandler.removePlaceholder(string, ORDER_BY_PLACEHOLDER, false);
        }
        return string;
    }

    private String replacePlaceholders(TableIdentifier tableIdentifier, CharSequence charSequence, int n) {
        String string = this.sqlTemplate.replace("%columnlist%", charSequence);
        if (this.neverUseFQN) {
            TableIdentifier tableIdentifier2 = new TableIdentifier(tableIdentifier.getCatalog(), tableIdentifier.getSchema(), tableIdentifier.getTableName()){

                @Override
                public String getTableExpression(WbConnection wbConnection) {
                    return super.buildTableExpression(TableSelectBuilder.this.dbConnection.getMetadata(), null, SqlUtil.getCatalogSeparator(wbConnection), SqlUtil.getSchemaSeparator(wbConnection));
                }

                @Override
                public String getTableExpression(char c, char c2) {
                    return this.getTableExpression(TableSelectBuilder.this.dbConnection);
                }

                @Override
                public String getTableExpression() {
                    return this.getTableExpression(TableSelectBuilder.this.dbConnection);
                }

                @Override
                public String getFullyQualifiedName(WbConnection wbConnection) {
                    return this.getTableExpression(TableSelectBuilder.this.dbConnection);
                }
            };
            string = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier2, null);
        } else {
            string = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier, this.dbConnection);
        }
        string = this.applyLimit(string, n);
        return string;
    }

    public String getColumnExpression(ColumnIdentifier columnIdentifier) {
        String string = this.dbConnection.getMetadata().quoteObjectname(columnIdentifier.getColumnName());
        DbSettings dbSettings = this.dbConnection.getDbSettings();
        if (dbSettings == null) {
            return string;
        }
        String string2 = SqlUtil.getPlainTypeName(columnIdentifier.getDbmsType());
        String string3 = dbSettings.getDataTypeSelectExpression(string2);
        if (string3 == null) {
            return string;
        }
        if (!string3.contains(COLUMN_PLACEHOLDER)) {
            LogMgr.logError(new CallerInfo(){}, "Expression without ${column} specified for datatype '" + string2 + "': " + string3, null);
            return string;
        }
        string3 = string3.replace(COLUMN_PLACEHOLDER, string);
        if (this.useColumnAlias) {
            string3 = string3 + " AS " + string;
        }
        return string3;
    }

    public String getLimitExpression(int n) {
        if (n <= 0) {
            return "";
        }
        if (StringUtil.isEmptyString(this.limitClause)) {
            return "";
        }
        if (!this.limitClause.contains(MAX_ROWS_PLACEHOLDER)) {
            return "";
        }
        return this.limitClause.replace(MAX_ROWS_PLACEHOLDER, Integer.toString(n));
    }

    public String applyLimit(String string, int n) {
        String string2 = this.getLimitExpression(n);
        return TemplateHandler.replacePlaceholder(string, LIMIT_EXPRESSION_PLACEHOLDER, string2, false);
    }

    void setTemplate(String string) {
        this.sqlTemplate = string;
    }

    void setLimitClause(String string) {
        this.limitClause = string;
    }
}

