/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.ConstraintReader;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.DependencyNode;
import workbench.db.DropType;
import workbench.db.FKHandler;
import workbench.db.FKMatchType;
import workbench.db.IndexColumn;
import workbench.db.IndexDefinition;
import workbench.db.IndexReader;
import workbench.db.JdbcUtils;
import workbench.db.ObjectSourceOptions;
import workbench.db.PkDefinition;
import workbench.db.QuoteHandler;
import workbench.db.ReaderFactory;
import workbench.db.TableCommentReader;
import workbench.db.TableConstraint;
import workbench.db.TableDefinition;
import workbench.db.TableDependency;
import workbench.db.TableGrantReader;
import workbench.db.TableIdentifier;
import workbench.db.ViewReader;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.ColumnDefinitionTemplate;
import workbench.db.sqltemplates.ConstraintNameTester;
import workbench.db.sqltemplates.FkTemplate;
import workbench.db.sqltemplates.PkTemplate;
import workbench.db.sqltemplates.TemplateHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.Settings;
import workbench.sql.formatter.SqlFormatter;
import workbench.sql.formatter.SqlFormatterFactory;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class TableSourceBuilder {
    public static final String COL_INDENT = "   ";
    public static final String SCHEMA_PLACEHOLDER = "%schema%";
    public static final String CATALOG_PLACEHOLDER = "%catalog%";
    public static final String NAME_PLACEHOLDER = "%name%";
    protected WbConnection dbConnection;
    private ConstraintNameTester nameTester;
    protected boolean includePartitions = true;

    protected TableSourceBuilder(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
        this.nameTester = new ConstraintNameTester(wbConnection.getDbId());
    }

    protected ViewReader getViewReader() {
        return this.dbConnection.getMetadata().getViewReader();
    }

    protected IndexReader getIndexReader() {
        return this.dbConnection.getMetadata().getIndexReader();
    }

    public void setIncludePartitions(boolean bl) {
        this.includePartitions = bl;
    }

    public String getTableSource(TableIdentifier tableIdentifier, DropType dropType, boolean bl) throws SQLException {
        return this.getTableSource(tableIdentifier, dropType, bl, this.dbConnection.getDbSettings().getGenerateTableGrants());
    }

    public String getTableSource(TableIdentifier tableIdentifier, DropType dropType, boolean bl, boolean bl2) throws SQLException {
        Object object;
        if (this.dbConnection.getDbSettings().isViewType(tableIdentifier.getType())) {
            CharSequence charSequence = this.getViewReader().getExtendedViewSource(tableIdentifier, dropType);
            if (charSequence == null) {
                return null;
            }
            return charSequence.toString();
        }
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        tableIdentifier2.adjustCase(this.dbConnection);
        List<ColumnIdentifier> list = null;
        List<IndexDefinition> list2 = null;
        TableIdentifier tableIdentifier3 = tableIdentifier2;
        List<DependencyNode> list3 = null;
        if (this.dbConnection.getDbSettings().needTableDefinitionForTableSource()) {
            object = dbMetadata.getTableDefinition(tableIdentifier2);
            list = ((TableDefinition)object).getColumns();
            list2 = this.getIndexReader().getTableIndexList(((TableDefinition)object).getTable(), true);
            tableIdentifier3 = ((TableDefinition)object).getTable();
        }
        if (bl && this.dbConnection.getDbSettings().getGenerateTableFKSource()) {
            list3 = this.getForeignKeys(tableIdentifier3);
        }
        object = this.getTableSource(tableIdentifier3, list, list2, list3, dropType, bl, bl2);
        if (tableIdentifier3.getSourceOptions().isInitialized()) {
            tableIdentifier.setSourceOptions(tableIdentifier3.getSourceOptions());
        }
        return object;
    }

    public String getTableSource(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        List<IndexDefinition> list2 = this.getIndexReader().getTableIndexList(tableIdentifier, true);
        return this.getTableSource(tableIdentifier, list, list2, null, DropType.none, true);
    }

    private boolean isFKName(String string, List<DependencyNode> list) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        for (DependencyNode dependencyNode : list) {
            String string2 = dependencyNode.getFkName();
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private List<IndexDefinition> getIndexesToCreate(List<IndexDefinition> list, List<DependencyNode> list2) {
        if (CollectionUtil.isEmpty(list)) {
            return list;
        }
        if (CollectionUtil.isEmpty(list2)) {
            return list;
        }
        ArrayList<IndexDefinition> arrayList = new ArrayList<IndexDefinition>(list.size());
        for (IndexDefinition indexDefinition : list) {
            if (indexDefinition.isAutoGenerated() || this.dbConnection.getDbSettings().supportsAutomaticFkIndexes() && this.isFKName(indexDefinition.getName(), list2)) continue;
            arrayList.add(indexDefinition);
        }
        return arrayList;
    }

    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
    }

    public String getTableSource(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2, List<DependencyNode> list3, DropType dropType, boolean bl) {
        return this.getTableSource(tableIdentifier, list, list2, list3, dropType, bl, this.dbConnection.getDbSettings().getGenerateTableGrants());
    }

    public String getTableSource(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2, List<DependencyNode> list3, DropType dropType, boolean bl, boolean bl2) {
        StringBuilder stringBuilder;
        Object object;
        CharSequence charSequence = this.getCreateTable(tableIdentifier, list, list2, list3, dropType, bl);
        StringBuilder stringBuilder2 = new StringBuilder(charSequence.length() + 50);
        stringBuilder2.append(charSequence);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        boolean bl3 = this.getCreateInlineFKConstraints();
        StringUtil.trimTrailingWhitespace(stringBuilder2);
        stringBuilder2.append(string);
        if (!bl3 && bl && this.dbConnection.getDbSettings().getGenerateTableFKSource()) {
            object = this.getFkSource(tableIdentifier, list3, false);
            if (StringUtil.isNonBlank((CharSequence)object)) {
                stringBuilder2.append(string);
                stringBuilder2.append((CharSequence)object);
            }
            StringUtil.trimTrailingWhitespace(stringBuilder2);
            stringBuilder2.append(string);
        }
        if (this.dbConnection.getDbSettings().getGenerateTableIndexSource()) {
            object = this.getIndexesToCreate(list2, list3);
            stringBuilder = this.getIndexReader().getIndexSource(tableIdentifier, (List<IndexDefinition>)object);
            if (StringUtil.isNonBlank(stringBuilder)) {
                stringBuilder2.append(string);
                stringBuilder2.append((CharSequence)stringBuilder);
            }
            StringUtil.trimTrailingWhitespace(stringBuilder2);
            stringBuilder2.append(string);
        }
        this.appendTableComments(stringBuilder2, tableIdentifier, list, string);
        if (bl2) {
            object = TableGrantReader.createReader(this.dbConnection);
            stringBuilder = ((TableGrantReader)object).getTableGrantSource(this.dbConnection, tableIdentifier);
            if (StringUtil.isNonBlank(stringBuilder)) {
                stringBuilder2.append(string);
                stringBuilder2.append((CharSequence)stringBuilder);
            }
            StringUtil.trimTrailingWhitespace(stringBuilder2);
            stringBuilder2.append(string);
        }
        if ((object = tableIdentifier.getSourceOptions().getAdditionalSql()) != null) {
            stringBuilder2.append(string);
            stringBuilder2.append((CharSequence)object);
        }
        StringUtil.trimTrailingWhitespace(stringBuilder2);
        stringBuilder2.append(string);
        return stringBuilder2.toString();
    }

    protected void appendTableComments(StringBuilder stringBuilder, TableIdentifier tableIdentifier, List<ColumnIdentifier> list, String string) {
        TableSourceBuilder.appendComments(stringBuilder, this.dbConnection, tableIdentifier, list, string, !this.dbConnection.getDbSettings().getUseInlineColumnComments());
    }

    public static void appendComments(StringBuilder stringBuilder, WbConnection wbConnection, TableDefinition tableDefinition) {
        if (tableDefinition != null) {
            TableSourceBuilder.appendComments(stringBuilder, wbConnection, tableDefinition.getTable(), tableDefinition.getColumns(), "\n", true);
        }
    }

    public static void appendComments(StringBuilder stringBuilder, WbConnection wbConnection, TableIdentifier tableIdentifier, List<ColumnIdentifier> list, String string, boolean bl) {
        if (wbConnection.getDbSettings().getGenerateTableComments()) {
            CharSequence charSequence;
            TableCommentReader tableCommentReader = new TableCommentReader();
            if (!wbConnection.getDbSettings().getUseInlineTableComments() && StringUtil.isNonBlank(charSequence = tableCommentReader.getTableCommentSql(wbConnection, tableIdentifier))) {
                stringBuilder.append(string);
                stringBuilder.append((String)charSequence);
            }
            if (bl && CollectionUtil.isNonEmpty(list) && StringUtil.isNonBlank(charSequence = tableCommentReader.getTableColumnCommentsSql(wbConnection, tableIdentifier, list))) {
                stringBuilder.append(string);
                stringBuilder.append(charSequence);
            }
        }
    }

    public CharSequence getCreateTable(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2, List<DependencyNode> list3, DropType dropType, boolean bl) {
        return this.getCreateTable(tableIdentifier, list, list2, list3, dropType, bl, true, false);
    }

    public CharSequence getCreateTable(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2, List<DependencyNode> list3, DropType dropType, boolean bl, boolean bl2, boolean bl3) {
        CharSequence charSequence;
        boolean bl4;
        if (tableIdentifier == null) {
            return "";
        }
        String string = this.getNativeTableSource(tableIdentifier, dropType);
        if (string != null) {
            return string;
        }
        this.readTableOptions(tableIdentifier, list);
        if (tableIdentifier.getUseInlineFK() && list3 == null) {
            list3 = this.getForeignKeys(tableIdentifier);
        }
        if (CollectionUtil.isEmpty(list)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(250);
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        TableDefinition tableDefinition = new TableDefinition(tableIdentifier, list);
        ConstraintReader constraintReader = ReaderFactory.getConstraintReader(dbMetadata);
        constraintReader.retrieveColumnConstraints(this.dbConnection, tableDefinition);
        List<TableConstraint> list4 = constraintReader.getTableConstraints(this.dbConnection, tableDefinition);
        constraintReader.updateIndexList(list4, list2);
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        String string2 = objectSourceOptions.getTypeModifier();
        stringBuilder.append((CharSequence)this.generateCreateObject(dropType, tableIdentifier, string2, bl3));
        stringBuilder.append("\n(\n");
        this.appendColumnDefinitions(stringBuilder, list, dbMetadata, COL_INDENT);
        String string3 = constraintReader.getConstraintSource(list4, COL_INDENT);
        if (StringUtil.isNonEmpty(string3)) {
            stringBuilder.append(",\n").append(COL_INDENT);
            stringBuilder.append(string3);
        }
        String string4 = this.getPKName(list2);
        String string5 = tableIdentifier.getPrimaryKeyName() != null ? tableIdentifier.getPrimaryKeyName() : string4;
        List<String> list5 = this.findPkColumns(list);
        if (string5 != null && list5.isEmpty()) {
            list5 = this.getPKColsFromIndex(list2);
        }
        PkDefinition pkDefinition = tableIdentifier.getPrimaryKey();
        if (bl2 && pkDefinition == null) {
            pkDefinition = this.getIndexReader().getPrimaryKey(tableIdentifier);
            if (pkDefinition == null && list5.size() > 0) {
                pkDefinition = new PkDefinition(list5);
            } else {
                tableIdentifier.setPrimaryKey(pkDefinition);
            }
        }
        this.syncPkIndexType(pkDefinition, list2);
        boolean bl5 = bl4 = tableIdentifier.getUseInlinePK() || this.getCreateInlinePKConstraints();
        if (bl2 && bl4 && pkDefinition != null) {
            stringBuilder.append(",\n").append(COL_INDENT);
            charSequence = this.getPkSource(tableIdentifier, pkDefinition, true, false);
            stringBuilder.append(charSequence);
        }
        if ((tableIdentifier.getUseInlineFK() || bl && this.getCreateInlineFKConstraints()) && ((StringBuilder)(charSequence = this.getFkSource(tableIdentifier, list3, true))).length() > 0) {
            stringBuilder.append(",\n");
            stringBuilder.append(charSequence);
        }
        if ((charSequence = objectSourceOptions.getInlineOption()) != null) {
            stringBuilder.append(",\n").append(COL_INDENT);
            stringBuilder.append((String)charSequence);
        }
        stringBuilder.append('\n');
        stringBuilder.append(")");
        String string6 = objectSourceOptions.getTableOption();
        if (StringUtil.isNonEmpty(string6)) {
            stringBuilder.append('\n');
            stringBuilder.append(string6);
            stringBuilder.append('\n');
        }
        if (this.dbConnection.getDbSettings().getUseInlineTableComments() && this.dbConnection.getDbSettings().getInlineTableCommentKeyword() != null && StringUtil.isNonEmpty(tableIdentifier.getComment())) {
            stringBuilder.append('\n');
            stringBuilder.append(this.dbConnection.getDbSettings().getInlineTableCommentKeyword());
            stringBuilder.append(" '");
            stringBuilder.append(SqlUtil.escapeQuotes(tableIdentifier.getComment()));
            stringBuilder.append('\'');
        }
        StringUtil.trimTrailingWhitespace(stringBuilder);
        stringBuilder.append(";\n");
        String string7 = this.getAdditionalTableInfo(tableIdentifier, list, list2);
        if (StringUtil.isNonBlank(string7)) {
            stringBuilder.append(string7);
            stringBuilder.append('\n');
        }
        if (bl2 && !bl4 && pkDefinition != null) {
            CharSequence charSequence2 = this.getPkSource(tableIdentifier, pkDefinition, false, bl3);
            stringBuilder.append('\n');
            stringBuilder.append(charSequence2);
        }
        return stringBuilder;
    }

    private void syncPkIndexType(PkDefinition pkDefinition, List<IndexDefinition> list) {
        if (pkDefinition == null) {
            return;
        }
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        for (IndexDefinition indexDefinition : list) {
            if (!indexDefinition.isPrimaryKeyIndex()) continue;
            pkDefinition.setPkIndexDefinition(indexDefinition);
        }
    }

    public CharSequence generateDrop(DbObject dbObject, DropType dropType) {
        String string = dbObject.getObjectType();
        string = string.replace("SYSTEM ", "");
        String string2 = dbObject.getObjectNameForDrop(this.dbConnection);
        String string3 = dbObject.getFullyQualifiedName(this.dbConnection);
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 15);
        String string4 = this.dbConnection.getDbSettings().getDropDDL(string, dropType == DropType.cascaded);
        if (string4 == null) {
            stringBuilder.append("DROP ");
            stringBuilder.append(string.toUpperCase());
            stringBuilder.append(' ');
            stringBuilder.append(string2);
            String string5 = this.dbConnection.getDbSettings().getCascadeConstraintsVerb(string);
            if (string5 != null) {
                stringBuilder.append(' ');
                stringBuilder.append(string5);
            }
            stringBuilder.append(";\n");
        } else {
            string4 = TemplateHandler.replacePlaceholder(string4, "%fq_table_name%", string3, false);
            string4 = TemplateHandler.replacePlaceholder(string4, NAME_PLACEHOLDER, string2, false);
            stringBuilder.append(SqlUtil.addSemicolon(string4));
        }
        return stringBuilder;
    }

    public String getReplaceDDL(String string) {
        return this.getDDL(string, "replace");
    }

    protected String getCreateDDL(String string, TableIdentifier tableIdentifier) {
        String string2 = this.getDDL(string, "create");
        if (string2 != null) {
            return string2;
        }
        return "CREATE " + string.toUpperCase() + " " + "%if_not_exists%" + " " + NAME_PLACEHOLDER;
    }

    protected String getDDL(String string, String string2) {
        String string3 = "workbench.db.";
        String string4 = "." + DbSettings.getKeyValue(string) + ".sql." + this.dbConnection.getDbId();
        return Settings.getInstance().getProperty(string3 + string2 + string4, null);
    }

    public StringBuilder generateCreateObject(DropType dropType, TableIdentifier tableIdentifier, String string) {
        return this.generateCreateObject(dropType, tableIdentifier, string, false);
    }

    public StringBuilder generateCreateObject(DropType dropType, TableIdentifier tableIdentifier, String string, boolean bl) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = dropType != DropType.none;
        String string3 = tableIdentifier.getObjectType();
        String string4 = this.getReplaceDDL(string3 = string3.replace("SYSTEM ", ""));
        if (string4 == null) {
            string4 = this.getCreateDDL(string3, tableIdentifier);
        } else {
            string2 = this.dbConnection.getDbSettings().getCascadeConstraintsVerb(string3);
            boolean bl3 = StringUtil.isNonEmpty(string2);
            boolean bl4 = bl2 = dropType == DropType.cascaded && bl3;
        }
        if (bl2) {
            stringBuilder.append(this.generateDrop(tableIdentifier, dropType));
            stringBuilder.append('\n');
            stringBuilder.append('\n');
        }
        string2 = tableIdentifier.getObjectExpression(this.dbConnection);
        String string5 = tableIdentifier.getFullyQualifiedName(this.dbConnection);
        string4 = StringUtil.replace(string4, NAME_PLACEHOLDER, bl ? string5 : string2);
        string4 = StringUtil.replace(string4, "%fq_name%", string5);
        string4 = StringUtil.isEmptyString(string) ? TemplateHandler.removePlaceholder(string4, "%typeoption%", true) : TemplateHandler.replacePlaceholder(string4, "%typeoption%", string, true);
        String string6 = this.dbConnection.getDbSettings().getDDLIfNoExistsOption(string3);
        string4 = dropType == DropType.none && StringUtil.isNonEmpty(string6) ? TemplateHandler.replacePlaceholder(string4, "%if_not_exists%", string6, true) : TemplateHandler.removePlaceholder(string4, "%if_not_exists%", true);
        stringBuilder.append(string4);
        return stringBuilder;
    }

    private List<String> findPkColumns(List<ColumnIdentifier> list) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        for (ColumnIdentifier columnIdentifier : list) {
            if (!columnIdentifier.isPkColumn()) continue;
            arrayList.add(columnIdentifier.getColumnName());
        }
        return arrayList;
    }

    public void appendColumnDefinitions(StringBuilder stringBuilder, List<ColumnIdentifier> list, DbMetadata dbMetadata) {
        this.appendColumnDefinitions(stringBuilder, list, dbMetadata, COL_INDENT);
    }

    public void appendColumnDefinitions(StringBuilder stringBuilder, List<ColumnIdentifier> list, DbMetadata dbMetadata, String string) {
        String string2;
        String string3;
        int n = 0;
        int n2 = 0;
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(list);
        ColumnIdentifier.sortByPosition(arrayList);
        for (ColumnIdentifier columnIdentifier : arrayList) {
            string3 = dbMetadata.quoteObjectname(columnIdentifier.getColumnName());
            string2 = columnIdentifier.getDbmsType();
            n = Math.max(n, string3.length());
            n2 = Math.max(n2, string2 != null ? string2.length() : 0);
        }
        n += 2;
        n2 += 2;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ColumnIdentifier columnIdentifier;
            columnIdentifier = (ColumnIdentifier)iterator.next();
            string3 = columnIdentifier.getColumnName();
            string2 = dbMetadata.quoteObjectname(string3);
            String string4 = columnIdentifier.getDbmsType();
            if (string4 == null) {
                string4 = "";
            }
            stringBuilder.append(string);
            if (columnIdentifier.isInherited()) {
                stringBuilder.append("-- inherited: ");
            }
            stringBuilder.append(string2);
            for (int i = 0; i < n - string2.length(); ++i) {
                stringBuilder.append(' ');
            }
            String string5 = this.getColumnSQL(columnIdentifier, n2, columnIdentifier.getConstraint());
            stringBuilder.append(string5);
            if (!iterator.hasNext()) continue;
            if (!columnIdentifier.isInherited()) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\n');
        }
    }

    private List<String> getPKColsFromIndex(List<IndexDefinition> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IndexDefinition indexDefinition : list) {
            if (indexDefinition == null || !indexDefinition.isPrimaryKeyIndex()) continue;
            for (IndexColumn indexColumn : indexDefinition.getColumns()) {
                arrayList.add(indexColumn.getColumn());
            }
        }
        return arrayList;
    }

    protected String getColumnSQL(ColumnIdentifier columnIdentifier, int n, String string) {
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        boolean bl = this.dbConnection.getDbSettings().getUseInlineColumnComments();
        StringBuilder stringBuilder = new StringBuilder(50);
        ColumnIdentifier columnIdentifier2 = columnIdentifier;
        ColumnDefinitionTemplate columnDefinitionTemplate = new ColumnDefinitionTemplate(dbMetadata.getDbId());
        columnDefinitionTemplate.setFixDefaultValues(!this.dbConnection.getDbSettings().returnsValidDefaultExpressions());
        stringBuilder.append(columnDefinitionTemplate.getColumnDefinitionSQL(columnIdentifier2, string, n));
        if (bl && StringUtil.isNonBlank(columnIdentifier.getComment())) {
            String string2 = " " + this.dbConnection.getDbSettings().getInlineCommentKeyword() + " ";
            stringBuilder.append(string2);
            stringBuilder.append('\'');
            stringBuilder.append(SqlUtil.escapeQuotes(columnIdentifier.getComment()));
            stringBuilder.append('\'');
        }
        return stringBuilder.toString();
    }

    protected String getAdditionalTableInfo(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2) {
        return null;
    }

    private String getPKName(List<IndexDefinition> list) {
        if (list == null) {
            return null;
        }
        for (IndexDefinition indexDefinition : list) {
            if (!indexDefinition.isPrimaryKeyIndex()) continue;
            return indexDefinition.getName();
        }
        return null;
    }

    public static String replacePlaceHolder(String string, String string2, String string3, boolean bl, QuoteHandler quoteHandler) {
        string3 = bl ? quoteHandler.quoteObjectname(string3) : string3;
        return TemplateHandler.replacePlaceholder(string, string2, string3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNativeTableSource(TableIdentifier tableIdentifier, DropType dropType) {
        String string = this.dbConnection.getDbSettings().getRetrieveObjectSourceSql(tableIdentifier.getType());
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(250);
        int n = this.dbConnection.getDbSettings().getRetrieveTableSourceCol(tableIdentifier.getType());
        if (dropType != DropType.none) {
            CharSequence charSequence = this.generateDrop(tableIdentifier, dropType);
            stringBuilder.append(charSequence);
            stringBuilder.append("\n\n");
        }
        boolean bl = this.dbConnection.getDbSettings().getRetrieveObjectSourceNeedsQuotes(tableIdentifier.getType());
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        if ((string = TableSourceBuilder.replacePlaceHolder(string, "%table_name%", tableIdentifier.getTableName(), bl, dbMetadata)).contains("%fq_table_name%")) {
            string = TableSourceBuilder.replacePlaceHolder(string, "%fq_table_name%", tableIdentifier.getFullyQualifiedName(this.dbConnection), false, dbMetadata);
        }
        string = TableSourceBuilder.replacePlaceHolder(string, SCHEMA_PLACEHOLDER, tableIdentifier.getSchema(), bl, dbMetadata);
        string = TableSourceBuilder.replacePlaceHolder(string, CATALOG_PLACEHOLDER, tableIdentifier.getCatalog(), bl, dbMetadata);
        LogMgr.logMetadataSql(new CallerInfo(){}, "table source", string, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.dbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                stringBuilder.append(resultSet.getString(n));
            }
            stringBuilder.append('\n');
        }
        catch (Exception exception) {
            String string2;
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "table source", string, new Object[0]);
                string2 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
            return string2;
        }
        JdbcUtils.closeAll(resultSet, statement);
        StringUtil.trimTrailingWhitespace(stringBuilder);
        if (stringBuilder.charAt(stringBuilder.length() - 1) != ';') {
            stringBuilder.append(";\n");
        }
        if (this.dbConnection.getDbSettings().applyFormatForNativeTableSource()) {
            SqlFormatter sqlFormatter = SqlFormatterFactory.createFormatter(this.dbConnection.getDbId());
            return sqlFormatter.getFormattedSql(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    public CharSequence getPkSource(TableIdentifier tableIdentifier, PkDefinition pkDefinition, boolean bl, boolean bl2) {
        if (pkDefinition == null) {
            return "";
        }
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        PkTemplate pkTemplate = new PkTemplate(this.dbConnection, bl);
        String string = pkTemplate.getSQLTemplate();
        if (StringUtil.isEmptyString(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        String string2 = tableIdentifier.getFullyQualifiedName(this.dbConnection);
        String string3 = tableIdentifier.getTableExpression(this.dbConnection);
        List<String> list = pkDefinition.getColumns();
        String string4 = pkDefinition.getPkName();
        string = StringUtil.replace(string, "%table_expression%", bl2 ? string2 : string3);
        string = StringUtil.replace(string, "%table_name%", bl2 ? string2 : tableIdentifier.getTableName());
        string = StringUtil.replace(string, "%fq_table_name%", string2);
        string = StringUtil.replace(string, "%columnlist%", this.getColumnList(list));
        if (this.nameTester.isSystemConstraintName(string4)) {
            string4 = null;
        }
        if (string4 == null && DbExplorerSettings.getAutoGeneratePKName()) {
            int n = this.dbConnection.getMetadata().getMaxTableNameLength();
            string4 = this.nameTester.generatePKName(tableIdentifier, n);
        } else if (string4 != null && this.dbConnection.getDbSettings().useFQConstraintName()) {
            string4 = SqlUtil.buildExpression(this.dbConnection, tableIdentifier.getCatalog(), tableIdentifier.getSchema(), string4);
        } else if (string4 != null) {
            string4 = dbMetadata.quoteObjectname(string4);
        }
        if (StringUtil.isEmptyString(string4)) {
            string = TemplateHandler.removePlaceholder(string, "CONSTRAINT %constraint_name%", true);
            string = TemplateHandler.removePlaceholder(string, "%constraint_name%", true);
            string = StringUtil.replace(string, " CONSTRAINT ", "");
        } else {
            string = StringUtil.replace(string, "%pk_name%", string4);
            string = TemplateHandler.replacePlaceholder(string, "%constraint_name%", string4, true);
        }
        string = string.replaceAll("ADD\\s+PRIMARY", "ADD PRIMARY");
        stringBuilder.append(string);
        if (!bl) {
            stringBuilder.append(";\n");
        }
        return stringBuilder;
    }

    private String getColumnList(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder(list.size() * 30);
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.dbConnection.getMetadata().quoteObjectname(list.get(i)));
        }
        return stringBuilder.toString();
    }

    private boolean getCreateInlinePKConstraints() {
        if (this.dbConnection == null) {
            return false;
        }
        return this.dbConnection.getDbSettings().createInlinePKConstraints();
    }

    private boolean getCreateInlineFKConstraints() {
        if (this.dbConnection == null) {
            return false;
        }
        return this.dbConnection.getDbSettings().createInlineFKConstraints();
    }

    private List<DependencyNode> getForeignKeys(TableIdentifier tableIdentifier) {
        TableDependency tableDependency = new TableDependency(this.dbConnection, tableIdentifier);
        tableDependency.setRetrieveDirectChildrenOnly(true);
        tableDependency.readTreeForParents();
        return tableDependency.getLeafs();
    }

    public StringBuilder getFkSource(TableIdentifier tableIdentifier) {
        return this.getFkSource(tableIdentifier, this.getForeignKeys(tableIdentifier), this.getCreateInlineFKConstraints());
    }

    public StringBuilder getFkSource(TableIdentifier tableIdentifier, List<DependencyNode> list, boolean bl) {
        Object object;
        if (CollectionUtil.isEmpty(list)) {
            return StringUtil.emptyBuilder();
        }
        FkTemplate fkTemplate = new FkTemplate(this.dbConnection.getDbId(), bl);
        String string = fkTemplate.getSQLTemplate();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        FKHandler fKHandler = FKHandler.createInstance(this.dbConnection);
        for (DependencyNode object22 : list) {
            String string2;
            object = object22.getFkName();
            String string3 = TemplateHandler.replaceTablePlaceholder(string, tableIdentifier, this.dbConnection, false);
            if (this.nameTester.isSystemConstraintName((String)object)) {
                string3 = StringUtil.replace(string3, "%constraint_name%", "");
                string3 = StringUtil.replace(string3, " CONSTRAINT ", "");
            } else if (this.dbConnection.getDbSettings().useFQConstraintName()) {
                string2 = SqlUtil.buildExpression(this.dbConnection, tableIdentifier.getCatalog(), tableIdentifier.getSchema(), (String)object);
                string3 = StringUtil.replace(string3, "%constraint_name%", string2);
            } else {
                string3 = StringUtil.replace(string3, "%constraint_name%", this.dbConnection.getMetadata().quoteObjectname((String)object));
            }
            string3 = TemplateHandler.replacePlaceholder(string3, "%columnlist%", this.getColumnList(object22.getTargetColumns()), true);
            string2 = object22.getUpdateAction();
            string3 = this.dbConnection.getDbSettings().supportsFkOption("update", string2) ? TemplateHandler.replacePlaceholder(string3, "%fk_update_rule%", "ON UPDATE " + string2, true) : TemplateHandler.removePlaceholder(string3, "%fk_update_rule%", true);
            string2 = object22.getDeleteAction();
            string3 = this.dbConnection.getDbSettings().supportsFkOption("delete", string2) ? TemplateHandler.replacePlaceholder(string3, "%fk_delete_rule%", "ON DELETE " + string2, true) : TemplateHandler.removePlaceholder(string3, "%fk_delete_rule%", true);
            string2 = this.getDeferrableVerb(object22.getDeferrableType());
            string3 = StringUtil.isEmptyString(string2) ? TemplateHandler.removePlaceholder(string3, "%deferrable%", true) : TemplateHandler.replacePlaceholder(string3, "%deferrable%", string2.trim(), true);
            FKMatchType fKMatchType = object22.getMatchType();
            string3 = !fKHandler.shouldGenerate(fKMatchType) ? TemplateHandler.removePlaceholder(string3, "%fk_match_type%", false) : TemplateHandler.replacePlaceholder(string3, "%fk_match_type%", "MATCH " + fKMatchType.toString(), true);
            string3 = TemplateHandler.replacePlaceholder(string3, "%targettable%", object22.getTable().getTableExpression(this.dbConnection), true);
            string3 = TemplateHandler.replacePlaceholder(string3, "%targetcolumnlist%", this.getColumnList(object22.getSourceColumns()), true);
            String string4 = this.getAdditionalFkSql(tableIdentifier, object22, string3);
            if (string4 != null) {
                string3 = string4;
            }
            arrayList.add(string3.trim());
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = Settings.getInstance().getInternalEditorLineEnding();
        object = arrayList.iterator();
        while (object.hasNext()) {
            if (bl) {
                stringBuilder.append(COL_INDENT);
                stringBuilder.append((String)object.next());
                if (object.hasNext()) {
                    stringBuilder.append(',');
                }
            } else {
                stringBuilder.append((String)object.next());
                stringBuilder.append(';');
                stringBuilder.append(string5);
            }
            if (!object.hasNext()) continue;
            stringBuilder.append(string5);
        }
        return stringBuilder;
    }

    protected String getAdditionalFkSql(TableIdentifier tableIdentifier, DependencyNode dependencyNode, String string) {
        return null;
    }

    private String getDeferrableVerb(String string) {
        if (this.dbConnection.getDbSettings().isNotDeferrable(string)) {
            return "";
        }
        return "DEFERRABLE " + string;
    }
}

