/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import workbench.db.DBID;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.db.derby.DerbyTableSourceBuilder;
import workbench.db.exasol.ExasolTableSourceBuilder;
import workbench.db.firebird.FirebirdTableSourceBuilder;
import workbench.db.greenplum.GreenplumTableSourceBuilder;
import workbench.db.h2database.H2TableSourceBuilder;
import workbench.db.hana.HanaTableSourceBuilder;
import workbench.db.hsqldb.HsqlTableSourceBuilder;
import workbench.db.ibm.Db2TableSourceBuilder;
import workbench.db.ibm.InformixTableSourceBuilder;
import workbench.db.mssql.SqlServerTableSourceBuilder;
import workbench.db.mysql.MySQLTableSourceBuilder;
import workbench.db.oracle.OracleTableSourceBuilder;
import workbench.db.postgres.PostgresTableSourceBuilder;
import workbench.db.redshift.RedshiftTableSourceBuilder;

public class TableSourceBuilderFactory {
    public static TableSourceBuilder getBuilder(WbConnection wbConnection) {
        switch (DBID.fromConnection(wbConnection)) {
            case Postgres: {
                return new PostgresTableSourceBuilder(wbConnection);
            }
            case Greenplum: {
                return new GreenplumTableSourceBuilder(wbConnection);
            }
            case Redshift: {
                return new RedshiftTableSourceBuilder(wbConnection);
            }
            case Derby: {
                return new DerbyTableSourceBuilder(wbConnection);
            }
            case Oracle: {
                return new OracleTableSourceBuilder(wbConnection);
            }
            case H2: {
                return new H2TableSourceBuilder(wbConnection);
            }
            case MySQL: 
            case MariaDB: {
                return new MySQLTableSourceBuilder(wbConnection);
            }
            case SQL_Server: {
                return new SqlServerTableSourceBuilder(wbConnection);
            }
            case HSQLDB: {
                return new HsqlTableSourceBuilder(wbConnection);
            }
            case DB2_LUW: {
                return new Db2TableSourceBuilder(wbConnection);
            }
            case Informix: {
                return new InformixTableSourceBuilder(wbConnection);
            }
            case Firebird: {
                return new FirebirdTableSourceBuilder(wbConnection);
            }
            case HANA: {
                return new HanaTableSourceBuilder(wbConnection);
            }
            case Exasol: {
                return new ExasolTableSourceBuilder(wbConnection);
            }
        }
        return new TableSourceBuilder(wbConnection);
    }
}

