/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import workbench.db.DefaultTriggerReader;
import workbench.db.TriggerReader;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerTriggerReader;
import workbench.db.oracle.OracleTriggerReader;
import workbench.db.postgres.PostgresTriggerReader;
import workbench.db.postgres.PostgresUtil;

public class TriggerReaderFactory {
    public static TriggerReader createReader(WbConnection wbConnection) {
        if (wbConnection == null) {
            return null;
        }
        if (wbConnection.getMetadata() == null) {
            return null;
        }
        if (wbConnection.getMetadata().isPostgres() && !PostgresUtil.isRedshift(wbConnection)) {
            return new PostgresTriggerReader(wbConnection);
        }
        if (wbConnection.getMetadata().isOracle()) {
            return new OracleTriggerReader(wbConnection);
        }
        if (wbConnection.getMetadata().isSqlServer()) {
            return new SqlServerTriggerReader(wbConnection);
        }
        return new DefaultTriggerReader(wbConnection);
    }
}

