/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.TableGrant;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.derby.DerbyViewGrantReader;
import workbench.db.firebird.FirebirdViewGrantReader;
import workbench.db.hsqldb.HsqlViewGrantReader;
import workbench.db.ibm.Db2ViewGrantReader;
import workbench.db.oracle.OracleViewGrantReader;
import workbench.db.postgres.PostgresViewGrantReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public abstract class ViewGrantReader {
    public static ViewGrantReader createViewGrantReader(WbConnection wbConnection) {
        DbMetadata dbMetadata = wbConnection.getMetadata();
        String string = dbMetadata.getDbId();
        if (dbMetadata.isOracle()) {
            return new OracleViewGrantReader();
        }
        if (dbMetadata.isPostgres() || "h2".equals(string) || dbMetadata.isMySql()) {
            return new PostgresViewGrantReader();
        }
        if (dbMetadata.isHsql()) {
            return new HsqlViewGrantReader(wbConnection);
        }
        if (dbMetadata.isSqlServer() && JdbcUtils.hasMinimumServerVersion(wbConnection, "8.0")) {
            return new PostgresViewGrantReader();
        }
        if (dbMetadata.isFirebird()) {
            return new FirebirdViewGrantReader();
        }
        if (string.startsWith("db2")) {
            return new Db2ViewGrantReader(wbConnection);
        }
        if (dbMetadata.isApacheDerby()) {
            return new DerbyViewGrantReader();
        }
        return null;
    }

    public abstract String getViewGrantSql();

    public int getIndexForSchemaParameter() {
        return -1;
    }

    public int getIndexForCatalogParameter() {
        return -1;
    }

    public int getIndexForTableNameParameter() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TableGrant> getViewGrants(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        HashSet<TableGrant> hashSet = new HashSet<TableGrant>();
        String string = this.getViewGrantSql();
        if (string == null) {
            return Collections.emptyList();
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "view grants", string, new Object[0]);
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
            tableIdentifier2.adjustCase(wbConnection);
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string, 1003, 1007);
            int n = this.getIndexForSchemaParameter();
            if (n > 0) {
                preparedStatement.setString(n, tableIdentifier2.getSchema());
            }
            if ((n = this.getIndexForCatalogParameter()) > 0) {
                preparedStatement.setString(n, tableIdentifier2.getCatalog());
            }
            if ((n = this.getIndexForTableNameParameter()) > 0) {
                preparedStatement.setString(n, tableIdentifier2.getTableName());
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                boolean bl = StringUtil.stringToBool(resultSet.getString(3));
                TableGrant tableGrant = new TableGrant(string2, string3, bl);
                hashSet.add(tableGrant);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "view grants", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return hashSet;
    }

    public StringBuilder getViewGrantSource(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        Object object;
        String string;
        Collection<TableGrant> collection = this.getViewGrants(wbConnection, tableIdentifier);
        StringBuilder stringBuilder = new StringBuilder(200);
        int n = collection.size();
        HashMap<String, LinkedList<String>> hashMap = new HashMap<String, LinkedList<String>>(n);
        for (TableGrant object2 : collection) {
            string = object2.getGrantee();
            object = object2.getPrivilege();
            if (object == null) continue;
            LinkedList<String> linkedList = (LinkedList<String>)hashMap.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
                hashMap.put(string, linkedList);
            }
            linkedList.add(((String)object).trim());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            string = (String)entry.getKey();
            object = (List)entry.getValue();
            stringBuilder.append("GRANT ");
            stringBuilder.append(StringUtil.listToString((Collection)object, ", ", false));
            stringBuilder.append(" ON ");
            stringBuilder.append(tableIdentifier.getTableExpression(wbConnection));
            stringBuilder.append(" TO ");
            stringBuilder.append(string);
            stringBuilder.append(";\n");
        }
        return stringBuilder;
    }
}

