/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.compare;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObjectFinder;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.compare.RowDataComparer;
import workbench.db.compare.TableDiffStatus;
import workbench.db.exporter.BlobMode;
import workbench.interfaces.ErrorReporter;
import workbench.interfaces.ProgressReporter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.ColumnData;
import workbench.storage.ResultInfo;
import workbench.storage.RowActionMonitor;
import workbench.storage.RowData;
import workbench.storage.SqlLiteralFormatter;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.RowDataReaderFactory;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.MessageBuffer;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class TableDataDiff
implements ProgressReporter,
ErrorReporter {
    private WbConnection toSync;
    private WbConnection reference;
    private TableIdentifier referenceTable;
    private TableIdentifier tableToSync;
    private TableDefinition toSyncDef;
    private int chunkSize = 15;
    private Statement checkStatement;
    private RowActionMonitor monitor;
    private Writer updateWriter;
    private Writer insertWriter;
    private boolean firstUpdate;
    private boolean firstInsert;
    private SqlLiteralFormatter formatter;
    private List<ColumnIdentifier> pkColumns = new ArrayList<ColumnIdentifier>();
    private String lineEnding = "\n";
    private String encoding = "UTF-8";
    private boolean cancelExecution;
    private int progressInterval = 10;
    private Set<String> columnsToIgnore = CollectionUtil.caseInsensitiveSet();
    private RowDataComparer comparer;
    private MessageBuffer warnings = new MessageBuffer();
    private MessageBuffer errors = new MessageBuffer();
    private long currentRowNumber;
    private Map<String, Set<String>> alternateKeys;
    private Set<String> realPKCols = CollectionUtil.caseInsensitiveSet();
    private boolean excludeRealPK;
    private boolean excludeIgnoredColumns;
    private boolean ignoreMissingTarget;
    private String targetSchema;

    public TableDataDiff(WbConnection wbConnection, WbConnection wbConnection2) throws SQLException {
        this.toSync = wbConnection2;
        this.reference = wbConnection;
        this.formatter = new SqlLiteralFormatter(this.toSync);
        this.formatter.setDateLiteralType("jdbc");
        this.chunkSize = Settings.getInstance().getSyncChunkSize();
        this.comparer = new RowDataComparer();
        this.comparer.setConnection(this.toSync);
        this.comparer.setTypeSql();
        this.comparer.setApplySQLFormatting(Settings.getInstance().getDoFormatInserts() || Settings.getInstance().getDoFormatUpdates());
    }

    public void setTargetSchema(String string) {
        this.targetSchema = string;
    }

    public void setTypeXml(boolean bl) {
        this.comparer.setTypeXml(bl);
    }

    public void setTypeSql() {
        this.comparer.setTypeSql();
    }

    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.monitor = rowActionMonitor;
    }

    @Override
    public void addWarning(String string) {
        this.warnings.append(string);
        this.warnings.appendNewLine();
    }

    @Override
    public void addError(String string) {
        this.errors.append(string);
        this.errors.appendNewLine();
    }

    public void setExcludeRealPK(boolean bl) {
        this.excludeRealPK = bl;
    }

    public void setExcludeIgnoredColumns(boolean bl) {
        this.excludeIgnoredColumns = bl;
    }

    public void setIgnoreMissingTarget(boolean bl) {
        this.ignoreMissingTarget = bl;
    }

    public void setAlternateKeys(Map<String, Set<String>> map) {
        if (CollectionUtil.isEmpty(map)) {
            this.alternateKeys = null;
        } else {
            CaseInsensitiveComparator caseInsensitiveComparator = new CaseInsensitiveComparator();
            caseInsensitiveComparator.setIgnoreSQLQuotes(true);
            this.alternateKeys = new TreeMap<String, Set<String>>(caseInsensitiveComparator);
            this.alternateKeys.putAll(map);
        }
    }

    private Set<String> getAlternatePKs(String string) {
        if (this.alternateKeys == null) {
            return Collections.emptySet();
        }
        Set<String> set = this.alternateKeys.get(string);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public void setBlobMode(String string) {
        BlobMode blobMode = BlobMode.getMode(string);
        if (blobMode == null) {
            String string2 = ResourceMgr.getString("ErrExpInvalidBlobType");
            string2 = StringUtil.replace(string2, "%paramvalue%", string);
            this.addWarning(string2);
        } else {
            this.comparer.setSqlBlobMode(blobMode);
        }
    }

    public void setClobAsFile(String string, int n) {
        this.comparer.setClobAsFile(string, n);
    }

    public void setColumnsToIgnore(List<String> list) {
        this.columnsToIgnore.clear();
        if (list != null) {
            this.columnsToIgnore.addAll(list);
        }
    }

    @Override
    public void setReportInterval(int n) {
        this.progressInterval = n;
    }

    public void setSqlDateLiteralType(String string) {
        this.comparer.setSqlDateLiteralType(string);
    }

    public void setBaseDir(WbFile wbFile) {
        this.comparer.setBaseDir(wbFile);
    }

    public void setOutputWriters(Writer writer, Writer writer2, String string, String string2) {
        this.updateWriter = writer;
        this.insertWriter = writer2;
        this.lineEnding = string == null ? "\n" : string;
        this.encoding = string2;
    }

    public TableDiffStatus setTableName(TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2) throws SQLException {
        Object object2;
        this.firstUpdate = true;
        this.firstInsert = true;
        this.pkColumns.clear();
        this.realPKCols.clear();
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.reference);
        this.referenceTable = dbObjectFinder.findSelectableObject(tableIdentifier);
        if (this.referenceTable == null) {
            LogMgr.logError(new CallerInfo(){}, "Reference table " + tableIdentifier.getTableName() + " not found!", null);
            return TableDiffStatus.ReferenceNotFound;
        }
        List<ColumnIdentifier> list = this.reference.getMetadata().getTableColumns(this.referenceTable);
        Set<String> set = this.getAlternatePKs(tableIdentifier.getTableName());
        boolean bl = CollectionUtil.isNonEmpty(set);
        for (Object object2 : list) {
            if (!bl && object2.isPkColumn() || set.contains(object2.getColumnName())) {
                this.pkColumns.add((ColumnIdentifier)object2);
            }
            if (!bl || !object2.isPkColumn()) continue;
            this.realPKCols.add(object2.getColumnName());
        }
        if (CollectionUtil.isEmpty(this.pkColumns)) {
            return TableDiffStatus.NoPK;
        }
        DbObjectFinder dbObjectFinder2 = new DbObjectFinder(this.toSync);
        this.tableToSync = dbObjectFinder2.findSelectableObject(tableIdentifier2);
        if (this.tableToSync == null && !this.ignoreMissingTarget) {
            LogMgr.logError(new CallerInfo(){}, "Target table " + tableIdentifier2.getTableName() + " not found!", null);
            return TableDiffStatus.TargetNotFound;
        }
        object2 = TableDiffStatus.OK;
        if (this.tableToSync != null) {
            this.toSyncDef = this.toSync.getMetadata().getTableDefinition(this.tableToSync);
            this.tableToSync = this.toSyncDef.getTable();
            for (ColumnIdentifier columnIdentifier : list) {
                if (this.findTargetColumn(columnIdentifier) != null) continue;
                object2 = TableDiffStatus.ColumnMismatch;
                LogMgr.logError(new CallerInfo(){}, "Reference column " + columnIdentifier.getColumnName() + " not found in target table!", null);
            }
        }
        return object2;
    }

    public void cancel() {
        this.cancelExecution = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSync() throws SQLException, IOException {
        RowDataReader rowDataReader;
        Statement statement;
        ResultSet resultSet;
        block8: {
            String string = "SELECT * FROM " + this.referenceTable.getTableExpression(this.reference);
            LogMgr.logDebug(new CallerInfo(){}, "Using " + string + " to retrieve rows from reference database");
            this.checkStatement = this.toSync.createStatementForQuery();
            this.cancelExecution = false;
            resultSet = null;
            statement = null;
            this.currentRowNumber = 0L;
            rowDataReader = null;
            try {
                Object object;
                statement = this.reference.createStatementForQuery();
                resultSet = statement.executeQuery(string);
                ResultInfo resultInfo = new ResultInfo(resultSet.getMetaData(), this.reference);
                if (this.monitor != null) {
                    this.monitor.setMonitorType(7);
                    object = ResourceMgr.getFormattedString("MsgDataDiffProcessUpd", this.referenceTable.getTableName());
                    this.monitor.setCurrentObject((String)object, -1L, -1L);
                }
                object = new ArrayList(this.chunkSize);
                rowDataReader = RowDataReaderFactory.createReader(resultInfo, this.reference);
                while (resultSet.next() && !this.cancelExecution) {
                    RowData rowData = rowDataReader.read(resultSet, false);
                    object.add(rowData);
                    if (object.size() != this.chunkSize) continue;
                    this.checkRows((List<RowData>)object, resultInfo);
                    object.clear();
                    rowDataReader.closeStreams();
                }
                if (object.size() > 0 && !this.cancelExecution) {
                    this.checkRows((List<RowData>)object, resultInfo);
                }
                if (!this.firstUpdate) {
                    this.writeEnd(this.updateWriter);
                }
                if (this.firstInsert) break block8;
                this.writeEnd(this.insertWriter);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResult(resultSet);
                JdbcUtils.closeStatement(statement);
                JdbcUtils.closeStatement(this.checkStatement);
                if (rowDataReader != null) {
                    rowDataReader.closeStreams();
                }
                throw throwable;
            }
        }
        JdbcUtils.closeResult(resultSet);
        JdbcUtils.closeStatement(statement);
        JdbcUtils.closeStatement(this.checkStatement);
        if (rowDataReader != null) {
            rowDataReader.closeStreams();
        }
    }

    private void checkRows(List<RowData> list, ResultInfo resultInfo) throws SQLException, IOException {
        String string = this.buildCheckSql(list, resultInfo);
        ResultSet resultSet = null;
        RowDataReader rowDataReader = null;
        ResultInfo resultInfo2 = null;
        try {
            Object object;
            ArrayList<RowData> arrayList = new ArrayList<RowData>(list.size());
            if (string != null) {
                resultSet = this.checkStatement.executeQuery(string);
                resultInfo2 = new ResultInfo(resultSet.getMetaData(), this.toSync);
                resultInfo2.setPKColumns(this.pkColumns);
                resultInfo2.setUpdateTable(this.tableToSync);
                rowDataReader = RowDataReaderFactory.createReader(resultInfo2, this.toSync);
                while (resultSet.next()) {
                    object = rowDataReader.read(resultSet, false);
                    arrayList.add((RowData)object);
                    if (!this.cancelExecution) continue;
                    break;
                }
            } else {
                resultInfo2 = resultInfo.createCopy();
                resultInfo2.setPKColumns(this.pkColumns);
                object = this.referenceTable.createCopy();
                ((TableIdentifier)object).setSchema(this.targetSchema);
                if (((TableIdentifier)object).getSchema() == null) {
                    ((TableIdentifier)object).setSchema(this.toSync.getCurrentSchema());
                }
                resultInfo2.setUpdateTable(this.referenceTable);
            }
            if (this.currentRowNumber == 0L) {
                this.comparer.setResultInfo(resultInfo2);
            }
            for (RowData rowData : list) {
                String string2;
                if (this.cancelExecution) break;
                int n = this.findRowByPk(arrayList, resultInfo, rowData, resultInfo2);
                ++this.currentRowNumber;
                if (this.monitor != null && this.currentRowNumber % (long)this.progressInterval == 0L) {
                    this.monitor.setCurrentRow(this.currentRowNumber, -1L);
                }
                Writer writer = null;
                this.comparer.setRows(rowData, n > -1 ? (RowData)arrayList.get(n) : null);
                Set<String> set = CollectionUtil.caseInsensitiveSet();
                set.addAll(this.columnsToIgnore);
                set.addAll(this.realPKCols);
                this.comparer.ignoreColumns(set, resultInfo2);
                Set<String> set2 = CollectionUtil.caseInsensitiveSet();
                if (this.excludeRealPK && CollectionUtil.isNonEmpty(this.realPKCols)) {
                    set2.addAll(this.realPKCols);
                }
                if (this.excludeIgnoredColumns) {
                    set2.addAll(this.columnsToIgnore);
                }
                if (CollectionUtil.isNonEmpty(set2)) {
                    this.comparer.excludeColumns(set2, resultInfo);
                }
                if ((string2 = this.comparer.getMigration(this.currentRowNumber)) == null) continue;
                if (n > -1) {
                    if (this.firstUpdate) {
                        this.firstUpdate = false;
                        this.writeHeader(this.updateWriter);
                    }
                    writer = this.updateWriter;
                } else {
                    if (this.firstInsert) {
                        this.firstInsert = false;
                        this.writeHeader(this.insertWriter);
                    }
                    writer = this.insertWriter;
                }
                writer.write(string2);
                if (this.comparer.isTypeXml()) {
                    writer.write(this.lineEnding);
                    continue;
                }
                writer.write(this.lineEnding + this.lineEnding);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Error when running check SQL " + string, sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResult(resultSet);
                if (rowDataReader != null) {
                    rowDataReader.closeStreams();
                }
                throw throwable;
            }
        }
        JdbcUtils.closeResult(resultSet);
        if (rowDataReader != null) {
            rowDataReader.closeStreams();
        }
    }

    protected int findRowByPk(List<RowData> list, ResultInfo resultInfo, RowData rowData, ResultInfo resultInfo2) {
        if (resultInfo2 == null) {
            return -1;
        }
        if (rowData == null) {
            return -1;
        }
        int n = 0;
        for (RowData rowData2 : list) {
            int n2 = 0;
            for (ColumnIdentifier columnIdentifier : this.pkColumns) {
                Object object;
                int n3 = resultInfo2.findColumn(columnIdentifier.getColumnName());
                int n4 = resultInfo.findColumn(columnIdentifier.getColumnName());
                Object object2 = rowData2.getValue(n4);
                if (!RowData.objectsAreEqual(object2, object = rowData.getValue(n3), true)) continue;
                ++n2;
            }
            if (n2 == this.pkColumns.size()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String buildCheckSql(List<RowData> list, ResultInfo resultInfo) {
        int n;
        if (this.tableToSync == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append("SELECT ");
        for (n = 0; n < resultInfo.getColumnCount(); ++n) {
            ColumnIdentifier columnIdentifier = this.findTargetColumn(resultInfo.getColumn(n));
            if (columnIdentifier == null) continue;
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(columnIdentifier.getColumnName(this.toSync));
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.tableToSync.getTableExpression(this.toSync));
        stringBuilder.append(" WHERE ");
        for (n = 0; n < list.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(" OR ");
            }
            stringBuilder.append('(');
            int n2 = 0;
            for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
                ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
                if (!this.pkColumns.contains(columnIdentifier)) continue;
                if (n2 > 0) {
                    stringBuilder.append(" AND ");
                }
                ColumnIdentifier columnIdentifier2 = this.findTargetColumn(columnIdentifier);
                stringBuilder.append(columnIdentifier2.getColumnName(this.toSync));
                Object object = list.get(n).getValue(i);
                if (object == null) {
                    stringBuilder.append(" IS NULL");
                } else {
                    stringBuilder.append(" = ");
                    ColumnData columnData = new ColumnData(object, columnIdentifier);
                    stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
                }
                ++n2;
            }
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }

    private ColumnIdentifier findTargetColumn(ColumnIdentifier columnIdentifier) {
        String string = SqlUtil.removeObjectQuotes(columnIdentifier.getColumnName());
        for (ColumnIdentifier columnIdentifier2 : this.toSyncDef.getColumns()) {
            if (!SqlUtil.removeObjectQuotes(columnIdentifier2.getColumnName()).equalsIgnoreCase(string)) continue;
            return columnIdentifier2;
        }
        return null;
    }

    private void writeHeader(Writer writer) throws IOException {
        String string = "Generated by SQL Workbench/J at: " + StringUtil.getCurrentTimestampWithTZString();
        if (this.comparer.isTypeXml()) {
            writer.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            writer.write(this.lineEnding);
            writer.write("<!-- ");
            writer.write(string);
            writer.write(" -->");
            writer.write(this.lineEnding);
            TableDataDiff.writeTableNameTag(writer, "table-data-diff", this.tableToSync);
            writer.write(">");
            writer.write(this.lineEnding);
        } else {
            writer.write("-- ----------------------------------------------------------------");
            writer.write(this.lineEnding);
            writer.write("-- ");
            writer.write(string);
            writer.write(this.lineEnding);
            writer.write("-- ----------------------------------------------------------------");
            writer.write(this.lineEnding);
        }
    }

    public static void writeTableNameTag(Writer writer, String string, TableIdentifier tableIdentifier) throws IOException {
        writer.write("<" + string);
        writer.write(" name=\"");
        writer.write(tableIdentifier.getRawTableName());
        writer.write("\"");
        if (StringUtil.isNonEmpty(tableIdentifier.getRawSchema())) {
            writer.write(" schema=\"");
            writer.write(tableIdentifier.getRawSchema());
            writer.write("\"");
        }
        if (StringUtil.isNonEmpty(tableIdentifier.getRawCatalog())) {
            writer.write(" catalog=\"");
            writer.write(tableIdentifier.getRawCatalog());
            writer.write("\"");
        }
        writer.write(">");
    }

    private void writeEnd(Writer writer) throws IOException {
        if (this.comparer.isTypeXml()) {
            writer.write("</table-data-diff>");
            writer.write(this.lineEnding);
        }
    }
}

