/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.datacopy;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;
import workbench.db.JdbcUtils;
import workbench.db.ResultBufferingController;
import workbench.db.WbConnection;
import workbench.db.datacopy.DataCopier;
import workbench.db.importer.DataReceiver;
import workbench.db.importer.RowDataProducer;
import workbench.interfaces.JobErrorHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.reader.ResultSetHolder;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.RowDataReaderFactory;
import workbench.util.MessageBuffer;
import workbench.util.SqlUtil;
import workbench.util.ValueConverter;

public class QueryCopySource
implements RowDataProducer {
    private DataReceiver receiver;
    private volatile boolean keepRunning = true;
    private boolean regularStop = false;
    private WbConnection sourceConnection;
    private Statement retrieveStatement;
    private String retrieveSql;
    private boolean abortOnError;
    private boolean hasErrors = false;
    private boolean hasWarnings = false;
    private RowData currentRow;
    private ResultBufferingController resultBuffer;
    private boolean trimCharData;
    private int maxRows;

    public QueryCopySource(WbConnection wbConnection, String string) {
        this.sourceConnection = wbConnection;
        this.retrieveSql = SqlUtil.trimSemicolon(string);
        this.resultBuffer = new ResultBufferingController(wbConnection);
    }

    public void setTrimCharData(boolean bl) {
        this.trimCharData = bl;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    @Override
    public void setMessageBuffer(MessageBuffer messageBuffer) {
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Override
    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    @Override
    public void setValueConverter(ValueConverter valueConverter) {
    }

    @Override
    public void setReceiver(DataReceiver dataReceiver) {
        this.receiver = dataReceiver;
    }

    @Override
    public void start() throws Exception {
        LogMgr.logDebug(new CallerInfo(){}, "Using SQL: " + this.retrieveSql);
        ResultSet resultSet = null;
        this.keepRunning = true;
        this.regularStop = false;
        Savepoint savepoint = null;
        RowDataReader rowDataReader = null;
        try {
            this.resultBuffer.disableDriverBuffering();
            savepoint = DataCopier.setSourceSavepoint(this.sourceConnection);
            this.retrieveStatement = this.sourceConnection.createStatementForQuery();
            this.resultBuffer.initializeStatement(this.retrieveStatement);
            if (this.maxRows > -1) {
                this.retrieveStatement.setMaxRows(this.maxRows);
            }
            resultSet = this.retrieveStatement.executeQuery(this.retrieveSql);
            ResultInfo resultInfo = new ResultInfo(resultSet.getMetaData(), this.sourceConnection);
            rowDataReader = RowDataReaderFactory.createReader(resultInfo, this.sourceConnection);
            rowDataReader.setConverter(null);
            ResultSetHolder resultSetHolder = new ResultSetHolder(resultSet);
            while (this.keepRunning && resultSet.next()) {
                block12: {
                    this.currentRow = rowDataReader.read(resultSetHolder, this.trimCharData);
                    if (!this.keepRunning) break;
                    try {
                        this.receiver.processRow(this.currentRow.getData());
                    }
                    catch (SQLException sQLException) {
                        if (!this.abortOnError) break block12;
                        throw sQLException;
                    }
                }
                rowDataReader.closeStreams();
            }
            if (this.keepRunning || this.regularStop) {
                this.receiver.importFinished();
            } else {
                this.receiver.importCancelled();
            }
            this.sourceConnection.releaseSavepoint(savepoint);
            this.resultBuffer.disableDriverBuffering();
        }
        catch (Exception exception) {
            try {
                this.sourceConnection.rollback(savepoint);
                this.receiver.tableImportError();
                throw exception;
            }
            catch (Throwable throwable) {
                this.resultBuffer.disableDriverBuffering();
                JdbcUtils.closeAll(resultSet, this.retrieveStatement);
                if (rowDataReader != null) {
                    rowDataReader.closeStreams();
                }
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, this.retrieveStatement);
        if (rowDataReader != null) {
            rowDataReader.closeStreams();
        }
    }

    @Override
    public String getLastRecord() {
        if (this.currentRow == null) {
            return null;
        }
        return this.currentRow.toString();
    }

    @Override
    public void stop() {
        this.regularStop = true;
        this.cancel();
    }

    @Override
    public void cancel() {
        this.keepRunning = false;
        try {
            this.retrieveStatement.cancel();
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when cancelling retrieve", exception);
        }
    }

    @Override
    public Map<Integer, Object> getInputColumnValues(Collection<Integer> collection) {
        return null;
    }

    @Override
    public MessageBuffer getMessages() {
        return null;
    }

    @Override
    public void setAbortOnError(boolean bl) {
        this.abortOnError = bl;
    }

    @Override
    public void setErrorHandler(JobErrorHandler jobErrorHandler) {
    }
}

