/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.derby;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DerbySequenceReader
implements SequenceReader {
    private WbConnection dbConn;
    private String baseQuery;

    public DerbySequenceReader(WbConnection wbConnection) {
        this.dbConn = wbConnection;
        this.baseQuery = "SELECT sch.schemaname,  \n       seq.sequencename, \n       seq.sequencedatatype, \n       seq.currentvalue, \n       seq.startvalue, \n       seq.minimumvalue, \n       seq.maximumvalue, \n       seq.increment, \n       seq.cycleoption \nFROM sys.syssequences seq \n  JOIN sys.sysschemas sch ON sch.schemaid = seq.schemaid";
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>(dataStore.getRowCount());
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createSequenceDefinition(dataStore, i));
        }
        return arrayList;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() != 1) {
            return null;
        }
        return this.createSequenceDefinition(dataStore, 0);
    }

    private SequenceDefinition createSequenceDefinition(DataStore dataStore, int n) {
        String string = dataStore.getValueAsString(n, "sequencename");
        String string2 = dataStore.getValueAsString(n, "schemaname");
        SequenceDefinition sequenceDefinition = new SequenceDefinition(string2, string);
        sequenceDefinition.setSequenceProperty("start_value", dataStore.getValue(n, "startvalue"));
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(n, "minimumvalue"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(n, "maximumvalue"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "increment"));
        sequenceDefinition.setSequenceProperty("cycle", StringUtil.stringToBool(dataStore.getValueAsString(n, "cycleoption")));
        sequenceDefinition.setSequenceProperty("data_type", dataStore.getValueAsString(n, "sequencedatatype"));
        this.readSequenceSource(sequenceDefinition);
        return sequenceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(this.baseQuery.length() + 50);
        stringBuilder.append(this.baseQuery);
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append(" WHERE sch.schemaname = '").append(string2).append('\'');
            bl = true;
        }
        if (StringUtil.isNonBlank(string3)) {
            if (bl) {
                stringBuilder.append(" AND ");
            } else {
                stringBuilder.append(" WHERE ");
            }
            SqlUtil.appendExpression(stringBuilder, "seq.sequencename", string3, null);
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence definition", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        try {
            statement = this.dbConn.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            dataStore = new DataStore(resultSet, this.dbConn, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "sequence definition", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return null;
        }
        return sequenceDefinition.getSource();
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        StringBuilder stringBuilder = new StringBuilder(100);
        String string = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(sequenceDefinition.getSequenceName());
        Number number = (Number)sequenceDefinition.getSequenceProperty("start_value");
        Number number2 = (Number)sequenceDefinition.getSequenceProperty("min_value");
        Number number3 = (Number)sequenceDefinition.getSequenceProperty("max_value");
        Number number4 = (Number)sequenceDefinition.getSequenceProperty("increment");
        Boolean bl = (Boolean)sequenceDefinition.getSequenceProperty("cycle");
        String string2 = (String)sequenceDefinition.getSequenceProperty("data_type");
        stringBuilder.append(" AS ");
        stringBuilder.append(string2);
        stringBuilder.append(this.buildSequenceDetails(string2, number, number2, number3, number4, bl));
        stringBuilder.append(';');
        stringBuilder.append(string);
        sequenceDefinition.setSource(stringBuilder);
    }

    private CharSequence buildSequenceDetails(String string, Number number, Number number2, Number number3, Number number4, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(30);
        String string2 = Settings.getInstance().getInternalEditorLineEnding();
        String string3 = string2 + "       ";
        if (number.longValue() > 0L) {
            stringBuilder.append(string3);
            stringBuilder.append("START WITH ");
            stringBuilder.append(number);
        }
        stringBuilder.append(string3);
        stringBuilder.append(" INCREMENT BY ");
        stringBuilder.append(number4);
        stringBuilder.append(string3);
        boolean bl2 = false;
        if ("integer".equalsIgnoreCase(string)) {
            bl2 = number2 != null && number2.intValue() != Integer.MIN_VALUE;
        } else if ("bigint".equalsIgnoreCase(string)) {
            boolean bl3 = bl2 = number2 != null && number2.longValue() != Long.MIN_VALUE;
        }
        if (bl2) {
            stringBuilder.append(" MINVALUE ");
            stringBuilder.append(number2);
        } else {
            stringBuilder.append(" NO MINVALUE");
        }
        stringBuilder.append(string3);
        if (number3 != null && number3.longValue() == -1L) {
            if (number3.longValue() != Long.MAX_VALUE) {
                stringBuilder.append(" MAXVALUE ");
                stringBuilder.append(number3);
            }
        } else {
            stringBuilder.append(" NO MAXVALUE");
        }
        stringBuilder.append(string3);
        if (bl) {
            stringBuilder.append(" CYCLE");
        } else {
            stringBuilder.append(" NO CYCLE");
        }
        return stringBuilder;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

