/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.diff;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import workbench.db.ConnectionInfoBuilder;
import workbench.db.DbMetadata;
import workbench.db.DbObjectFinder;
import workbench.db.DbSettings;
import workbench.db.FKHandler;
import workbench.db.ProcedureDefinition;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.diff.DiffEntry;
import workbench.db.diff.GenericDiffLoader;
import workbench.db.diff.PackageDiff;
import workbench.db.diff.PackageDiffEntry;
import workbench.db.diff.ProcDiff;
import workbench.db.diff.ProcDiffEntry;
import workbench.db.diff.SequenceDiff;
import workbench.db.diff.SequenceDiffEntry;
import workbench.db.diff.TableDiff;
import workbench.db.diff.ViewDiff;
import workbench.db.oracle.OracleProcedureReader;
import workbench.db.report.ReportPackage;
import workbench.db.report.ReportProcedure;
import workbench.db.report.ReportSequence;
import workbench.db.report.ReportTable;
import workbench.db.report.ReportView;
import workbench.db.report.TagWriter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class SchemaDiff {
    public static final String TAG_ADD_TABLE = "add-table";
    public static final String TAG_ADD_VIEW = "add-view";
    public static final String TAG_DROP_TABLE = "drop-table";
    public static final String TAG_DROP_VIEW = "drop-view";
    public static final String TAG_DROP_PROC = "drop-procedure";
    public static final String TAG_ADD_PROC = "add-procedure";
    public static final String TAG_DROP_SEQUENCE = "drop-sequence";
    public static final String TAG_DROP_PCKG = "drop-package";
    public static final String TAG_REF_CONN = "reference-connection";
    public static final String TAG_TARGET_CONN = "target-connection";
    public static final String TAG_COMPARE_INFO = "compare-settings";
    public static final String TAG_VIEW_PAIR = "view-info";
    public static final String TAG_TABLE_PAIR = "table-info";
    public static final String TAG_PROC_PAIR = "procedure-info";
    public static final String TAG_PKG_PAIR = "package-info";
    public static final String TAG_SEQ_PAIR = "sequence-info";
    public static final String TAG_INDEX_INFO = "include-index";
    public static final String TAG_FK_INFO = "include-foreign-key";
    public static final String TAG_PK_INFO = "include-primary-key";
    public static final String TAG_GRANT_INFO = "include-tablegrants";
    public static final String TAG_CONSTRAINT_INFO = "include-constraints";
    public static final String TAG_TRIGGER_INFO = "include-triggers";
    public static final String TAG_TYPES = "included-types";
    public static final String TAG_VIEW_INFO = "include-views";
    public static final String USE_JDBC_TYPES = "use-jdbc-types";
    public static final String TAG_PROC_INFO = "include-procs";
    public static final String TAG_SEQUENCE_INFO = "include-sequences";
    public static final String TAG_VIEWS_AS_TABLE = "views-as-tables";
    public static final String TAG_FULL_SOURCE = "full-object-source";
    private GenericDiffLoader objectDiffs;
    private List<Object> objectsToCompare;
    private List<TableIdentifier> tablesToDelete;
    private List<ProcedureDefinition> procsToDelete;
    private List<ReportPackage> packagesToDelete;
    private List<TableIdentifier> viewsToDelete;
    private List<SequenceDefinition> sequencesToDelete;
    private String encoding = "UTF-8";
    private boolean compareJdbcTypes;
    private boolean diffIndex = true;
    private boolean diffForeignKeys = true;
    private boolean diffPrimaryKeys = true;
    private boolean diffConstraints;
    private boolean diffGrants;
    private boolean diffViews = true;
    private boolean diffProcs = true;
    private boolean diffTriggers = true;
    private boolean diffSequences = true;
    private boolean diffPartitions;
    private boolean useFullSource;
    private boolean treatViewAsTable;
    private boolean compareConstraintsByName;
    private String[] additionalTypes;
    private RowActionMonitor monitor;
    private boolean cancel;
    private WbConnection referenceDb;
    private WbConnection targetDb;
    private String referenceSchema;
    private String targetSchema;
    private final Set<String> tablesToIgnore = CollectionUtil.caseInsensitiveSet();

    public SchemaDiff() {
    }

    public SchemaDiff(WbConnection wbConnection, WbConnection wbConnection2) {
        this.referenceDb = wbConnection;
        this.targetDb = wbConnection2;
    }

    public void setCompareConstraintsByName(boolean bl) {
        this.compareConstraintsByName = bl;
    }

    public void setIncludeTriggers(boolean bl) {
        this.diffTriggers = bl;
    }

    public void setIncludePartitions(boolean bl) {
        this.diffPartitions = bl;
    }

    public void setAdditionalTypes(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            this.additionalTypes = null;
            return;
        }
        this.additionalTypes = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.additionalTypes[i] = list.get(i).toUpperCase();
        }
    }

    public boolean isSameDBMS() {
        return this.referenceDb.getDbId().equalsIgnoreCase(this.targetDb.getDbId());
    }

    public void setUseFullObjectSource(boolean bl) {
        this.useFullSource = bl;
    }

    public void setIncludeSequences(boolean bl) {
        this.diffSequences = bl;
    }

    public void setIncludeForeignKeys(boolean bl) {
        this.diffForeignKeys = bl;
    }

    public boolean getIncludeForeignKeys() {
        return this.diffForeignKeys;
    }

    public void setIncludeIndex(boolean bl) {
        this.diffIndex = bl;
    }

    public boolean getIncludeIndex() {
        return this.diffIndex;
    }

    public void setIncludePrimaryKeys(boolean bl) {
        this.diffPrimaryKeys = bl;
    }

    public void setIncludeTableConstraints(boolean bl) {
        this.diffConstraints = bl;
    }

    public void setCompareJdbcTypes(boolean bl) {
        this.compareJdbcTypes = bl;
    }

    public boolean getCompareJdbcTypes() {
        return this.compareJdbcTypes;
    }

    public void setIncludeViews(boolean bl) {
        this.diffViews = bl;
    }

    public void setIncludeProcedures(boolean bl) {
        this.diffProcs = bl;
    }

    public void setIncludeTableGrants(boolean bl) {
        this.diffGrants = bl;
    }

    public boolean getIncludeTableGrants() {
        return this.diffGrants;
    }

    public void setTreatViewAsTable(boolean bl) {
        this.treatViewAsTable = bl;
    }

    public void setMonitor(RowActionMonitor rowActionMonitor) {
        this.monitor = rowActionMonitor;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public void setTableNames(List<String> list, List<String> list2) throws SQLException {
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(list.size());
        ArrayList<TableIdentifier> arrayList2 = new ArrayList<TableIdentifier>(list2.size());
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("Size of lists does not match");
        }
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.referenceDb);
        DbObjectFinder dbObjectFinder2 = new DbObjectFinder(this.targetDb);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            TableIdentifier tableIdentifier = dbObjectFinder.findTable(new TableIdentifier(string, this.referenceDb), false);
            String string2 = list2.get(i);
            TableIdentifier tableIdentifier2 = dbObjectFinder2.findTable(new TableIdentifier(string2, this.targetDb), false);
            if (tableIdentifier != null && tableIdentifier2 != null) {
                arrayList.add(tableIdentifier);
                arrayList2.add(tableIdentifier2);
                continue;
            }
            LogMgr.logWarning(new CallerInfo(){}, "Table combination not found: " + string + " [" + tableIdentifier + "] to " + string2 + " [" + tableIdentifier2 + "]");
        }
        this.setTables(arrayList, arrayList2);
    }

    public void setTables(List<TableIdentifier> list, List<TableIdentifier> list2) throws SQLException {
        if (list == null) {
            throw new NullPointerException("Source tables may not be null");
        }
        if (list2 == null) {
            throw new NullPointerException("Target tables may not be null");
        }
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("Number of source and target tables have to match");
        }
        int n = list.size();
        this.objectsToCompare = new ArrayList<Object>(n);
        if (this.monitor != null) {
            this.monitor.setMonitorType(5);
            this.monitor.setCurrentObject(ResourceMgr.getString("MsgDiffRetrieveDbInfo"), -1L, -1L);
        }
        for (int i = 0; i < n; ++i) {
            if (this.cancel) {
                this.objectsToCompare = null;
                break;
            }
            TableIdentifier tableIdentifier = list.get(i);
            if (tableIdentifier == null) continue;
            TableIdentifier tableIdentifier2 = list2.get(i);
            DiffEntry diffEntry = new DiffEntry(tableIdentifier, tableIdentifier2);
            this.objectsToCompare.add(diffEntry);
        }
    }

    private ReportView createReportViewInstance(TableIdentifier tableIdentifier, WbConnection wbConnection) throws SQLException {
        tableIdentifier.adjustCase(wbConnection);
        ReportView reportView = new ReportView(tableIdentifier, wbConnection, this.diffIndex, this.diffGrants, this.useFullSource);
        return reportView;
    }

    private ReportTable createReportTableInstance(TableIdentifier tableIdentifier, WbConnection wbConnection) throws SQLException {
        tableIdentifier.adjustCase(wbConnection);
        ReportTable reportTable = new ReportTable(tableIdentifier, wbConnection, this.diffIndex, this.diffForeignKeys, this.diffPrimaryKeys, this.diffConstraints, this.diffGrants, this.diffTriggers, this.diffPartitions);
        return reportTable;
    }

    public void setExcludeTables(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            this.tablesToIgnore.clear();
            return;
        }
        String[] stringArray = this.getTableTypesToUse();
        for (String string : list) {
            if (this.cancel) {
                return;
            }
            if (string.indexOf(37) > -1 || string.indexOf(42) > -1) {
                try {
                    String string2 = this.referenceDb.getMetadata().adjustObjectnameCase(string.trim());
                    List<TableIdentifier> list2 = this.referenceDb.getMetadata().getObjectList(string2, this.getReferenceCatalog(this.referenceSchema), this.getReferenceSchema(this.referenceSchema), stringArray);
                    for (TableIdentifier tableIdentifier : list2) {
                        this.tablesToIgnore.add(tableIdentifier.getTableName());
                    }
                    string2 = this.targetDb.getMetadata().adjustObjectnameCase(string.trim());
                    list2 = this.targetDb.getMetadata().getObjectList(string2, this.getTargetCatalog(this.targetSchema), this.getTargetSchema(this.targetSchema), stringArray);
                    for (TableIdentifier tableIdentifier : list2) {
                        this.tablesToIgnore.add(tableIdentifier.getTableName());
                    }
                    continue;
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Could not retrieve excluded tables", sQLException);
                    continue;
                }
            }
            this.tablesToIgnore.add(string);
        }
    }

    public void compareAll() throws SQLException {
        this.setSchemas(null, null);
    }

    public void setSchemaNames(String string, String string2) {
        this.referenceSchema = string;
        this.targetSchema = string2;
    }

    private String[] getTableTypesToUse() {
        if (this.diffViews || this.treatViewAsTable) {
            return this.referenceDb.getMetadata().getTablesAndViewTypes();
        }
        return this.referenceDb.getMetadata().getTableTypesArray();
    }

    public void setSchemas(String string, String string2) throws SQLException {
        if (this.monitor != null) {
            this.monitor.setMonitorType(7);
            this.monitor.setCurrentObject(ResourceMgr.getString("MsgDiffRetrieveDbInfo"), -1L, -1L);
        }
        this.referenceSchema = string == null ? (this.referenceDb.getDbSettings().supportsSchemas() ? this.referenceDb.getMetadata().getCurrentSchema() : this.referenceDb.getMetadata().getCurrentCatalog()) : this.referenceDb.getMetadata().adjustSchemaNameCase(string);
        this.targetSchema = string2 == null ? (this.targetDb.getDbSettings().supportsSchemas() ? this.targetDb.getMetadata().getCurrentSchema() : this.targetDb.getMetadata().getCurrentCatalog()) : this.referenceDb.getMetadata().adjustSchemaNameCase(string2);
        String[] stringArray = this.getTableTypesToUse();
        List<TableIdentifier> list = this.referenceDb.getMetadata().getObjectList(null, this.getReferenceCatalog(this.referenceSchema), this.getReferenceSchema(this.referenceSchema), stringArray);
        if (this.cancel) {
            return;
        }
        List<TableIdentifier> list2 = this.targetDb.getMetadata().getObjectList(null, this.getTargetCatalog(this.targetSchema), this.getTargetSchema(this.targetSchema), stringArray);
        if (this.cancel) {
            return;
        }
        if (this.treatViewAsTable) {
            String string3 = this.referenceDb.getMetadata().getViewTypeName();
            String string4 = this.referenceDb.getMetadata().getBaseTableTypeName();
            for (TableIdentifier tableIdentifier : list) {
                if (!tableIdentifier.getType().equals(string3)) continue;
                tableIdentifier.setType(string4);
            }
        }
        if (this.cancel) {
            return;
        }
        this.processTableList(list, list2);
    }

    private String getTargetCatalog(String string) {
        if (this.targetDb.getDbSettings().supportsSchemas()) {
            return null;
        }
        return string;
    }

    private String getTargetSchema(String string) {
        if (this.targetDb.getDbSettings().supportsSchemas()) {
            return string;
        }
        return null;
    }

    private String getReferenceCatalog(String string) {
        if (this.referenceDb.getDbSettings().supportsSchemas()) {
            return null;
        }
        return string;
    }

    private String getReferenceSchema(String string) {
        if (this.referenceDb.getDbSettings().supportsSchemas()) {
            return string;
        }
        return null;
    }

    private void buildSequenceList() {
        try {
            List<SequenceDefinition> list = Collections.emptyList();
            List<SequenceDefinition> list2 = Collections.emptyList();
            SequenceReader sequenceReader = this.referenceDb.getMetadata().getSequenceReader();
            SequenceReader sequenceReader2 = this.targetDb.getMetadata().getSequenceReader();
            if (sequenceReader != null) {
                list = sequenceReader.getSequences(null, this.referenceSchema, null);
            }
            if (sequenceReader2 != null) {
                list2 = sequenceReader2.getSequences(null, this.targetSchema, null);
            }
            this.processSequenceList(list, list2);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving procedures", sQLException);
        }
    }

    private void buildProcedureList() {
        try {
            List<ProcedureDefinition> list = this.referenceDb.getMetadata().getProcedureReader().getProcedureList(this.getReferenceCatalog(this.referenceSchema), this.getReferenceSchema(this.referenceSchema), null);
            List<ProcedureDefinition> list2 = this.targetDb.getMetadata().getProcedureReader().getProcedureList(this.getTargetCatalog(this.targetSchema), this.getTargetSchema(this.targetSchema), null);
            this.processProcedureList(list, list2);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving procedures", sQLException);
        }
    }

    private void processTableList(List<TableIdentifier> list, List<TableIdentifier> list2) throws SQLException {
        Object object;
        Object object2;
        int n = list.size();
        HashSet<Object> hashSet = new HashSet<Object>();
        this.objectsToCompare = new ArrayList<Object>(n);
        if (this.monitor != null) {
            this.monitor.setMonitorType(7);
        }
        for (int i = 0; i < n; ++i) {
            if (this.cancel) {
                this.objectsToCompare = null;
                break;
            }
            TableIdentifier tableIdentifier = list.get(i);
            object2 = SqlUtil.removeObjectQuotes(tableIdentifier.getTableName());
            if (this.tablesToIgnore.contains(object2)) continue;
            if (this.monitor != null) {
                this.monitor.setCurrentObject(ResourceMgr.getFormattedString("MsgLoadTableInfo", object2), -1L, -1L);
            }
            object = this.findTargetTable(tableIdentifier, list2);
            DiffEntry diffEntry = new DiffEntry(tableIdentifier, (TableIdentifier)object);
            this.objectsToCompare.add(diffEntry);
            hashSet.add(object2);
        }
        if (this.cancel) {
            return;
        }
        this.tablesToDelete = new ArrayList<TableIdentifier>();
        this.viewsToDelete = new ArrayList<TableIdentifier>();
        if (list2 != null) {
            DbMetadata dbMetadata = this.targetDb.getMetadata();
            n = list2.size();
            for (int i = 0; i < n; ++i) {
                object2 = list2.get(i);
                object = SqlUtil.removeObjectQuotes(((TableIdentifier)object2).getTableName());
                if (this.tablesToIgnore.contains(object)) continue;
                if (this.targetDb.getMetadata().isDefaultCase((String)object)) {
                    object = this.referenceDb.getMetadata().adjustObjectnameCase((String)object);
                }
                if (hashSet.contains(object)) continue;
                if (dbMetadata.isTableType(((TableIdentifier)object2).getType())) {
                    this.tablesToDelete.add((TableIdentifier)object2);
                    continue;
                }
                this.viewsToDelete.add((TableIdentifier)object2);
            }
        }
    }

    private TableIdentifier findTargetTable(TableIdentifier tableIdentifier, List<TableIdentifier> list) {
        boolean bl = this.referenceDb.getMetadata().isDefaultCase(tableIdentifier.getTableName());
        TableIdentifier tableIdentifier2 = tableIdentifier.createCopy();
        if (bl || !this.targetDb.getMetadata().needsQuotes(tableIdentifier.getTableName())) {
            tableIdentifier2.setNeverAdjustCase(false);
            tableIdentifier2.adjustCase(this.targetDb);
        }
        tableIdentifier2.setSchema(this.targetSchema);
        tableIdentifier2.setCatalog(null);
        TableIdentifier tableIdentifier3 = TableIdentifier.findTableByNameAndSchema(list, tableIdentifier2);
        if (tableIdentifier3 != null) {
            return tableIdentifier3;
        }
        tableIdentifier3 = TableIdentifier.findTableByName(list, tableIdentifier2);
        if (tableIdentifier3 != null) {
            return tableIdentifier3;
        }
        tableIdentifier2.setType(tableIdentifier.getType());
        return new DbObjectFinder(this.targetDb).findObject(tableIdentifier2);
    }

    private void processSequenceList(List<SequenceDefinition> list, List<SequenceDefinition> list2) {
        this.sequencesToDelete = new ArrayList<SequenceDefinition>();
        if (this.monitor != null) {
            this.monitor.setMonitorType(7);
        }
        SequenceReader sequenceReader = this.targetDb.getMetadata().getSequenceReader();
        for (SequenceDefinition sequenceDefinition : list) {
            if (this.cancel) {
                this.objectsToCompare = null;
                break;
            }
            if (this.monitor != null) {
                this.monitor.setCurrentObject(ResourceMgr.getFormattedString("MsgLoadSeqInfo", sequenceDefinition.getSequenceName()), -1L, -1L);
            }
            if (sequenceReader == null) continue;
            SequenceDefinition sequenceDefinition2 = this.findSequence(list2, this.targetSchema, sequenceDefinition.getSequenceName());
            SequenceDiffEntry sequenceDiffEntry = new SequenceDiffEntry(sequenceDefinition, sequenceDefinition2);
            this.objectsToCompare.add(sequenceDiffEntry);
        }
        if (this.cancel) {
            return;
        }
        for (SequenceDefinition sequenceDefinition : list2) {
            if (this.findSequence(list, this.referenceSchema, sequenceDefinition.getSequenceName()) != null) continue;
            this.sequencesToDelete.add(sequenceDefinition);
        }
    }

    private SequenceDefinition findSequence(List<SequenceDefinition> list, String string, String string2) {
        for (SequenceDefinition sequenceDefinition : list) {
            if (!StringUtil.equalStringIgnoreCase(sequenceDefinition.getObjectName(), string2) || sequenceDefinition.getSchema() == null || string == null || !StringUtil.equalStringIgnoreCase(sequenceDefinition.getSchema(), string)) continue;
            return sequenceDefinition;
        }
        return null;
    }

    private void buildObjectsList() {
        if (this.additionalTypes != null) {
            this.objectDiffs = new GenericDiffLoader(this.referenceDb, this.targetDb, this.referenceSchema, this.targetSchema, this.additionalTypes);
            this.objectDiffs.setProgressMonitor(this.monitor);
            this.objectDiffs.loadObjects();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processProcedureList(List<ProcedureDefinition> list, List<ProcedureDefinition> list2) {
        Object object;
        Object object2;
        HashSet<String> hashSet = new HashSet<String>();
        this.procsToDelete = new ArrayList<ProcedureDefinition>();
        this.packagesToDelete = new ArrayList<ReportPackage>();
        HashSet<ReportPackage> hashSet2 = new HashSet<ReportPackage>();
        DbMetadata dbMetadata = this.targetDb.getMetadata();
        if (this.monitor != null) {
            this.monitor.setMonitorType(7);
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        if (list2 == null) {
            list2 = Collections.emptyList();
        }
        for (ProcedureDefinition object4 : list) {
            if (object4.isOracleObjectType()) continue;
            if (this.cancel) {
                this.objectsToCompare = null;
                break;
            }
            if (this.monitor != null) {
                this.monitor.setCurrentObject(ResourceMgr.getFormattedString("MsgLoadProcInfo", object4.getProcedureName()), -1L, -1L);
            }
            if (object4.isPackageProcedure()) {
                object2 = new ReportPackage(object4);
                if (!hashSet2.contains(object2)) {
                    hashSet2.add((ReportPackage)object2);
                    if (dbMetadata.isOracle()) {
                        void var8_14;
                        object = (OracleProcedureReader)dbMetadata.getProcedureReader();
                        boolean bl = ((OracleProcedureReader)object).packageExists(this.targetSchema, object4.getPackageName());
                        if (bl) {
                            ReportPackage reportPackage = new ReportPackage(this.targetSchema, object4.getPackageName());
                            PackageDiffEntry packageDiffEntry = new PackageDiffEntry((ReportPackage)object2, reportPackage);
                        } else {
                            PackageDiffEntry packageDiffEntry = new PackageDiffEntry((ReportPackage)object2, null);
                        }
                        this.objectsToCompare.add(var8_14);
                    }
                }
            } else {
                void var8_17;
                object2 = new ProcedureDefinition(this.getTargetCatalog(this.targetSchema), this.getTargetSchema(this.targetSchema), object4.getProcedureName(), object4.getResultType());
                ((ProcedureDefinition)object2).setParameters(object4.getParameters(this.referenceDb));
                object = dbMetadata.getProcedureReader().findProcedureDefinition((ProcedureDefinition)object2);
                if (object != null) {
                    ProcDiffEntry procDiffEntry = new ProcDiffEntry(object4, (ProcedureDefinition)object);
                } else {
                    ProcDiffEntry procDiffEntry = new ProcDiffEntry(object4, null);
                }
                this.objectsToCompare.add(var8_17);
            }
            hashSet.add(object4.getDisplayName());
        }
        for (ProcedureDefinition procedureDefinition : list2) {
            if (procedureDefinition.isOracleObjectType() || procedureDefinition.isPackageProcedure()) continue;
            if (this.cancel) {
                this.objectsToCompare = null;
                break;
            }
            String string = procedureDefinition.getDisplayName();
            if (hashSet.contains(string)) continue;
            this.procsToDelete.add(procedureDefinition);
        }
        if (dbMetadata.isOracle()) {
            HashSet hashSet3 = new HashSet();
            for (ProcedureDefinition procedureDefinition : list2) {
                if (!procedureDefinition.isPackageProcedure()) continue;
                if (this.cancel) {
                    this.objectsToCompare = null;
                    break;
                }
                object2 = new ReportPackage(procedureDefinition);
                if (hashSet3.contains(object2)) continue;
                object = this.findPackage(hashSet2, procedureDefinition.getPackageName());
                if (object == null) {
                    this.packagesToDelete.add((ReportPackage)object2);
                }
                hashSet3.add(object2);
            }
        }
    }

    private ReportPackage findPackage(Collection<ReportPackage> collection, String string) {
        for (ReportPackage reportPackage : collection) {
            if (!reportPackage.getPackageName().equals(string)) continue;
            return reportPackage;
        }
        return null;
    }

    public void setTables(List<TableIdentifier> list) throws SQLException {
        this.processTableList(list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMigrateTargetXml() {
        StringWriter stringWriter = new StringWriter(5000);
        FKHandler fKHandler = FKHandler.createInstance(this.referenceDb);
        FKHandler fKHandler2 = FKHandler.createInstance(this.targetDb);
        try {
            fKHandler.initializeSharedCache();
            fKHandler2.initializeSharedCache();
            this.writeXml(stringWriter);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error generating migration XML", exception);
        }
        finally {
            fKHandler.clearSharedCache();
            fKHandler2.clearSharedCache();
        }
        return stringWriter.toString();
    }

    public void setEncoding(String string) {
        if (StringUtil.isNonBlank(string)) {
            this.encoding = string;
        }
    }

    public void writeXml(Writer writer) throws IOException {
        StringBuilder stringBuilder;
        if (this.diffProcs) {
            this.buildProcedureList();
        }
        if (this.diffSequences) {
            this.buildSequenceList();
        }
        this.buildObjectsList();
        if (this.objectsToCompare == null && (this.objectDiffs == null || this.objectDiffs.getObjectCount() == 0)) {
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder("  ");
        StringBuilder stringBuilder3 = new StringBuilder("    ");
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(this.encoding);
        writer.write("\"?>\n");
        if (this.monitor != null) {
            this.monitor.setMonitorType(5);
        }
        this.writeTag(writer, null, "schema-diff", true);
        this.writeDiffInfo(writer);
        int n = this.objectsToCompare.size();
        ArrayList<ViewDiff> arrayList = new ArrayList<ViewDiff>();
        for (int i = 0; i < n; ++i) {
            Object object = this.objectsToCompare.get(i);
            if (object instanceof ProcDiffEntry || object instanceof SequenceDiffEntry || object instanceof PackageDiffEntry) continue;
            DiffEntry diffEntry = (DiffEntry)object;
            if (this.cancel) break;
            if (this.monitor != null) {
                this.monitor.setCurrentObject(diffEntry.reference.getTableExpression(), i + 1, n);
            }
            try {
                Object object2;
                Object object3;
                Object object4;
                String string = diffEntry.reference.getType();
                if (this.referenceDb.getMetadata().isTableType(string) && !string.equals(this.referenceDb.getMetadata().getMViewTypeName())) {
                    object4 = this.createReportTableInstance(diffEntry.reference, this.referenceDb);
                    if (diffEntry.target == null) {
                        writer.write("\n");
                        this.writeTag(writer, stringBuilder2, TAG_ADD_TABLE, true, "name", diffEntry.reference.getTableName());
                        object3 = ((ReportTable)object4).getXml(stringBuilder3);
                        writer.write(((StringBuilder)object3).toString());
                        this.writeTag(writer, stringBuilder2, TAG_ADD_TABLE, false);
                        continue;
                    }
                    object3 = this.createReportTableInstance(diffEntry.target, this.targetDb);
                    object2 = new TableDiff((ReportTable)object4, (ReportTable)object3, this);
                    ((TableDiff)object2).setIndent(stringBuilder2);
                    ((TableDiff)object2).setExactConstraintMatch(this.compareConstraintsByName);
                    StringBuilder stringBuilder4 = ((TableDiff)object2).getMigrateTargetXml();
                    if (stringBuilder4.length() <= 0) continue;
                    writer.write("\n");
                    writer.write(stringBuilder4.toString());
                    continue;
                }
                object4 = this.createReportViewInstance(diffEntry.reference, this.referenceDb);
                object3 = null;
                if (diffEntry.target != null) {
                    object3 = this.createReportViewInstance(diffEntry.target, this.targetDb);
                }
                object2 = new ViewDiff((ReportView)object4, (ReportView)object3);
                ((ViewDiff)object2).setIndent(stringBuilder2);
                arrayList.add((ViewDiff)object2);
                continue;
            }
            catch (SQLException sQLException) {
                LogMgr.logError(new CallerInfo(){}, "Error comparing " + diffEntry.toString(), sQLException);
            }
        }
        if (this.cancel) {
            return;
        }
        this.appendDropTables(writer, stringBuilder2);
        writer.write("\n");
        if (this.diffViews) {
            this.appendViewDiff(arrayList, writer);
            this.appendDropViews(writer, stringBuilder2);
        }
        if (this.cancel) {
            return;
        }
        if (this.diffSequences) {
            this.appendSequenceDiff(writer, stringBuilder2);
            writer.write("\n");
        }
        if (this.cancel) {
            return;
        }
        if (this.diffProcs) {
            this.appendProcDiff(writer, stringBuilder2);
            this.appendPackageDiff(writer, stringBuilder2);
            writer.write("\n");
        }
        if (this.cancel) {
            return;
        }
        if (this.objectDiffs != null && (stringBuilder = this.objectDiffs.getMigrateTargetXml(stringBuilder2)) != null && stringBuilder.length() > 0) {
            writer.write(stringBuilder.toString());
        }
        this.writeTag(writer, null, "schema-diff", false);
    }

    private void appendSequenceDiff(Writer writer, StringBuilder stringBuilder) throws IOException {
        Object object;
        int n = this.objectsToCompare.size();
        for (int i = 0; i < n; ++i) {
            object = this.objectsToCompare.get(i);
            if (!(object instanceof SequenceDiffEntry)) continue;
            SequenceDiffEntry sequenceDiffEntry = (SequenceDiffEntry)object;
            ReportSequence object2 = new ReportSequence(sequenceDiffEntry.reference);
            ReportSequence reportSequence = sequenceDiffEntry.target == null ? null : new ReportSequence(sequenceDiffEntry.target);
            SequenceDiff sequenceDiff = new SequenceDiff(object2, reportSequence, this.targetSchema);
            sequenceDiff.setIndent(stringBuilder);
            StringBuilder stringBuilder2 = sequenceDiff.getMigrateTargetXml();
            if (stringBuilder2.length() <= 0) continue;
            writer.write("\n");
            writer.write(stringBuilder2.toString());
        }
        if (this.sequencesToDelete == null || this.sequencesToDelete.isEmpty()) {
            return;
        }
        writer.write(10);
        this.writeTag(writer, stringBuilder, TAG_DROP_SEQUENCE, true);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        object = new StringBuilder(stringBuilder3);
        ((StringBuilder)object).append("  ");
        for (SequenceDefinition sequenceDefinition : this.sequencesToDelete) {
            this.writeTag(writer, stringBuilder3, "sequence-def", true);
            if (StringUtil.isNonEmpty(sequenceDefinition.getCatalog())) {
                this.writeTagValue(writer, (StringBuilder)object, "sequence-catalog", sequenceDefinition.getCatalog());
            }
            this.writeTagValue(writer, (StringBuilder)object, "sequence-schema", sequenceDefinition.getSchema());
            this.writeTagValue(writer, (StringBuilder)object, "sequence-name", sequenceDefinition.getSequenceName());
            this.writeTag(writer, stringBuilder3, "sequence-def", false);
        }
        this.writeTag(writer, stringBuilder, TAG_DROP_SEQUENCE, false);
    }

    private void appendProcDiff(Writer writer, StringBuilder stringBuilder) throws IOException {
        Object object;
        ReportProcedure reportProcedure;
        int n = this.objectsToCompare.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Iterator<ProcedureDefinition> iterator = this.objectsToCompare.get(i);
            if (!(iterator instanceof ProcDiffEntry)) continue;
            ProcDiffEntry object2 = (ProcDiffEntry)((Object)iterator);
            reportProcedure = new ReportProcedure(object2.reference, this.referenceDb);
            object = new ReportProcedure(object2.target, this.targetDb);
            String string2 = string = ((ReportProcedure)object).getSchema() == null ? this.targetSchema : ((ReportProcedure)object).getSchema();
            if (StringUtil.stringsAreNotEqual(reportProcedure.getSchema(), string)) {
                reportProcedure.setSchemaToUse(string);
            }
            ProcDiff procDiff = new ProcDiff(reportProcedure, (ReportProcedure)object);
            procDiff.setIndent(stringBuilder);
            StringBuilder stringBuilder2 = procDiff.getMigrateTargetXml();
            if (stringBuilder2.length() <= 0) continue;
            writer.write("\n");
            writer.write(stringBuilder2.toString());
        }
        if (CollectionUtil.isEmpty(this.procsToDelete)) {
            return;
        }
        writer.write(10);
        this.writeTag(writer, stringBuilder, TAG_DROP_PROC, true);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        for (ProcedureDefinition procedureDefinition : this.procsToDelete) {
            reportProcedure = new ReportProcedure(procedureDefinition, this.targetDb);
            reportProcedure.setIndent(stringBuilder3);
            object = reportProcedure.getXml(false);
            writer.write(((StringBuilder)object).toString());
        }
        this.writeTag(writer, stringBuilder, TAG_DROP_PROC, false);
    }

    private void appendPackageDiff(Writer writer, StringBuilder stringBuilder) throws IOException {
        Object object;
        int n = this.objectsToCompare.size();
        for (int i = 0; i < n; ++i) {
            Iterator<ReportPackage> iterator = this.objectsToCompare.get(i);
            if (!(iterator instanceof PackageDiffEntry)) continue;
            PackageDiffEntry object2 = (PackageDiffEntry)((Object)iterator);
            if (object2.reference != null) {
                object2.reference.readSource(this.referenceDb);
            }
            if (object2.target != null) {
                object2.target.readSource(this.targetDb);
            }
            object = new PackageDiff(object2.reference, object2.target);
            ((PackageDiff)object).setIndent(stringBuilder);
            StringBuilder stringBuilder2 = ((PackageDiff)object).getMigrateTargetXml();
            if (stringBuilder2.length() <= 0) continue;
            writer.write("\n");
            writer.write(stringBuilder2.toString());
        }
        if (CollectionUtil.isEmpty(this.packagesToDelete)) {
            return;
        }
        writer.write(10);
        this.writeTag(writer, stringBuilder, TAG_DROP_PCKG, true);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        for (ReportPackage reportPackage : this.packagesToDelete) {
            reportPackage.setSchemaToUse(this.targetSchema);
            reportPackage.setIndent(stringBuilder3);
            object = reportPackage.getXml(false);
            writer.write(((StringBuilder)object).toString());
            reportPackage.setSchemaToUse(null);
        }
        this.writeTag(writer, stringBuilder, TAG_DROP_PCKG, false);
    }

    private void appendViewDiff(List<ViewDiff> list, Writer writer) throws IOException {
        for (ViewDiff viewDiff : list) {
            StringBuilder stringBuilder = viewDiff.getMigrateTargetXml();
            if (stringBuilder.length() <= 0) continue;
            writer.write("\n");
            writer.write(stringBuilder.toString());
        }
    }

    private void appendDropViews(Writer writer, StringBuilder stringBuilder) throws IOException {
        if (this.viewsToDelete == null || this.viewsToDelete.isEmpty()) {
            return;
        }
        writer.write("\n");
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder);
        stringBuilder2.append("  ");
        String string = this.targetDb.getCurrentCatalog();
        for (TableIdentifier tableIdentifier : this.viewsToDelete) {
            this.writeTag(writer, stringBuilder, TAG_DROP_VIEW, true);
            this.writeTagValue(writer, stringBuilder2, "view-catalog", string);
            this.writeTagValue(writer, stringBuilder2, "view-schema", this.targetSchema);
            this.writeTagValue(writer, stringBuilder2, "view-name", tableIdentifier.getTableName());
            this.writeTag(writer, stringBuilder, TAG_DROP_VIEW, false);
        }
    }

    private void appendDropTables(Writer writer, StringBuilder stringBuilder) throws IOException {
        if (this.tablesToDelete == null || this.tablesToDelete.isEmpty()) {
            return;
        }
        writer.write("\n");
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder);
        stringBuilder2.append("  ");
        String string = this.targetDb.getCurrentCatalog();
        for (TableIdentifier tableIdentifier : this.tablesToDelete) {
            this.writeTag(writer, stringBuilder, TAG_DROP_TABLE, true);
            this.writeTagValue(writer, stringBuilder2, "table-catalog", string);
            this.writeTagValue(writer, stringBuilder2, "table-schema", this.targetSchema);
            this.writeTagValue(writer, stringBuilder2, "table-name", tableIdentifier.getTableName());
            this.writeTag(writer, stringBuilder, TAG_DROP_TABLE, false);
        }
    }

    private void writeDiffInfo(Writer writer) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("  ");
        StringBuilder stringBuilder2 = new StringBuilder("    ");
        TagWriter tagWriter = new TagWriter();
        TagWriter.writeWorkbenchVersion(writer, stringBuilder);
        writer.write(stringBuilder.toString());
        writer.write("<generated-at>");
        writer.write(StringUtil.getCurrentTimestampWithTZString());
        writer.write("</generated-at>\n\n");
        ConnectionInfoBuilder connectionInfoBuilder = new ConnectionInfoBuilder();
        this.writeTag(writer, stringBuilder, TAG_REF_CONN, true);
        StringBuilder stringBuilder3 = connectionInfoBuilder.getDatabaseInfoAsXml(this.referenceDb, stringBuilder2);
        writer.write(stringBuilder3.toString());
        this.writeTag(writer, stringBuilder, TAG_REF_CONN, false);
        writer.write("\n");
        writer.write("  <!-- If the target connection is modified according to the  -->\n");
        writer.write("  <!-- defintions in this file, then its structure will be    -->\n");
        writer.write("  <!-- the same as the reference connection -->\n");
        this.writeTag(writer, stringBuilder, TAG_TARGET_CONN, true);
        stringBuilder3 = connectionInfoBuilder.getDatabaseInfoAsXml(this.targetDb, stringBuilder2);
        writer.write(stringBuilder3.toString());
        this.writeTag(writer, stringBuilder, TAG_TARGET_CONN, false);
        writer.write("\n");
        stringBuilder3 = new StringBuilder();
        tagWriter.appendOpenTag(stringBuilder3, stringBuilder, TAG_COMPARE_INFO);
        stringBuilder3.append('\n');
        tagWriter.appendTag(stringBuilder3, stringBuilder2, TAG_INDEX_INFO, this.diffIndex);
        tagWriter.appendTag(stringBuilder3, stringBuilder2, TAG_FK_INFO, this.diffForeignKeys);
        tagWriter.appendTag(stringBuilder3, stringBuilder2, TAG_PK_INFO, this.diffPrimaryKeys);
        tagWriter.appendTag(stringBuilder3, stringBuilder2, TAG_CONSTRAINT_INFO, Boolean.toString(this.diffConstraints), "compare-names", Boolean.toString(this.compareConstraintsByName));
        tagWriter.appendTag(stringBuilder3, stringBuilder2, TAG_TRIGGER_INFO, this.diffTriggers);
        tagWriter.appendTag(stringBuilder3, stringBuilder2, TAG_GRANT_INFO, this.diffGrants);
        tagWriter.appendTag(stringBuilder3, stringBuilder2, USE_JDBC_TYPES, this.compareJdbcTypes);
        tagWriter.appendTag(stringBuilder3, stringBuilder2, TAG_VIEW_INFO, this.diffViews);
        if (this.additionalTypes != null) {
            StringBuilder stringBuilder4 = new StringBuilder(stringBuilder2);
            stringBuilder4.append("  ");
            tagWriter.appendOpenTag(stringBuilder3, stringBuilder2, TAG_TYPES);
            stringBuilder3.append('\n');
            for (String stringArray2 : this.additionalTypes) {
                tagWriter.appendTag(stringBuilder3, stringBuilder4, "type-name", stringArray2);
            }
            tagWriter.appendCloseTag(stringBuilder3, stringBuilder2, TAG_TYPES);
        }
        tagWriter.appendTag(stringBuilder3, stringBuilder2, TAG_VIEWS_AS_TABLE, this.treatViewAsTable);
        tagWriter.appendTag(stringBuilder3, stringBuilder2, TAG_FULL_SOURCE, this.useFullSource);
        if (this.referenceSchema != null && this.targetSchema != null) {
            tagWriter.appendTag(stringBuilder3, stringBuilder2, "reference-schema", this.referenceSchema);
            tagWriter.appendTag(stringBuilder3, stringBuilder2, "target-schema", this.targetSchema);
        }
        int n = this.objectsToCompare.size();
        String[] stringArray3 = new String[]{"type", "reference", "compareTo"};
        String[] stringArray4 = new String[]{"referenceProcedure", "compareTo"};
        String[] stringArray5 = new String[]{"referencePackage", "compareTo"};
        String[] stringArray = new String[]{"referenceSequence", "compareTo"};
        DbSettings dbSettings = this.referenceDb.getMetadata().getDbSettings();
        for (int i = 0; i < n; ++i) {
            String[] stringArray2;
            Object object;
            Object object2 = this.objectsToCompare.get(i);
            if (object2 instanceof DiffEntry) {
                object = (DiffEntry)object2;
                stringArray2 = new String[]{((DiffEntry)object).reference.getType(), ((DiffEntry)object).target == null ? "" : ((DiffEntry)object).target.getFullyQualifiedName(this.targetDb), ((DiffEntry)object).reference.getFullyQualifiedName(this.referenceDb)};
                if (dbSettings.isViewType(stringArray2[0])) {
                    tagWriter.appendOpenTag(stringBuilder3, stringBuilder2, TAG_VIEW_PAIR, stringArray3, stringArray2, false);
                } else {
                    tagWriter.appendOpenTag(stringBuilder3, stringBuilder2, TAG_TABLE_PAIR, stringArray3, stringArray2, false);
                }
            } else if (object2 instanceof ProcDiffEntry) {
                object = (ProcDiffEntry)object2;
                String[] stringArray6 = new String[]{this.getProcedureNameInfo(this.referenceDb, ((ProcDiffEntry)object).reference), this.getProcedureNameInfo(this.targetDb, ((ProcDiffEntry)object).target)};
                tagWriter.appendOpenTag(stringBuilder3, stringBuilder2, TAG_PROC_PAIR, stringArray4, stringArray6, false);
            } else if (object2 instanceof PackageDiffEntry) {
                object = (PackageDiffEntry)object2;
                stringArray2 = new String[]{((PackageDiffEntry)object).reference.getPackageName(), ((PackageDiffEntry)object).target == null ? "" : ((PackageDiffEntry)object).target.getPackageName()};
                tagWriter.appendOpenTag(stringBuilder3, stringBuilder2, TAG_PKG_PAIR, stringArray5, stringArray2, false);
            } else if (object2 instanceof SequenceDiffEntry) {
                object = (SequenceDiffEntry)object2;
                stringArray2 = new String[]{((SequenceDiffEntry)object).reference.getFullyQualifiedName(this.referenceDb), ((SequenceDiffEntry)object).target == null ? "" : ((SequenceDiffEntry)object).target.getFullyQualifiedName(this.targetDb)};
                tagWriter.appendOpenTag(stringBuilder3, stringBuilder2, TAG_SEQ_PAIR, stringArray, stringArray2, false);
            }
            stringBuilder3.append("/>\n");
        }
        tagWriter.appendCloseTag(stringBuilder3, stringBuilder, TAG_COMPARE_INFO);
        writer.write(stringBuilder3.toString());
    }

    private String getProcedureNameInfo(WbConnection wbConnection, ProcedureDefinition procedureDefinition) {
        if (procedureDefinition == null) {
            return "";
        }
        String string = "";
        if (StringUtil.isNonBlank(procedureDefinition.getCatalog())) {
            string = string + procedureDefinition.getCatalog().trim() + wbConnection.getMetadata().getCatalogSeparator();
        }
        if (StringUtil.isNonBlank(procedureDefinition.getSchema())) {
            string = string + procedureDefinition.getSchema().trim() + wbConnection.getMetadata().getSchemaSeparator();
        }
        string = string + procedureDefinition.getDisplayName();
        return string;
    }

    private void writeTag(Writer writer, StringBuilder stringBuilder, String string, boolean bl) throws IOException {
        this.writeTag(writer, stringBuilder, string, bl, null, null);
    }

    private void writeTag(Writer writer, StringBuilder stringBuilder, String string, boolean bl, String string2, String string3) throws IOException {
        if (stringBuilder != null) {
            writer.write(stringBuilder.toString());
        }
        if (bl) {
            writer.write("<");
        } else {
            writer.write("</");
        }
        writer.write(string);
        if (bl && string2 != null) {
            writer.write(32);
            writer.write(string2);
            writer.write("=\"");
            writer.write(string3);
            writer.write(34);
        }
        writer.write(">\n");
    }

    private void writeTagValue(Writer writer, StringBuilder stringBuilder, String string, String string2) throws IOException {
        if (stringBuilder != null) {
            writer.write(stringBuilder.toString());
        }
        writer.write("<");
        writer.write(string);
        writer.write(">");
        writer.write(string2 == null ? "" : string2);
        writer.write("</");
        writer.write(string);
        writer.write(">\n");
    }
}

