/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.diff;

import workbench.db.SequenceDefinition;
import workbench.db.report.ReportSequence;
import workbench.db.report.TagAttribute;
import workbench.db.report.TagWriter;
import workbench.resource.Settings;
import workbench.storage.RowData;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;

public class SequenceDiff {
    public static final String TAG_CREATE_SEQUENCE = "create-sequence";
    public static final String TAG_UPDATE_SEQUENCE = "update-sequence";
    public static final String TAG_ATTRIB_LIST = "modify-properties";
    private ReportSequence reference;
    private ReportSequence target;
    private final TagWriter writer = new TagWriter();
    private StringBuilder indent = StringUtil.emptyBuilder();
    private boolean includeSource;
    private String targetSchema;

    public SequenceDiff(ReportSequence reportSequence, ReportSequence reportSequence2, String string) {
        this.reference = reportSequence;
        this.target = reportSequence2;
        this.targetSchema = string;
        this.includeSource = Settings.getInstance().getBoolProperty("workbench.diff.sequence.include_sql", false);
    }

    public StringBuilder getMigrateTargetXml() {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder(50);
        StringBuilder stringBuilder2 = new StringBuilder(this.indent);
        stringBuilder2.append("  ");
        boolean bl2 = this.target == null;
        boolean bl3 = bl = this.target == null || !this.reference.getSequence().propertiesAreEqual(this.target.getSequence());
        if (!bl) {
            return stringBuilder;
        }
        this.writer.appendOpenTag(stringBuilder, this.indent, bl2 ? TAG_CREATE_SEQUENCE : TAG_UPDATE_SEQUENCE);
        stringBuilder.append('\n');
        if (bl) {
            if (this.reference != null && this.target != null) {
                this.writeChangedProperties(stringBuilder2, stringBuilder, this.reference.getSequence(), this.target.getSequence());
            }
            if (bl2) {
                this.reference.setSchemaNameToUse(this.targetSchema);
            }
            stringBuilder.append((CharSequence)this.reference.getXml(stringBuilder2, this.includeSource));
            if (bl2) {
                this.reference.setSchemaNameToUse(null);
            }
        }
        this.writer.appendCloseTag(stringBuilder, this.indent, bl2 ? TAG_CREATE_SEQUENCE : TAG_UPDATE_SEQUENCE);
        return stringBuilder;
    }

    private void writeChangedProperties(StringBuilder stringBuilder, StringBuilder stringBuilder2, SequenceDefinition sequenceDefinition, SequenceDefinition sequenceDefinition2) {
        if (sequenceDefinition == null || sequenceDefinition2 == null) {
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        boolean bl = false;
        for (String string : sequenceDefinition.getProperties()) {
            Object object;
            Object object2 = sequenceDefinition.getSequenceProperty(string);
            if (RowData.objectsAreEqual(object2, object = sequenceDefinition2.getSequenceProperty(string))) continue;
            if (!bl) {
                this.writer.appendOpenTag(stringBuilder2, stringBuilder, TAG_ATTRIB_LIST);
                stringBuilder2.append('\n');
                bl = true;
            }
            String string2 = WbDateFormatter.getDisplayValue(object2);
            TagAttribute tagAttribute = new TagAttribute("name", string);
            TagAttribute tagAttribute2 = new TagAttribute("value", string2);
            this.writer.appendOpenTag(stringBuilder2, stringBuilder3, "property", false, tagAttribute, tagAttribute2);
            stringBuilder2.append("/>\n");
        }
        if (bl) {
            this.writer.appendCloseTag(stringBuilder2, stringBuilder, TAG_ATTRIB_LIST);
        }
    }

    public void setIndent(StringBuilder stringBuilder) {
        this.indent = stringBuilder == null ? StringUtil.emptyBuilder() : stringBuilder;
    }
}

