/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exasol;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class ExasolTableSourceBuilder
extends TableSourceBuilder {
    public ExasolTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        if (tableIdentifier.getSourceOptions().isInitialized()) {
            return;
        }
        String string = "select column_name  \nfrom exa_all_columns \nwhere column_is_distribution_key \n  and column_schema = ? \n  and column_table = ? \norder by column_ordinal_position";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2;
            LogMgr.logMetadataSql(new CallerInfo(){}, "table source options", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
            ArrayList<String> arrayList = new ArrayList<String>(2);
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                arrayList.add(this.dbConnection.getMetadata().quoteObjectname(string2));
            }
            string2 = StringUtil.listToString(arrayList, ", ", false);
            String string3 = "DISTRIBUTE BY " + string2;
            tableIdentifier.getSourceOptions().setInlineOption(string3);
            tableIdentifier.getSourceOptions().addConfigSetting("distribute_by", string2);
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "table source options", string, tableIdentifier.getSchema(), tableIdentifier.getTableName());
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
    }
}

