/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.util.List;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public enum BlobMode {
    DbmsLiteral,
    AnsiLiteral,
    SaveToFile,
    Base64,
    pgDecode,
    pgEscape,
    pgHex,
    UUID,
    None;


    public static BlobMode getMode(String string) {
        if ((string = StringUtil.trimToNull(string)) == null) {
            return None;
        }
        if ("none".equalsIgnoreCase(string)) {
            return None;
        }
        if ("ansi".equalsIgnoreCase(string)) {
            return AnsiLiteral;
        }
        if ("dbms".equalsIgnoreCase(string)) {
            return DbmsLiteral;
        }
        if ("file".equalsIgnoreCase(string)) {
            return SaveToFile;
        }
        if ("base64".equalsIgnoreCase(string)) {
            return Base64;
        }
        if ("pgescape".equalsIgnoreCase(string)) {
            return pgEscape;
        }
        if ("pghex".equalsIgnoreCase(string)) {
            return pgHex;
        }
        if ("pgdecode".equalsIgnoreCase(string)) {
            return pgDecode;
        }
        if ("uuid".equalsIgnoreCase(string)) {
            return UUID;
        }
        try {
            return BlobMode.valueOf(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getTypeString() {
        switch (this) {
            case None: {
                return "";
            }
            case AnsiLiteral: {
                return "ansi";
            }
            case DbmsLiteral: {
                return "dbms";
            }
            case SaveToFile: {
                return "file";
            }
            case Base64: {
                return "base64";
            }
            case pgDecode: {
                return "pgdecode";
            }
            case pgEscape: {
                return "pgescape";
            }
            case pgHex: {
                return "pghex";
            }
            case UUID: {
                return "uuids";
            }
        }
        return "";
    }

    public static List<String> getTypes() {
        return CollectionUtil.arrayList("file", "ansi", "dbms", "base64", "pgescape", "pgdecode", "pghex");
    }
}

