/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.util.ArrayList;
import java.util.List;
import workbench.util.HtmlUtil;

public class OdsDateStyleBuilder {
    private String formatString;
    private List<String> elements = new ArrayList<String>(5);

    public OdsDateStyleBuilder(String string) {
        this.formatString = string;
        this.parseFormat();
    }

    public String getXML(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.elements.size() * 10);
        for (String string2 : this.elements) {
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private void parseFormat() {
        String string = "GyMwWdDFEaKkHhmsSzZ";
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.formatString.length();
        int n2 = 0;
        while (n2 < n) {
            char c = this.formatString.charAt(n2);
            if (string.indexOf(c) > -1) {
                int n3;
                String string2;
                if (stringBuilder.length() > 0) {
                    this.elements.add("<number:text>" + HtmlUtil.escapeXML(stringBuilder.toString()) + "</number:text>");
                    stringBuilder = new StringBuilder();
                }
                if ((string2 = this.getStyleFormat(c, n3 = this.getCharacterCount(this.formatString, n2))) != null) {
                    this.elements.add(string2);
                }
                n2 += n3;
                continue;
            }
            stringBuilder.append(c);
            ++n2;
        }
    }

    private int getCharacterCount(String string, int n) {
        int n2;
        char c = string.charAt(n);
        for (n2 = n; n2 < string.length() && string.charAt(n2) == c; ++n2) {
        }
        return n2 - n;
    }

    private String getStyleFormat(char c, int n) {
        switch (c) {
            case 'a': {
                return "<number:am-pm />";
            }
            case 'y': {
                return this.getNumberTag("year", n > 3, false);
            }
            case 'M': {
                return this.getNumberTag("month", n > 3, n > 2);
            }
            case 'd': {
                return this.getNumberTag("day", n > 2, false);
            }
            case 'H': 
            case 'h': {
                return this.getNumberTag("hours", true, false);
            }
            case 'm': {
                return this.getNumberTag("minutes", n > 2, false);
            }
            case 'S': 
            case 's': {
                return this.getNumberTag("seconds", true, false);
            }
        }
        return null;
    }

    private String getNumberTag(String string, boolean bl, boolean bl2) {
        String string2 = "<number:" + string;
        if (bl2) {
            string2 = string2 + " number:textual=\"true\"";
        }
        if (bl) {
            string2 = string2 + " number:style=\"long\"";
        }
        return string2 + "/>";
    }
}

