/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DropType;
import workbench.db.IndexDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.db.WbConnection;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.ExportType;
import workbench.db.exporter.InfinityLiterals;
import workbench.db.exporter.RowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.storage.BlobLiteralType;
import workbench.storage.DmlStatement;
import workbench.storage.MergeGenerator;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.storage.SqlLiteralFormatter;
import workbench.storage.StatementFactory;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class SqlRowDataConverter
extends RowDataConverter {
    private ExportType sqlTypeToUse = ExportType.SQL_INSERT;
    private ExportType sqlType = ExportType.SQL_INSERT;
    private boolean createTable;
    private TableIdentifier alternateUpdateTable;
    private int commitEvery;
    private String concatString;
    private String chrFunction;
    private String concatFunction;
    private StatementFactory statementFactory;
    private String lineTerminator = "\n";
    private String doubleLineTerminator = "\n\n";
    private boolean includeOwner = true;
    private boolean doFormatting = true;
    private SqlLiteralFormatter literalFormatter;
    private boolean ignoreRowStatus = true;
    private String mergeType;
    private MergeGenerator mergeGenerator;
    private boolean transactionControl = true;
    private boolean includeIdentityCols;
    private boolean includeReadOnlyCols;
    private boolean useMultiRowInserts;
    private SQLLexer lexer;
    private boolean firstRow = true;

    public SqlRowDataConverter(WbConnection wbConnection) {
        this.setOriginalConnection(wbConnection);
        this.includeIdentityCols = !Settings.getInstance().getGenerateInsertIgnoreIdentity();
        this.includeReadOnlyCols = !Settings.getInstance().getCheckEditableColumns();
    }

    @Override
    public final void setOriginalConnection(WbConnection wbConnection) {
        super.setOriginalConnection(wbConnection);
        this.literalFormatter = new SqlLiteralFormatter(wbConnection);
        this.lexer = SQLLexerFactory.createLexer(wbConnection);
    }

    @Override
    public void setInfinityLiterals(InfinityLiterals infinityLiterals) {
        super.setInfinityLiterals(infinityLiterals);
        this.literalFormatter.setInfinityLiterals(infinityLiterals);
    }

    public void setLineEnding(String string) {
        if (string != null) {
            this.lineTerminator = string;
        }
    }

    public boolean getUseMultiRowInserts() {
        return this.useMultiRowInserts;
    }

    public void setUseMultiRowInserts(boolean bl) {
        this.useMultiRowInserts = bl;
    }

    public void setTransactionControl(boolean bl) {
        this.transactionControl = bl;
    }

    public void setIncludeIdentityColumns(boolean bl) {
        this.includeIdentityCols = bl;
        if (this.statementFactory != null) {
            this.statementFactory.setIncludeIdentiyColumns(this.includeIdentityCols);
        }
    }

    public void setIncludeReadOnlyColumns(boolean bl) {
        this.includeReadOnlyCols = bl;
        if (this.statementFactory != null) {
            this.statementFactory.setIncludeReadOnlyColumns(this.includeReadOnlyCols);
        }
    }

    private boolean needPrimaryKey() {
        return this.sqlType == ExportType.SQL_DELETE_INSERT || this.sqlType == ExportType.SQL_UPDATE || this.sqlType == ExportType.SQL_MERGE || this.sqlType == ExportType.SQL_DELETE;
    }

    @Override
    public void setResultInfo(ResultInfo resultInfo) {
        super.setResultInfo(resultInfo);
        this.statementFactory = new StatementFactory(resultInfo, this.originalConnection);
        this.statementFactory.setUseColumnLabel(true);
        this.needsUpdateTable = resultInfo.getUpdateTable() == null;
        this.statementFactory.setIncludeTableOwner(this.includeOwner);
        this.statementFactory.setTableToUse(this.alternateUpdateTable);
        this.statementFactory.setIncludeIdentiyColumns(this.includeIdentityCols);
        this.statementFactory.setIncludeReadOnlyColumns(this.includeReadOnlyCols);
        boolean bl = this.checkKeyColumns();
        this.sqlTypeToUse = this.sqlType;
        if (!bl && this.needPrimaryKey()) {
            String string = "";
            if (resultInfo.getUpdateTable() != null) {
                string = " (" + resultInfo.getUpdateTable().getTableName() + ")";
            }
            if (this.errorReporter != null) {
                String string2 = ResourceMgr.getString("ErrExportNoKeys") + string;
                this.errorReporter.addWarning(string2);
            }
            LogMgr.logWarning(new CallerInfo(){}, "No key columns found" + string + " reverting back to INSERT generation");
            this.sqlTypeToUse = ExportType.SQL_INSERT;
        }
    }

    @Override
    public void setExporter(DataExporter dataExporter) {
        super.setExporter(dataExporter);
        if (dataExporter != null) {
            this.includeReadOnlyCols = dataExporter.getIncludeReadOnlyCols();
            this.includeIdentityCols = dataExporter.getIncludeIdentityCols();
            this.useMultiRowInserts = dataExporter.getUseMultiRowInserts();
        }
    }

    public void setMergeType(String string) {
        this.mergeType = string;
    }

    public void setDateLiteralType(String string) {
        if (this.literalFormatter != null) {
            this.literalFormatter.setDateLiteralType(string);
            this.literalFormatter.setInfinityLiterals(this.infinityLiterals);
        }
    }

    @Override
    public StringBuilder getEnd(long l) {
        StringBuilder stringBuilder = null;
        if (this.sqlTypeToUse == ExportType.SQL_MERGE) {
            stringBuilder = new StringBuilder(100);
            stringBuilder.append(this.getMergeEnd());
            stringBuilder.append(this.lineTerminator);
        } else if ((this.sqlTypeToUse == ExportType.SQL_INSERT || this.sqlTypeToUse == ExportType.SQL_INSERT_IGNORE) && this.useMultiRowInserts) {
            stringBuilder = new StringBuilder();
            if (this.sqlTypeToUse == ExportType.SQL_INSERT_IGNORE) {
                // empty if block
            }
            stringBuilder.append(";");
            stringBuilder.append(this.lineTerminator);
        }
        if (!this.transactionControl) {
            return stringBuilder;
        }
        boolean bl = true;
        if (this.commitEvery == Integer.MIN_VALUE || this.commitEvery > 0 && l % (long)this.commitEvery == 0L) {
            bl = false;
        }
        if (bl && l > 0L || this.createTable && this.originalConnection.generateCommitForDDL()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(12);
            }
            stringBuilder.append(this.lineTerminator);
            stringBuilder.append("COMMIT;");
            stringBuilder.append(this.lineTerminator);
        }
        return stringBuilder;
    }

    public void setIgnoreColumnStatus(boolean bl) {
        this.ignoreRowStatus = bl;
    }

    public void setType(ExportType exportType) {
        switch (exportType) {
            case SQL_INSERT: {
                this.setCreateInsert();
                break;
            }
            case SQL_INSERT_IGNORE: {
                this.setCreateInsertIgnore();
                break;
            }
            case SQL_UPDATE: {
                this.setCreateUpdate();
                break;
            }
            case SQL_DELETE_INSERT: {
                this.setCreateInsertDelete();
                break;
            }
            case SQL_DELETE: {
                this.setCreateDelete();
                break;
            }
            case SQL_MERGE: {
                this.setCreateMerge();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type specified");
            }
        }
    }

    private boolean isInsertType() {
        return this.sqlTypeToUse == ExportType.SQL_INSERT || this.sqlTypeToUse == ExportType.SQL_INSERT_IGNORE;
    }

    @Override
    public StringBuilder convertRowData(RowData rowData, long l) {
        if (this.sqlTypeToUse == ExportType.SQL_MERGE) {
            return this.appendMergeRow(rowData, l);
        }
        StringBuilder stringBuilder = new StringBuilder();
        DmlStatement dmlStatement = null;
        this.statementFactory.setIncludeTableOwner(this.includeOwner);
        this.statementFactory.setIncludeIdentiyColumns(this.includeIdentityCols);
        this.statementFactory.setIncludeReadOnlyColumns(this.includeReadOnlyCols);
        this.statementFactory.setTableToUse(this.alternateUpdateTable);
        if (this.sqlTypeToUse == ExportType.SQL_DELETE_INSERT) {
            dmlStatement = this.statementFactory.createDeleteStatement(rowData, true);
            dmlStatement.setFormatSql(this.doFormatting);
            stringBuilder.append(dmlStatement.getExecutableStatement(this.literalFormatter, this.originalConnection, this.lineTerminator));
            stringBuilder.append(';');
            stringBuilder.append(this.lineTerminator);
        }
        if (this.sqlTypeToUse == ExportType.SQL_DELETE) {
            dmlStatement = this.statementFactory.createDeleteStatement(rowData, true);
        }
        if (this.sqlTypeToUse == ExportType.SQL_DELETE_INSERT || this.isInsertType()) {
            dmlStatement = this.statementFactory.createInsertStatement(rowData, this.ignoreRowStatus, "\n", this.exportColumns);
        }
        if (this.sqlType == ExportType.SQL_UPDATE) {
            dmlStatement = this.statementFactory.createUpdateStatement(rowData, this.ignoreRowStatus, "\n", this.exportColumns);
        }
        if (dmlStatement == null) {
            return null;
        }
        dmlStatement.setFormatSql(this.doFormatting);
        dmlStatement.setChrFunction(this.chrFunction);
        dmlStatement.setConcatString(this.concatString);
        dmlStatement.setConcatFunction(this.concatFunction);
        this.currentRow = l;
        this.currentRowData = rowData;
        if (this.isInsertType() && this.useMultiRowInserts) {
            dmlStatement.setFormatSql(false);
        }
        CharSequence charSequence = dmlStatement.getExecutableStatement(this.literalFormatter, this.originalConnection, this.lineTerminator);
        if (this.isInsertType() && this.useMultiRowInserts) {
            if (this.firstRow) {
                this.appendWithLinebreaks(stringBuilder, charSequence);
                this.firstRow = false;
            } else {
                stringBuilder.append(',');
                stringBuilder.append(this.lineTerminator);
                stringBuilder.append("  ");
                stringBuilder.append(this.extractValuesPart(charSequence));
            }
        } else {
            stringBuilder.append(charSequence);
            stringBuilder.append(';');
            if (this.doFormatting) {
                stringBuilder.append(this.doubleLineTerminator);
            } else {
                stringBuilder.append(this.lineTerminator);
            }
            if (this.commitEvery > 0 && (l + 1L) % (long)this.commitEvery == 0L) {
                stringBuilder.append("COMMIT;");
                stringBuilder.append(this.doubleLineTerminator);
            }
        }
        return stringBuilder;
    }

    private MergeGenerator getMergeGenerator() {
        if (this.mergeGenerator == null) {
            this.mergeGenerator = this.mergeType != null ? MergeGenerator.Factory.createGenerator(this.mergeType) : MergeGenerator.Factory.createGenerator(this.originalConnection);
        }
        return this.mergeGenerator;
    }

    private StringBuilder appendMergeRow(RowData rowData, long l) {
        MergeGenerator mergeGenerator = this.getMergeGenerator();
        if (mergeGenerator != null) {
            String string = mergeGenerator.addRow(this.metaData, rowData, l);
            StringBuilder stringBuilder = new StringBuilder(string);
            return stringBuilder;
        }
        return null;
    }

    private String getMergeEnd() {
        MergeGenerator mergeGenerator = this.getMergeGenerator();
        if (mergeGenerator == null) {
            return null;
        }
        RowDataContainer rowDataContainer = RowDataContainer.Factory.createContainer(this.originalConnection, this.currentRowData, this.metaData);
        return mergeGenerator.generateMergeEnd(rowDataContainer);
    }

    private StringBuilder getMergeStart() {
        MergeGenerator mergeGenerator = this.getMergeGenerator();
        if (mergeGenerator == null) {
            return null;
        }
        RowDataContainer rowDataContainer = RowDataContainer.Factory.createContainer(this.originalConnection, this.currentRowData, this.metaData);
        return new StringBuilder(mergeGenerator.generateMergeStart(rowDataContainer));
    }

    @Override
    public StringBuilder getStart() {
        boolean bl;
        TableIdentifier tableIdentifier;
        this.firstRow = true;
        if (this.sqlTypeToUse == ExportType.SQL_MERGE) {
            return this.getMergeStart();
        }
        if (!this.createTable) {
            return null;
        }
        TableIdentifier tableIdentifier2 = tableIdentifier = this.alternateUpdateTable != null ? this.alternateUpdateTable : this.metaData.getUpdateTable();
        if (tableIdentifier == null) {
            LogMgr.logError(new CallerInfo(){}, "Cannot write create table without update table!", null);
            return null;
        }
        List<ColumnIdentifier> list = CollectionUtil.arrayList(this.metaData.getColumns());
        TableSourceBuilder tableSourceBuilder = TableSourceBuilderFactory.getBuilder(this.originalConnection);
        TableIdentifier tableIdentifier3 = tableIdentifier.createCopy();
        boolean bl2 = bl = this.exporter == null ? true : this.exporter.getUseSchemaInSql();
        if (bl) {
            if (tableIdentifier3.getSchema() == null) {
                tableIdentifier3.setSchema(tableIdentifier3.getSchemaToUse(this.originalConnection));
            }
            if (tableIdentifier3.getCatalog() == null) {
                tableIdentifier3.setCatalog(tableIdentifier3.getCatalogToUse(this.originalConnection));
            }
        } else {
            tableIdentifier3.setUseNameOnly(true);
        }
        boolean bl3 = Settings.getInstance().getBoolProperty("workbench.sql.export.createtable.pk", true);
        List<IndexDefinition> list2 = null;
        if (bl3 && this.needsPKIndexForPK()) {
            list2 = this.originalConnection.getMetadata().getIndexReader().getTableIndexList(tableIdentifier3, true);
        }
        CharSequence charSequence = tableSourceBuilder.getCreateTable(tableIdentifier3, list, list2, null, DropType.none, false, bl3, bl);
        String string = charSequence.toString();
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(this.doubleLineTerminator);
        return stringBuilder;
    }

    private boolean needsPKIndexForPK() {
        if (this.originalConnection == null) {
            return false;
        }
        return this.originalConnection.getDbSettings().needsPKIndexForPKDefinition();
    }

    public void setApplySQLFormatting(boolean bl) {
        this.doFormatting = bl;
    }

    public void setCreateInsert() {
        this.sqlTypeToUse = this.sqlType = ExportType.SQL_INSERT;
    }

    public void setCreateInsertIgnore() {
        this.sqlTypeToUse = this.sqlType = ExportType.SQL_INSERT_IGNORE;
    }

    public void setCreateMerge() {
        this.sqlTypeToUse = this.sqlType = ExportType.SQL_MERGE;
        this.doFormatting = false;
    }

    public void setCreateUpdate() {
        this.sqlTypeToUse = this.sqlType = ExportType.SQL_UPDATE;
    }

    public void setCreateInsertDelete() {
        this.sqlTypeToUse = this.sqlType = ExportType.SQL_DELETE_INSERT;
    }

    public void setCreateDelete() {
        this.sqlTypeToUse = this.sqlType = ExportType.SQL_DELETE;
    }

    public void setCommitEvery(int n) {
        this.commitEvery = n;
    }

    public void setConcatString(String string) {
        if (string == null) {
            return;
        }
        this.concatString = string;
        this.concatFunction = null;
    }

    public void setConcatFunction(String string) {
        if (string == null) {
            return;
        }
        this.concatFunction = string;
        this.concatString = null;
    }

    public void setChrFunction(String string) {
        this.chrFunction = string;
    }

    public void setCreateTable(boolean bl) {
        this.createTable = bl;
    }

    public void setAlternateUpdateTable(TableIdentifier tableIdentifier) {
        if (tableIdentifier != null) {
            this.alternateUpdateTable = tableIdentifier;
            this.needsUpdateTable = false;
        } else {
            this.alternateUpdateTable = null;
            this.needsUpdateTable = true;
        }
    }

    public void setKeyColumnsToUse(List<String> list) {
        this.keyColumnsToUse = list == null ? null : new ArrayList<String>(list);
    }

    public void setIncludeTableOwner(boolean bl) {
        this.includeOwner = bl;
    }

    public void setBlobMode(BlobMode blobMode) {
        if (this.literalFormatter == null) {
            return;
        }
        if (blobMode == BlobMode.DbmsLiteral) {
            this.literalFormatter.createDbmsBlobLiterals(this.originalConnection);
        } else if (blobMode == BlobMode.AnsiLiteral) {
            this.literalFormatter.createAnsiBlobLiterals();
        } else if (blobMode == BlobMode.SaveToFile) {
            this.literalFormatter.createBlobFiles(this);
        } else if (blobMode == BlobMode.pgDecode) {
            this.literalFormatter.setBlobFormat(BlobLiteralType.pgDecode);
        } else if (blobMode == BlobMode.pgEscape) {
            this.literalFormatter.setBlobFormat(BlobLiteralType.pgEscape);
        } else {
            this.literalFormatter.noBlobHandling();
        }
    }

    public void setClobAsFile(String string, int n) {
        if (StringUtil.isEmptyString(string)) {
            return;
        }
        if (this.literalFormatter != null) {
            this.literalFormatter.setTreatClobAsFile(this, string, n);
        }
    }

    protected void appendWithLinebreaks(StringBuilder stringBuilder, CharSequence charSequence) {
        this.lexer.setInput(charSequence);
        SQLToken sQLToken = this.lexer.getNextToken(true, true);
        while (sQLToken != null) {
            if (sQLToken.getContents().equals("VALUES")) {
                stringBuilder.append(this.lineTerminator);
                stringBuilder.append(sQLToken.getContents());
                stringBuilder.append(this.lineTerminator);
                stringBuilder.append(' ');
            } else {
                stringBuilder.append(sQLToken.getText());
            }
            sQLToken = this.lexer.getNextToken(true, true);
        }
    }

    protected String extractValuesPart(CharSequence charSequence) {
        this.lexer.setInput(charSequence);
        SQLToken sQLToken = this.lexer.getNextToken(false, false);
        int n = -1;
        while (sQLToken != null) {
            if (sQLToken.getText().equalsIgnoreCase("VALUES")) {
                n = sQLToken.getCharEnd();
            }
            sQLToken = this.lexer.getNextToken(false, false);
        }
        if (n > -1) {
            String string = charSequence.subSequence(n, charSequence.length()).toString();
            return string.trim();
        }
        return null;
    }
}

