/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookType;
import org.apache.poi.xssf.usermodel.helpers.ColumnHelper;
import workbench.db.exporter.ExcelDataFormat;
import workbench.db.exporter.RowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.RowData;
import workbench.util.FileUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbDateFormatter;
import workbench.util.WbFile;

public class XlsRowDataConverter
extends RowDataConverter {
    public static final String INFO_SHEETNAME = "SQL";
    private Workbook workbook = null;
    private Sheet sheet = null;
    private ExcelDataFormat excelFormat = null;
    private boolean useXLSX;
    private int firstRow = 0;
    private int rowOffset;
    private int columnOffset;
    private boolean optimizeCols = true;
    private boolean append;
    private int targetSheetIndex = -1;
    private String targetSheetName;
    private String outputSheetName;
    private final Map<Integer, CellStyle> styles = new HashMap<Integer, CellStyle>(10);
    private final Map<Integer, CellStyle> headerStyles = new HashMap<Integer, CellStyle>(10);
    private final StringBuilder dummyResult = new StringBuilder();

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setUseXLSX() {
        this.useXLSX = true;
    }

    public void setTargetSheetName(String string) {
        this.targetSheetName = string;
    }

    public void setTargetSheetIndex(int n) {
        this.targetSheetIndex = n;
    }

    public void setOptimizeColumns(boolean bl) {
        this.optimizeCols = bl;
    }

    public void setStartOffset(int n, int n2) {
        this.rowOffset = n;
        this.columnOffset = n2;
    }

    private void createFormatters() {
        String string = this.defaultDateFormatter != null ? this.defaultDateFormatter.toPattern() : "yyyy-MM-dd";
        String string2 = this.defaultTimestampFormatter != null ? this.defaultTimestampFormatter.getPatternWithoutTimeZone() : "yyyy-MM-dd HH:mm:ss.SSS";
        String string3 = this.defaultNumberFormatter != null ? this.defaultNumberFormatter.toFormatterPattern() : "0.00";
        this.excelFormat = new ExcelDataFormat(string3, string, "0", string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExcelFile() {
        FileInputStream fileInputStream = null;
        try {
            WbFile wbFile = new WbFile(this.getOutputFile());
            String string = wbFile.getExtension();
            this.useXLSX = string.equalsIgnoreCase("xlsx") || string.equalsIgnoreCase("xlsm");
            fileInputStream = new FileInputStream(wbFile);
            this.workbook = this.useXLSX ? new XSSFWorkbook((InputStream)fileInputStream) : new HSSFWorkbook((InputStream)fileInputStream);
            FileUtil.closeQuietely(fileInputStream);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not load Excel file", iOException);
            this.workbook = null;
        }
        finally {
            FileUtil.closeQuietely(fileInputStream);
        }
    }

    private XSSFWorkbookType getTypeToUse() {
        if (this.enableMacros()) {
            return XSSFWorkbookType.XLSM;
        }
        return XSSFWorkbookType.XLSX;
    }

    private boolean enableMacros() {
        WbFile wbFile;
        return this.useXLSX && (wbFile = new WbFile(this.getOutputFile())).getExtension().toLowerCase().equals("xlsm");
    }

    @Override
    public StringBuilder getStart() {
        Cell cell;
        int n;
        int n2;
        String string;
        Object object;
        boolean bl;
        this.firstRow = 0;
        this.outputSheetName = null;
        boolean bl2 = bl = this.append || this.targetSheetIndex > 0 || this.targetSheetName != null;
        if (bl && this.getOutputFile().exists()) {
            this.loadExcelFile();
        } else if (this.useXLSX) {
            object = new XSSFWorkbook(this.getTypeToUse());
            if (Settings.getInstance().useStreamingPOI()) {
                LogMgr.logInfo(new CallerInfo(){}, "Using XSSF streaming API to write file: " + this.getOutputFile());
                this.workbook = new SXSSFWorkbook(object, -1, true);
            } else {
                this.workbook = object;
            }
            if (this.isTemplate()) {
                this.makeTemplate();
            }
        } else {
            this.workbook = new HSSFWorkbook();
        }
        this.createFormatters();
        this.excelFormat.setupWithWorkbook(this.workbook);
        this.styles.clear();
        this.headerStyles.clear();
        object = this.getPageTitle(null);
        if (this.targetSheetIndex > 0 && this.targetSheetIndex <= this.workbook.getNumberOfSheets()) {
            this.sheet = this.workbook.getSheetAt(this.targetSheetIndex - 1);
            if (object != null) {
                this.workbook.setSheetName(this.targetSheetIndex - 1, (String)object);
            }
        } else if (this.targetSheetName != null) {
            this.sheet = this.workbook.getSheet(this.targetSheetName);
            if (this.sheet == null) {
                LogMgr.logWarning(new CallerInfo(){}, "Sheet '" + this.targetSheetName + "' not found!");
                this.targetSheetIndex = -1;
                this.targetSheetName = null;
            } else {
                this.targetSheetIndex = this.workbook.getSheetIndex(this.sheet);
            }
            if (this.sheet != null && object != null) {
                this.workbook.setSheetName(this.targetSheetIndex, (String)object);
            }
        } else {
            this.targetSheetIndex = -1;
        }
        if (this.sheet == null) {
            string = this.getPageTitle("SQLExport");
            this.sheet = this.workbook.createSheet(string);
        }
        if (this.optimizeCols && this.sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)this.sheet).trackAllColumnsForAutoSizing();
        }
        if (this.includeColumnComments) {
            string = this.createSheetRow(0);
            this.firstRow = 1;
            n2 = 0;
            for (n = 0; n < this.metaData.getColumnCount(); ++n) {
                if (!this.includeColumnInExport(n)) continue;
                cell = this.createSheetCell((Row)string, n2);
                this.setCellValueAndStyle(cell, StringUtil.trimQuotes(this.metaData.getColumn(n).getComment()), true, false, n);
                ++n2;
            }
        }
        if (this.writeHeader) {
            string = this.createSheetRow(this.firstRow);
            ++this.firstRow;
            n2 = 0;
            for (n = 0; n < this.metaData.getColumnCount(); ++n) {
                if (!this.includeColumnInExport(n)) continue;
                cell = this.createSheetCell((Row)string, n2);
                this.setCellValueAndStyle(cell, SqlUtil.removeObjectQuotes(this.metaData.getColumnDisplayName(n)), true, false, n);
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String getTargetFileDetails() {
        return this.outputSheetName;
    }

    private Cell createSheetCell(Row row, int n) {
        if (this.applyFormatting()) {
            return row.createCell(n + this.columnOffset);
        }
        Cell cell = row.getCell(n + this.columnOffset);
        if (cell == null) {
            cell = row.createCell(n + this.columnOffset);
        }
        return cell;
    }

    private Row createSheetRow(int n) {
        if (this.applyFormatting()) {
            return this.sheet.createRow(n + this.rowOffset);
        }
        Row row = this.sheet.getRow(n + this.rowOffset);
        if (row == null) {
            row = this.sheet.createRow(n + this.rowOffset);
        }
        return row;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StringBuilder getEnd(long l) {
        Object object;
        if (this.getAppendInfoSheet()) {
            this.writeInfoSheet();
        }
        if (this.getEnableFixedHeader() && this.writeHeader) {
            this.sheet.createFreezePane(0, this.firstRow);
        }
        if (this.getEnableAutoFilter() && this.writeHeader) {
            object = CellReference.convertNumToColString((int)(this.metaData.getColumnCount() - 1 + this.columnOffset));
            String string = CellReference.convertNumToColString((int)this.columnOffset);
            String string2 = string + Integer.toString(this.rowOffset + 1) + ":" + (String)object + Long.toString(l + 1L + (long)this.rowOffset);
            CellRangeAddress cellRangeAddress = CellRangeAddress.valueOf((String)string2);
            this.sheet.setAutoFilter(cellRangeAddress);
        }
        if (this.optimizeCols) {
            int n;
            for (n = 0; n < this.metaData.getColumnCount(); ++n) {
                this.sheet.autoSizeColumn(n + this.columnOffset);
            }
            n = Settings.getInstance().getIntProperty("workbench.export.xls.defaultcharwidth", 200);
            for (int i = 0; i < this.metaData.getColumnCount(); ++i) {
                int n2 = this.sheet.getColumnWidth(i + this.columnOffset);
                int n3 = this.metaData.getColumnName(i).length() * n;
                if (this.getEnableAutoFilter()) {
                    n3 += n * 2;
                }
                if (n2 >= n3) continue;
                LogMgr.logDebug(new CallerInfo(){}, "Calculated width of column " + i + " is: " + n2 + ". Applying min width: " + n3);
                this.sheet.setColumnWidth(i + this.columnOffset, n3);
                if (!(this.sheet instanceof XSSFSheet)) continue;
                ColumnHelper columnHelper = ((XSSFSheet)this.sheet).getColumnHelper();
                columnHelper.setColBestFit((long)(i + this.columnOffset), false);
                columnHelper.setColHidden((long)(i + this.columnOffset), false);
            }
        }
        object = null;
        try {
            object = new FileOutputStream(this.getOutputFile());
            this.workbook.write((OutputStream)object);
            this.outputSheetName = this.sheet.getSheetName();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new RuntimeException(fileNotFoundException);
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(object);
                this.disposeWorkbook();
                this.workbook = null;
                this.sheet = null;
                this.styles.clear();
                this.headerStyles.clear();
                throw throwable;
            }
        }
        FileUtil.closeQuietely((Closeable)object);
        this.disposeWorkbook();
        this.workbook = null;
        this.sheet = null;
        this.styles.clear();
        this.headerStyles.clear();
        return null;
    }

    private void disposeWorkbook() {
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            this.workbook.close();
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Could not close workbook", throwable);
        }
        try {
            if (this.workbook instanceof SXSSFWorkbook) {
                LogMgr.logDebug(callerInfo, "Disposing streaming spreadsheet");
                ((SXSSFWorkbook)this.workbook).dispose();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(callerInfo, "Could not dispose SXSSFWorkbook", throwable);
        }
    }

    private void flushStreamingRows(long l) {
        int n;
        if (this.sheet instanceof SXSSFSheet && l % (long)(n = Settings.getInstance().getStreamingPOIRows()) == 0L) {
            try {
                ((SXSSFSheet)this.sheet).flushRows(n);
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not flush streaming API rows", throwable);
            }
        }
    }

    private void writeInfoSheet() {
        Cell cell;
        Sheet sheet = this.workbook.getSheet(INFO_SHEETNAME);
        if (sheet == null) {
            sheet = this.workbook.createSheet(INFO_SHEETNAME);
            Row row = sheet.createRow(0);
            cell = row.createCell(0);
            this.setCellValueAndStyle(cell, ResourceMgr.getString("TxtSheet"), true, false, 0);
            cell = row.createCell(1);
            this.setCellValueAndStyle(cell, INFO_SHEETNAME, true, false, 1);
        } else {
            int n = this.workbook.getNumberOfSheets();
            this.workbook.setSheetOrder(sheet.getSheetName(), n - 1);
        }
        if (sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
        }
        int n = sheet.getLastRowNum() + 1;
        cell = sheet.createRow(n);
        cell.setHeight((short)-1);
        Cell cell2 = cell.createCell(0);
        CellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
        cellStyle.setWrapText(false);
        cell2.setCellValue(this.sheet.getSheetName());
        cell2.setCellStyle(cellStyle);
        sheet.autoSizeColumn(0);
        Cell cell3 = cell.createCell(1);
        CellStyle cellStyle2 = this.workbook.createCellStyle();
        cellStyle2.setAlignment(HorizontalAlignment.LEFT);
        cellStyle2.setVerticalAlignment(VerticalAlignment.TOP);
        cellStyle2.setWrapText(true);
        RichTextString richTextString = this.workbook.getCreationHelper().createRichTextString(this.generatingSql.trim());
        cell3.setCellValue(richTextString);
        cell3.setCellStyle(cellStyle2);
        sheet.autoSizeColumn(1);
    }

    @Override
    public StringBuilder convertRowData(RowData rowData, long l) {
        int n = this.metaData.getColumnCount();
        int n2 = (int)l + this.firstRow;
        Row row = this.createSheetRow(n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.includeColumnInExport(i)) continue;
            Cell cell = this.createSheetCell(row, n3);
            Object object = rowData.getValue(i);
            boolean bl = this.isMultiline(i);
            this.setCellValueAndStyle(cell, object, false, bl, i);
            ++n3;
        }
        this.flushStreamingRows(l);
        return this.dummyResult;
    }

    private boolean isIntegerColumn(int n) {
        try {
            int n2 = this.metaData.getColumnType(n);
            int n3 = this.metaData.getColumn(n).getDecimalDigits();
            return SqlUtil.isIntegerType(n2) || n3 <= 0;
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not check data type for column " + n, exception);
            return false;
        }
    }

    private boolean applyFormatting() {
        return this.targetSheetIndex < 0;
    }

    private boolean applyDateFormat() {
        if (this.targetSheetIndex < 0) {
            return true;
        }
        return this.exporter.getDateFormat() != null;
    }

    private boolean applyTimestampFormat() {
        if (this.targetSheetIndex < 0) {
            return true;
        }
        return this.exporter.getTimestampFormat() != null;
    }

    private boolean applyDecimalFormat() {
        if (this.targetSheetIndex < 0) {
            return true;
        }
        return this.exporter.getDecimalSymbol() != null;
    }

    private void setCellValueAndStyle(Cell cell, Object object, boolean bl, boolean bl2, int n) {
        CellStyle cellStyle = null;
        boolean bl3 = this.applyFormatting();
        if (object == null) {
            cellStyle = this.getBaseStyleForColumn(n, bl, bl2);
            int n2 = this.metaData.getColumnType(n);
            if (n2 == 93) {
                bl3 = bl3 || this.applyTimestampFormat();
            } else if (n2 == 91) {
                bl3 = bl3 || this.applyDateFormat();
            }
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.scale() == 0 && this.isIntegerColumn(n)) {
                if (bigDecimal.precision() > 15) {
                    cellStyle = this.excelFormat.textCellStyle;
                    cell.setCellValue(bigDecimal.toPlainString());
                } else {
                    cellStyle = this.excelFormat.integerCellStyle;
                    cell.setCellValue(bigDecimal.doubleValue());
                }
            } else {
                cellStyle = this.excelFormat.decimalCellStyle;
                bl3 = bl3 || this.applyDecimalFormat();
                cell.setCellValue(bigDecimal.doubleValue());
            }
        } else if (object instanceof Double || object instanceof Float) {
            cellStyle = this.excelFormat.decimalCellStyle;
            cell.setCellValue(((Number)object).doubleValue());
            bl3 = bl3 || this.applyDecimalFormat();
        } else if (object instanceof Number) {
            cellStyle = this.excelFormat.integerCellStyle;
            cell.setCellValue(((Number)object).doubleValue());
            bl3 = bl3 || this.applyDecimalFormat();
        } else if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            cellStyle = this.excelFormat.tsCellStyle;
            cell.setCellValue(Date.from(offsetDateTime.toInstant()));
            bl3 = bl3 || this.applyTimestampFormat();
        } else if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            cellStyle = this.excelFormat.tsCellStyle;
            cell.setCellValue(Date.from(zonedDateTime.toInstant()));
            bl3 = bl3 || this.applyTimestampFormat();
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            Instant instant = localDateTime.toInstant(WbDateFormatter.getSystemDefaultOffset());
            cellStyle = this.excelFormat.tsCellStyle;
            cell.setCellValue(Date.from(instant));
            bl3 = bl3 || this.applyTimestampFormat();
        } else if (object instanceof Timestamp) {
            cellStyle = this.excelFormat.tsCellStyle;
            cell.setCellValue((Date)object);
            bl3 = bl3 || this.applyTimestampFormat();
        } else if (object instanceof Date) {
            cellStyle = this.excelFormat.dateCellStyle;
            cell.setCellValue((Date)object);
            bl3 = bl3 || this.applyDateFormat();
        } else {
            RichTextString richTextString = this.workbook.getCreationHelper().createRichTextString(object.toString());
            cell.setCellValue(richTextString);
            cellStyle = bl2 ? this.excelFormat.multilineCellStyle : this.excelFormat.textCellStyle;
        }
        if (bl) {
            cellStyle = this.excelFormat.headerCellStyle;
        }
        if (bl3) {
            try {
                CellStyle cellStyle2 = this.geCachedStyle(cellStyle, n, bl);
                cell.setCellStyle(cellStyle2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not set style for column: " + this.metaData.getColumnName(n) + ", row: " + cell.getRowIndex() + ", column: " + cell.getColumnIndex());
            }
        }
    }

    private CellStyle getBaseStyleForColumn(int n, boolean bl, boolean bl2) {
        if (bl) {
            return this.excelFormat.headerCellStyle;
        }
        CellStyle cellStyle = null;
        int n2 = this.metaData.getColumnType(n);
        cellStyle = SqlUtil.isNumberType(n2) ? (this.isIntegerColumn(n) ? this.excelFormat.integerCellStyle : this.excelFormat.decimalCellStyle) : (n2 == 93 ? this.excelFormat.tsCellStyle : (n2 == 91 ? this.excelFormat.dateCellStyle : (bl2 ? this.excelFormat.multilineCellStyle : this.excelFormat.textCellStyle)));
        return cellStyle;
    }

    private CellStyle geCachedStyle(CellStyle cellStyle, int n, boolean bl) {
        Map<Integer, CellStyle> map = bl ? this.headerStyles : this.styles;
        CellStyle cellStyle2 = map.get(n);
        if (cellStyle2 == null) {
            cellStyle2 = this.workbook.createCellStyle();
            cellStyle2.cloneStyleFrom(cellStyle);
            map.put(n, cellStyle2);
        }
        return cellStyle2;
    }

    public boolean isTemplate() {
        return this.hasOutputFileExtension("xltx");
    }

    private void makeTemplate() {
        if (!this.useXLSX) {
            return;
        }
        POIXMLProperties pOIXMLProperties = ((XSSFWorkbook)this.workbook).getProperties();
        POIXMLProperties.ExtendedProperties extendedProperties = pOIXMLProperties.getExtendedProperties();
        extendedProperties.getUnderlyingProperties().setTemplate("XSSF");
    }
}

