/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import workbench.db.DbMetadata;
import workbench.db.WbConnection;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.ExportWriter;
import workbench.db.exporter.RowDataConverter;
import workbench.db.exporter.XmlRowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.BlobFormatterFactory;
import workbench.storage.BlobLiteralType;
import workbench.util.XsltTransformer;

public class XmlExportWriter
extends ExportWriter {
    public XmlExportWriter(DataExporter dataExporter) {
        super(dataExporter);
    }

    @Override
    public RowDataConverter createConverter() {
        return new XmlRowDataConverter();
    }

    @Override
    public void configureConverter() {
        super.configureConverter();
        XmlRowDataConverter xmlRowDataConverter = (XmlRowDataConverter)this.converter;
        xmlRowDataConverter.setUseCDATA(this.exporter.getUseCDATA());
        xmlRowDataConverter.setLineEnding(this.exporter.getLineEnding());
        xmlRowDataConverter.setUseVerboseFormat(this.exporter.getUseVerboseFormat());
        xmlRowDataConverter.setXMLVersion(this.exporter.getXMLVersion());
        xmlRowDataConverter.setTableNameToUse(this.exporter.getTableName());
        xmlRowDataConverter.setWriteClobToFile(this.exporter.getWriteClobAsFile());
        BlobMode blobMode = this.exporter.getBlobMode();
        if (blobMode == BlobMode.AnsiLiteral) {
            xmlRowDataConverter.setBlobFormatter(BlobFormatterFactory.createAnsiFormatter());
            xmlRowDataConverter.setWriteBlobToFile(false);
        } else if (blobMode == BlobMode.Base64) {
            xmlRowDataConverter.setBlobFormatter(BlobFormatterFactory.createInstance(BlobLiteralType.base64));
            xmlRowDataConverter.setWriteBlobToFile(false);
        } else if (blobMode == BlobMode.DbmsLiteral) {
            DbMetadata dbMetadata = null;
            WbConnection wbConnection = this.exporter.getConnection();
            if (wbConnection != null) {
                dbMetadata = wbConnection.getMetadata();
            }
            xmlRowDataConverter.setBlobFormatter(BlobFormatterFactory.createInstance(dbMetadata));
            xmlRowDataConverter.setWriteBlobToFile(false);
        } else if (blobMode == BlobMode.SaveToFile) {
            xmlRowDataConverter.setBlobFormatter(null);
            xmlRowDataConverter.setWriteBlobToFile(true);
        }
    }

    @Override
    public long exportFinished() {
        long l = super.exportFinished();
        String string = this.exporter.getFullOutputFilename();
        String string2 = this.exporter.getXsltTransformation();
        String string3 = this.exporter.getXsltTransformationOutput();
        if (string2 != null && string3 != null) {
            XsltTransformer xsltTransformer = new XsltTransformer();
            try {
                xsltTransformer.transform(string, string3, string2, this.exporter.getXsltParameters());
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error when transforming " + string3 + " using " + string2, exception);
                this.exporter.addError(xsltTransformer.getAllOutputs(exception));
            }
        }
        return l;
    }
}

