/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

import java.io.File;
import java.sql.SQLException;
import java.util.Date;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionInfoBuilder;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.exporter.RowDataConverter;
import workbench.db.report.TagWriter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.RowData;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class XmlRowDataConverter
extends RowDataConverter {
    public static final String LONG_ROW_TAG = "row-data";
    public static final String LONG_COLUMN_TAG = "column-data";
    public static final String SHORT_ROW_TAG = "rd";
    public static final String SHORT_COLUMN_TAG = "cd";
    public static final String COLUMN_DEF_TAG = "column-def";
    public static final String JAVA_CLASS_TAG = "java-class";
    public static final String JAVA_TYPE_TAG = "java-sql-type";
    public static final String DBMS_TYPE_TAG = "dbms-data-type";
    public static final String DATA_FORMAT_TAG = "data-format";
    public static final String TABLE_NAME_TAG = "table-name";
    public static final String TABLE_DEF_TAG = "table-def";
    public static final String COLUMN_COUNT_TAG = "column-count";
    public static final String COLUMN_NAME_TAG = "column-name";
    public static final String ATTR_LONGVALUE = "longValue";
    public static final String ATTR_NULL = "null";
    public static final String ATTR_DATA_FILE = "dataFile";
    public static final String KEY_FORMAT_LONG = "long";
    public static final String KEY_FORMAT_SHORT = "short";
    public static final String TAG_TAG_FORMAT = "wb-tag-format";
    public static final String TAG_BLOB_ENCODING = "wb-blob-encoding";
    private boolean useCData;
    private boolean verboseFormat = true;
    private String lineEnding = "\n";
    private String coltag = "column-data";
    private String rowtag = "row-data";
    private String numAttrib = "row-num";
    private String startColTag = "  <" + this.coltag + " index=\"";
    private String closeColTag = "</" + this.coltag + ">";
    private String closeRowTag = "</" + this.rowtag + ">";
    private String tableToUse;
    private StringBuilder dbInfo;
    private boolean writeClobFiles;
    private boolean addColName;
    private String xmlVersion = Settings.getInstance().getDefaultXmlVersion();
    private boolean useDiffFormat;
    private boolean writeBlobFiles = true;

    public XmlRowDataConverter() {
        this.addColName = Settings.getInstance().getBoolProperty("workbench.export.xml.verbose.includecolname", false);
    }

    public void setUseDiffFormat(boolean bl) {
        this.useDiffFormat = bl;
        if (bl) {
            this.coltag = "col";
            this.rowtag = "row";
            this.startColTag = "<col";
            this.closeColTag = "</col>";
            this.closeRowTag = "</row>";
        } else {
            this.setUseVerboseFormat(this.verboseFormat);
        }
    }

    public void setTableNameToUse(String string) {
        this.tableToUse = string;
    }

    public void setWriteBlobToFile(boolean bl) {
        this.writeBlobFiles = bl;
    }

    public void setWriteClobToFile(boolean bl) {
        this.writeClobFiles = bl;
    }

    @Override
    public void setOriginalConnection(WbConnection wbConnection) {
        super.setOriginalConnection(wbConnection);
        if (wbConnection != null) {
            StringBuilder stringBuilder = new StringBuilder("    ");
            ConnectionInfoBuilder connectionInfoBuilder = new ConnectionInfoBuilder();
            this.dbInfo = connectionInfoBuilder.getDatabaseInfoAsXml(wbConnection, stringBuilder);
        }
    }

    public void setXMLVersion(String string) {
        if ("1.1".equals(string) || "1.0".equals(string)) {
            this.xmlVersion = string;
        }
    }

    public void setUseVerboseFormat(boolean bl) {
        this.verboseFormat = bl;
        if (bl) {
            this.coltag = LONG_COLUMN_TAG;
            this.rowtag = LONG_ROW_TAG;
            this.startColTag = "  <" + this.coltag + " index=\"";
        } else {
            this.coltag = SHORT_COLUMN_TAG;
            this.rowtag = SHORT_ROW_TAG;
            this.startColTag = "<" + this.coltag;
        }
        this.closeColTag = "</" + this.coltag + ">";
        this.closeRowTag = "</" + this.rowtag + ">";
    }

    @Override
    public StringBuilder getStart() {
        StringBuilder stringBuilder = new StringBuilder(250);
        String string = this.getEncoding();
        stringBuilder.append("<?xml version=\"" + this.xmlVersion + "\"");
        if (string != null) {
            stringBuilder.append(" encoding=\"" + string + "\"");
        }
        stringBuilder.append("?>");
        stringBuilder.append(this.lineEnding);
        stringBuilder.append("<wb-export>");
        stringBuilder.append(this.lineEnding);
        stringBuilder.append((CharSequence)this.getMetaDataAsXml("  "));
        stringBuilder.append(this.lineEnding);
        if (this.verboseFormat) {
            stringBuilder.append("  ");
        }
        stringBuilder.append("<data>");
        stringBuilder.append(this.lineEnding);
        return stringBuilder;
    }

    @Override
    public StringBuilder getEnd(long l) {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (this.verboseFormat) {
            stringBuilder.append("  ");
        }
        stringBuilder.append("</data>");
        stringBuilder.append(this.lineEnding);
        stringBuilder.append("</wb-export>");
        stringBuilder.append(this.lineEnding);
        return stringBuilder;
    }

    public void setUseCDATA(boolean bl) {
        this.useCData = bl;
    }

    public void setLineEnding(String string) {
        if (string != null) {
            this.lineEnding = string;
        }
    }

    @Override
    public StringBuilder convertRowData(RowData rowData, long l) {
        TagWriter tagWriter = new TagWriter();
        StringBuilder stringBuilder = new StringBuilder("    ");
        int n = this.metaData.getColumnCount();
        StringBuilder stringBuilder2 = new StringBuilder(n * 100);
        if (!this.useDiffFormat) {
            if (this.verboseFormat) {
                tagWriter.appendOpenTag(stringBuilder2, stringBuilder, this.rowtag, this.numAttrib, Long.toString(l + 1L));
            } else {
                tagWriter.appendOpenTag(stringBuilder2, null, this.rowtag);
            }
            if (this.verboseFormat) {
                stringBuilder2.append(this.lineEnding);
            }
        }
        for (int i = 0; i < n; ++i) {
            String string;
            Comparable<Date> comparable;
            if (!this.includeColumnInExport(i)) continue;
            Object object = rowData.getValue(i);
            int n2 = this.metaData.getColumnType(i);
            String string2 = this.metaData.getDbmsTypeName(i);
            boolean bl = object == null;
            boolean bl2 = true;
            boolean bl3 = false;
            if (!this.useDiffFormat && this.verboseFormat) {
                stringBuilder2.append((CharSequence)stringBuilder);
            }
            stringBuilder2.append(this.startColTag);
            if (this.verboseFormat) {
                stringBuilder2.append(i);
                stringBuilder2.append('\"');
            }
            if (this.addColName || this.useDiffFormat) {
                stringBuilder2.append(" name=\"" + this.metaData.getColumnName(i) + "\"");
            }
            if (this.useDiffFormat) {
                if (this.metaData.getColumn(i).isPkColumn()) {
                    stringBuilder2.append(" pk=\"true\"");
                }
                if (rowData.isColumnModified(i)) {
                    stringBuilder2.append(" modified=\"true\"");
                }
            }
            if (bl) {
                stringBuilder2.append(" null=\"true\"/");
                bl2 = false;
            } else if (object instanceof Date) {
                comparable = (Date)object;
                stringBuilder2.append(" longValue=\"");
                stringBuilder2.append(Long.toString(comparable.getTime()));
                stringBuilder2.append('\"');
            } else if (this.writeClobFiles && SqlUtil.isClobType(n2, string2, this.originalConnection.getDbSettings())) {
                bl3 = true;
                try {
                    comparable = this.createBlobFile(rowData, i, l);
                    string = this.getBlobFileValue((File)comparable);
                    this.writeClobFile((String)object, (File)comparable, this.encoding);
                    stringBuilder2.append(' ');
                    stringBuilder2.append(ATTR_DATA_FILE);
                    stringBuilder2.append("=\"");
                    stringBuilder2.append(string);
                    stringBuilder2.append("\"/");
                    bl2 = false;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error writing CLOB file", exception);
                }
            } else if (SqlUtil.isBlobType(n2)) {
                if (this.writeBlobFiles) {
                    bl3 = true;
                    try {
                        comparable = this.createBlobFile(rowData, i, l);
                        string = this.getBlobFileValue((File)comparable);
                        this.writeBlobFile(object, (File)comparable);
                        stringBuilder2.append(' ');
                        stringBuilder2.append(ATTR_DATA_FILE);
                        stringBuilder2.append("=\"");
                        stringBuilder2.append(string);
                        stringBuilder2.append("\"/");
                        bl2 = false;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Error writing BLOB file", exception);
                    }
                } else if (this.blobFormatter != null) {
                    bl3 = false;
                }
            }
            stringBuilder2.append('>');
            if (!bl && !bl3) {
                if (this.useCData && SqlUtil.isCharacterType(n2)) {
                    stringBuilder2.append("<![CDATA[");
                    stringBuilder2.append(this.getValueAsFormattedString(rowData, i));
                    stringBuilder2.append("]]>");
                } else {
                    this.writeEscapedXML(stringBuilder2, this.getValueAsFormattedString(rowData, i));
                }
            }
            if (bl2) {
                stringBuilder2.append(this.closeColTag);
            }
            if (!this.verboseFormat || this.useDiffFormat) continue;
            stringBuilder2.append(this.lineEnding);
        }
        if (!this.useDiffFormat) {
            if (this.verboseFormat) {
                stringBuilder2.append((CharSequence)stringBuilder);
            }
            stringBuilder2.append(this.closeRowTag);
            stringBuilder2.append(this.lineEnding);
        }
        return stringBuilder2;
    }

    private StringBuilder getMetaDataAsXml(String string) {
        TagWriter tagWriter = new TagWriter();
        StringBuilder stringBuilder = new StringBuilder(string);
        StringBuilder stringBuilder2 = new StringBuilder(string);
        stringBuilder2.append("  ");
        int n = this.metaData.getColumnCount();
        StringBuilder stringBuilder3 = new StringBuilder(n * 50);
        tagWriter.appendOpenTag(stringBuilder3, stringBuilder, "meta-data");
        stringBuilder3.append(this.lineEnding);
        if (this.generatingSql != null) {
            stringBuilder3.append(this.lineEnding);
            tagWriter.appendOpenTag(stringBuilder3, stringBuilder2, "generating-sql");
            stringBuilder3.append(this.lineEnding);
            stringBuilder3.append((CharSequence)stringBuilder2);
            stringBuilder3.append("<![CDATA[");
            stringBuilder3.append(this.lineEnding);
            stringBuilder3.append((CharSequence)stringBuilder2);
            stringBuilder3.append(this.generatingSql);
            stringBuilder3.append(this.lineEnding);
            stringBuilder3.append((CharSequence)stringBuilder2);
            stringBuilder3.append("]]>");
            stringBuilder3.append(this.lineEnding);
            tagWriter.appendCloseTag(stringBuilder3, stringBuilder2, "generating-sql");
            stringBuilder3.append(this.lineEnding);
        }
        if (this.dbInfo != null) {
            stringBuilder3.append((CharSequence)this.dbInfo);
        }
        stringBuilder3.append((CharSequence)stringBuilder2);
        stringBuilder3.append("<wb-tag-format>");
        stringBuilder3.append(this.verboseFormat ? KEY_FORMAT_LONG : KEY_FORMAT_SHORT);
        stringBuilder3.append("</wb-tag-format>");
        stringBuilder3.append(this.lineEnding);
        if (this.blobFormatter != null) {
            stringBuilder3.append((CharSequence)stringBuilder2);
            stringBuilder3.append("<wb-blob-encoding>");
            stringBuilder3.append(this.blobFormatter.getType().toString());
            stringBuilder3.append("</wb-blob-encoding>");
            stringBuilder3.append(this.lineEnding);
        }
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("</meta-data>");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append('<');
        stringBuilder3.append(TABLE_DEF_TAG);
        stringBuilder3.append('>');
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  <!-- The following information was retrieved from the JDBC driver's ResultSetMetaData -->");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  <!-- column-name is retrieved from ResultSetMetaData.getColumnName() -->");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  <!-- java-class is retrieved from ResultSetMetaData.getColumnClassName() -->");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  <!-- java-sql-type-name is the constant's name from java.sql.Types -->");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  <!-- java-sql-type is the constant's numeric value from java.sql.Types as returned from ResultSetMetaData.getColumnType() -->");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  <!-- dbms-data-type is retrieved from ResultSetMetaData.getColumnTypeName() -->");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  <!-- For date and timestamp types, the internal long value obtained from java.util.Date.getTime()");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("       is written as an attribute to the <column-data> tag. That value can be used");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("       to create a java.util.Date() object directly, without the need to parse the actual tag content.");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("       If Java is not used to parse this file, the date/time format used to write the data");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("       is provided in the <data-format> tag of the column definition");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  -->");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  <");
        stringBuilder3.append(TABLE_NAME_TAG);
        stringBuilder3.append('>');
        TableDefinition tableDefinition = null;
        if (this.tableToUse != null) {
            stringBuilder3.append(this.tableToUse);
        } else {
            TableIdentifier tableIdentifier = this.metaData.getUpdateTable();
            if (tableIdentifier != null) {
                stringBuilder3.append(tableIdentifier.getTableName());
                try {
                    tableDefinition = this.originalConnection.getMetadata().getTableDefinition(tableIdentifier);
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Error retrieving table definition", sQLException);
                }
            }
        }
        stringBuilder3.append("</");
        stringBuilder3.append(TABLE_NAME_TAG);
        stringBuilder3.append(">");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("  <column-count>");
        stringBuilder3.append(n);
        stringBuilder3.append("</column-count>");
        stringBuilder3.append(this.lineEnding);
        stringBuilder3.append(this.lineEnding);
        for (int i = 0; i < n; ++i) {
            ColumnIdentifier columnIdentifier;
            String string2;
            if (!this.includeColumnInExport(i)) continue;
            stringBuilder3.append((CharSequence)stringBuilder);
            stringBuilder3.append("  <");
            stringBuilder3.append(COLUMN_DEF_TAG);
            stringBuilder3.append(" index=\"");
            stringBuilder3.append(i);
            stringBuilder3.append("\">");
            stringBuilder3.append(this.lineEnding);
            String string3 = this.metaData.getColumnName(i);
            stringBuilder3.append((CharSequence)stringBuilder);
            this.appendTag(stringBuilder3, "    ", COLUMN_NAME_TAG, SqlUtil.removeObjectQuotes(string3));
            String string4 = this.metaData.getColumnDisplayName(i);
            if (!string4.equals(string3)) {
                stringBuilder3.append((CharSequence)stringBuilder);
                this.appendTag(stringBuilder3, "    ", "column-label", SqlUtil.removeObjectQuotes(string4));
            }
            if (StringUtil.isNonBlank(string2 = this.metaData.getColumn(i).getComment())) {
                stringBuilder3.append((CharSequence)stringBuilder);
                this.appendTag(stringBuilder3, "    ", "comment", string2);
            }
            stringBuilder3.append((CharSequence)stringBuilder);
            this.appendTag(stringBuilder3, "    ", JAVA_CLASS_TAG, this.getReadableClassName(this.metaData.getColumnClassName(i)));
            stringBuilder3.append((CharSequence)stringBuilder);
            this.appendTag(stringBuilder3, "    ", "java-sql-type-name", SqlUtil.getTypeName(this.metaData.getColumnType(i)));
            stringBuilder3.append((CharSequence)stringBuilder);
            this.appendTag(stringBuilder3, "    ", JAVA_TYPE_TAG, String.valueOf(this.metaData.getColumnType(i)));
            stringBuilder3.append((CharSequence)stringBuilder);
            this.appendTag(stringBuilder3, "    ", DBMS_TYPE_TAG, this.metaData.getDbmsTypeName(i));
            int n2 = this.metaData.getColumnType(i);
            if (SqlUtil.isDateType(n2)) {
                if (n2 == 93) {
                    stringBuilder3.append((CharSequence)stringBuilder);
                    stringBuilder3.append("    <data-format>");
                    stringBuilder3.append(this.defaultTimestampFormatter.toPattern());
                } else {
                    stringBuilder3.append((CharSequence)stringBuilder);
                    stringBuilder3.append("    <data-format>");
                    stringBuilder3.append(this.defaultDateFormatter.toPattern());
                }
                stringBuilder3.append("</data-format>");
                stringBuilder3.append(this.lineEnding);
            }
            if (tableDefinition != null && (columnIdentifier = tableDefinition.findColumn(this.metaData.getColumnName(i))) != null) {
                stringBuilder3.append((CharSequence)stringBuilder);
                this.appendTag(stringBuilder3, "    ", "primary-key", Boolean.toString(columnIdentifier.isPkColumn()));
            }
            stringBuilder3.append((CharSequence)stringBuilder);
            stringBuilder3.append("  </");
            stringBuilder3.append(COLUMN_DEF_TAG);
            stringBuilder3.append(">");
            stringBuilder3.append(this.lineEnding);
        }
        stringBuilder3.append((CharSequence)stringBuilder);
        stringBuilder3.append("</");
        stringBuilder3.append(TABLE_DEF_TAG);
        stringBuilder3.append(">");
        stringBuilder3.append(this.lineEnding);
        return stringBuilder3;
    }

    private String getReadableClassName(String string) {
        if (string.charAt(0) != '[') {
            return string;
        }
        String string2 = string;
        if (string.charAt(0) == '[') {
            if (string.charAt(1) == 'B') {
                string2 = "byte[]";
            } else if (string.charAt(1) == 'C') {
                string2 = "char[]";
            } else if (string.charAt(1) == 'I') {
                string2 = "int[]";
            } else if (string.charAt(1) == 'J') {
                string2 = "long[]";
            } else if (string.charAt(1) == 'L') {
                string2 = string.substring(2, string.length() - 1) + "[]";
            }
        }
        return string2;
    }

    private void appendOpenTag(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string);
        stringBuilder.append('<');
        stringBuilder.append(string2);
        stringBuilder.append('>');
    }

    private void appendCloseTag(StringBuilder stringBuilder, String string) {
        stringBuilder.append("</");
        stringBuilder.append(string);
        stringBuilder.append('>');
    }

    private void appendTag(StringBuilder stringBuilder, String string, String string2, String string3) {
        this.appendOpenTag(stringBuilder, string, string2);
        if (TagWriter.needsCData(string3)) {
            stringBuilder.append("<![CDATA[");
        }
        stringBuilder.append(string3);
        if (TagWriter.needsCData(string3)) {
            stringBuilder.append("]]>");
        }
        this.appendCloseTag(stringBuilder, string2);
        stringBuilder.append(this.lineEnding);
    }
}

