/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class FirebirdColumnEnhancer
implements ColumnDefinitionEnhancer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = JdbcUtils.hasMinimumServerVersion(wbConnection, "3.0");
        String string = bl ? "select rf.rdb$field_name, \n       f.rdb$computed_source, \n       rf.rdb$identity_type as identity_type, \n       g.rdb$initial_value as initial_value \nfrom rdb$fields f   \n   join rdb$relation_fields rf on f.rdb$field_name = rf.rdb$field_source  \n   join rdb$relations r on r.rdb$relation_name = rf.rdb$relation_name  \n   left join rdb$generators g on g.rdb$generator_name = rf.rdb$generator_name \nwhere (f.rdb$computed_source IS NOT NULL or rf.rdb$identity_type is not null) \n  and r.rdb$relation_name = ? " : "select rf.rdb$field_name, f.rdb$computed_source, null as identity_type, null as initial_value \nfrom rdb$fields f  \n   join rdb$relation_fields rf on f.rdb$field_name = rf.rdb$field_source \n   join rdb$relations r on r.rdb$relation_name = rf.rdb$relation_name \nwhere f.rdb$computed_source IS NOT NULL \n  and r.rdb$relation_name = ? ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "column details", string, new Object[0]);
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableDefinition.getTable().getTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1).trim();
                String object = resultSet.getString(2);
                int string5 = resultSet.getInt(3);
                if (resultSet.wasNull()) {
                    string5 = -1;
                }
                int string4 = resultSet.getInt(4);
                if (resultSet.wasNull()) {
                    string4 = -1;
                }
                if (string5 > 0) {
                    String string3 = "GENERATED BY DEFAULT AS IDENTITY";
                    if (string4 > 0) {
                        string3 = string3 + " (START WITH " + string4 + ")";
                    }
                    hashMap2.put(string2, string3);
                }
                hashMap.put(string2, object);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "column details", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
            String string4;
            String string5 = (String)hashMap.get(columnIdentifier.getColumnName());
            if (StringUtil.isNonBlank(string5)) {
                columnIdentifier.setComputedColumnExpression("COMPUTED BY " + string5.trim());
            }
            if ((string4 = (String)hashMap2.get(columnIdentifier.getColumnName())) == null) continue;
            columnIdentifier.setIsAutoincrement(true);
            columnIdentifier.setGeneratorExpression(string4);
        }
    }
}

