/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.SequenceAdjuster;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class FirebirdSequenceAdjuster
implements SequenceAdjuster {
    @Override
    public int adjustTableSequences(WbConnection wbConnection, TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        List<String> list = this.getIdentityColumns(wbConnection, tableIdentifier);
        for (String string : list) {
            this.syncSingleSequence(wbConnection, tableIdentifier, string);
        }
        if (bl && !wbConnection.getAutoCommit()) {
            wbConnection.commit();
        }
        return list.size();
    }

    private void syncSingleSequence(WbConnection wbConnection, TableIdentifier tableIdentifier, String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            statement = wbConnection.createStatement();
            long l = -1L;
            resultSet = statement.executeQuery("select max(" + string + ") from " + tableIdentifier.getTableExpression(wbConnection));
            if (resultSet.next()) {
                l = resultSet.getLong(1) + 1L;
                JdbcUtils.closeResult(resultSet);
            }
            if (l > 0L) {
                string2 = "alter table " + tableIdentifier.getTableExpression(wbConnection) + " alter column " + string + " restart with " + Long.toString(l);
                LogMgr.logDebug(new CallerInfo(){}, "Syncing sequence using: " + string2);
                statement.execute(string2);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not adjust sequence using:\n" + string2, sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
    }

    private List<String> getIdentityColumns(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            List<ColumnIdentifier> list = wbConnection.getMetadata().getTableColumns(tableIdentifier, false);
            for (ColumnIdentifier columnIdentifier : list) {
                if (!columnIdentifier.isAutoincrement()) continue;
                arrayList.add(columnIdentifier.getColumnName());
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read sequence columns", sQLException);
        }
        return arrayList;
    }
}

