/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class FirebirdSequenceReader
implements SequenceReader {
    private WbConnection dbConnection;

    public FirebirdSequenceReader(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return "";
        }
        return sequenceDefinition.getSource();
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>(dataStore.getRowCount());
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createSequenceDefinition(dataStore, i));
        }
        return arrayList;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        return this.createSequenceDefinition(dataStore, 0);
    }

    private SequenceDefinition createSequenceDefinition(DataStore dataStore, int n) {
        SequenceDefinition sequenceDefinition = null;
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        String string = dataStore.getValueAsString(n, 0);
        sequenceDefinition = new SequenceDefinition(null, string);
        String string2 = dataStore.getValueAsString(n, 1);
        sequenceDefinition.setComment(string2);
        this.readSequenceSource(sequenceDefinition);
        return sequenceDefinition;
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(sequenceDefinition.getSequenceName());
        stringBuilder.append(";\n");
        String string = sequenceDefinition.getComment();
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append("\nCOMMENT ON SEQUENCE ");
            stringBuilder.append(sequenceDefinition.getSequenceName());
            stringBuilder.append(" IS '");
            stringBuilder.append(string.replace("'", "''"));
            stringBuilder.append("';");
        }
        sequenceDefinition.setSource(stringBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        Statement statement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("SELECT trim(rdb$generator_name) AS SEQUENCE_NAME, \n       trim(rdb$description) AS REMARKS \nFROM rdb$generators \nWHERE (rdb$system_flag = 0 OR rdb$system_flag IS NULL) \n");
        SqlUtil.appendAndCondition(stringBuilder, "rdb$generator_name", string3, this.dbConnection);
        stringBuilder.append("\n ORDER BY 1");
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence definition", stringBuilder, new Object[0]);
        try {
            statement = this.dbConnection.createStatement();
            resultSet = statement.executeQuery(stringBuilder.toString());
            dataStore = new DataStore(resultSet, true);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "sequence definition", stringBuilder, new Object[0]);
                dataStore = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

