/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.Set;
import workbench.db.ConnectionMgr;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.StatementHook;
import workbench.sql.StatementRunner;
import workbench.sql.StatementRunnerResult;
import workbench.util.CollectionUtil;

public class FirebirdStatementHook
implements StatementHook {
    public static final String SESS_ATTR_SHOWPLAN = "fb_showplan";
    public static final String SESS_ATTR_PLAN_ONLY = "fb_planonly";
    private final Object lock = new Object();
    private boolean planOnly;
    private boolean showPlan;
    private Method getPlan;
    private boolean useDefaultClassloader;
    private Set<String> explainable = CollectionUtil.caseInsensitiveSet("with", "select", "update", "delete", "insert");
    private String toExplain;

    public FirebirdStatementHook(WbConnection wbConnection) {
        this.initialize(wbConnection);
    }

    @Override
    public String preExec(StatementRunner statementRunner, String string) {
        this.showPlan = statementRunner.getBoolSessionAttribute(SESS_ATTR_SHOWPLAN);
        this.planOnly = statementRunner.getBoolSessionAttribute(SESS_ATTR_PLAN_ONLY);
        if (this.planOnly) {
            this.toExplain = string;
            return null;
        }
        return string;
    }

    @Override
    public boolean isPending() {
        return this.showPlan || this.planOnly;
    }

    @Override
    public void postExec(StatementRunner statementRunner, String string, StatementRunnerResult statementRunnerResult) {
        String string2;
        if ((this.showPlan || this.planOnly) && (string2 = this.getExecutionPlan(statementRunner.getConnection(), string == null ? this.toExplain : string)) != null) {
            statementRunnerResult.addMessage("Execution plan:");
            statementRunnerResult.addMessage("---------------");
            statementRunnerResult.addMessage(string2.trim());
            statementRunnerResult.addMessage("\n-- end of execution plan ---");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExecutionPlan(WbConnection wbConnection, String string) {
        String string2 = wbConnection.getParsingUtil().getSqlVerb(string);
        if (!this.explainable.contains(string2)) {
            return null;
        }
        if (this.getPlan == null) {
            return null;
        }
        String string3 = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            string3 = (String)this.getPlan.invoke((Object)preparedStatement, (Object[])null);
        }
        catch (Exception exception) {
            try {
                string3 = null;
                LogMgr.logError(new CallerInfo(){}, "Could not retrieve execution plan", exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeStatement(preparedStatement);
        }
        JdbcUtils.closeStatement(preparedStatement);
        return string3;
    }

    @Override
    public boolean displayResults() {
        return !this.planOnly;
    }

    @Override
    public boolean fetchResults() {
        return !this.planOnly;
    }

    @Override
    public void close(WbConnection wbConnection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(WbConnection wbConnection) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Class clazz = null;
                clazz = this.useDefaultClassloader ? Class.forName("org.firebirdsql.jdbc.FirebirdPreparedStatement") : ConnectionMgr.getInstance().loadClassFromDriverLib(wbConnection.getProfile(), "org.firebirdsql.jdbc.FirebirdPreparedStatement");
                this.getPlan = clazz.getMethod("getExecutionPlan", null);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not obtain getExecutionPlan method", throwable);
                this.getPlan = null;
            }
        }
    }

    public void setUseDefaultClassloader(boolean bl) {
        this.useDefaultClassloader = bl;
    }
}

