/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firebird;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class FirebirdTableSourceBuilder
extends TableSourceBuilder {
    public FirebirdTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        if (tableIdentifier.getSourceOptions().isInitialized()) {
            return;
        }
        String string = "select trim(t.rdb$type_name), rdb$external_file \nfrom rdb$relations r \n  join rdb$types t on r.rdb$relation_type = t.rdb$type and t.rdb$field_name = 'RDB$RELATION_TYPE' \nwhere coalesce (r.rdb$system_flag, 0) = 0 \n  and rdb$relation_name = ? ";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        StringBuilder stringBuilder = new StringBuilder(50);
        LogMgr.logMetadataSql(new CallerInfo(){}, "table options", string, new Object[0]);
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (StringUtil.equalStringIgnoreCase(string2, "GLOBAL_TEMPORARY_PRESERVE")) {
                    tableIdentifier.getSourceOptions().setTypeModifier("GLOBAL TEMPORARY");
                    stringBuilder.append("ON COMMIT PRESERVE ROWS");
                    tableIdentifier.getSourceOptions().addConfigSetting("on_commit", "preserve");
                } else if (StringUtil.equalStringIgnoreCase(string2, "GLOBAL_TEMPORARY_DELETE")) {
                    tableIdentifier.getSourceOptions().setTypeModifier("GLOBAL TEMPORARY");
                    stringBuilder.append("ON COMMIT DELETE ROWS");
                    tableIdentifier.getSourceOptions().addConfigSetting("on_commit", "delete");
                }
                if ("EXTERNAL".equals(string2)) {
                    String string3 = resultSet.getString(2);
                    tableIdentifier.getSourceOptions().addConfigSetting("external_file", string3);
                }
            }
            tableIdentifier.getSourceOptions().setTableOption(stringBuilder.toString());
            tableIdentifier.getSourceOptions().setInitialized();
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "table options", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    @Override
    protected String getCreateDDL(String string, TableIdentifier tableIdentifier) {
        String string2 = super.getCreateDDL(string, tableIdentifier);
        String string3 = tableIdentifier.getSourceOptions().getConfigSettings().get("external_file");
        if (StringUtil.isNonBlank(string3)) {
            string2 = string2 + "\nEXTERNAL FILE '" + string3 + "'";
        }
        return string2;
    }
}

