/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.firstsql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import workbench.db.AbstractConstraintReader;
import workbench.db.JdbcUtils;
import workbench.db.TableConstraint;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class FirstSqlConstraintReader
extends AbstractConstraintReader {
    private final String SQL = "select ch.check_clause, ch.constraint_name \nfrom definition_schema.syschecks ch,  \n     definition_schema.sysconstraints cons \nwhere cons.constraint_type = 'check' \n  and cons.constraint_name = ch.constraint_name  and cons.table_schema = ? \n  and cons.table_name = ? ";

    public FirstSqlConstraintReader() {
        super("firstsqlj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TableConstraint> getTableConstraints(WbConnection wbConnection, TableDefinition tableDefinition) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "table constraints", "select ch.check_clause, ch.constraint_name \nfrom definition_schema.syschecks ch,  \n     definition_schema.sysconstraints cons \nwhere cons.constraint_type = 'check' \n  and cons.constraint_name = ch.constraint_name  and cons.table_schema = ? \n  and cons.table_name = ? ", new Object[0]);
        List<TableConstraint> list = CollectionUtil.arrayList();
        TableIdentifier tableIdentifier = tableDefinition.getTable();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement("select ch.check_clause, ch.constraint_name \nfrom definition_schema.syschecks ch,  \n     definition_schema.sysconstraints cons \nwhere cons.constraint_type = 'check' \n  and cons.constraint_name = ch.constraint_name  and cons.table_schema = ? \n  and cons.table_name = ? ");
            preparedStatement.setString(1, tableIdentifier.getSchema());
            preparedStatement.setString(2, tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                list.add(new TableConstraint(string2, "(" + string + ")"));
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table constraints", "select ch.check_clause, ch.constraint_name \nfrom definition_schema.syschecks ch,  \n     definition_schema.sysconstraints cons \nwhere cons.constraint_type = 'check' \n  and cons.constraint_name = ch.constraint_name  and cons.table_schema = ? \n  and cons.table_name = ? ", new Object[0]);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        return list;
    }

    @Override
    public String getColumnConstraintSql() {
        return null;
    }

    @Override
    public String getTableConstraintSql() {
        return "select ch.check_clause, ch.constraint_name \nfrom definition_schema.syschecks ch,  \n     definition_schema.sysconstraints cons \nwhere cons.constraint_type = 'check' \n  and cons.constraint_name = ch.constraint_name  and cons.table_schema = ? \n  and cons.table_name = ? ";
    }
}

