/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.greenplum;

import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListCleaner;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class GreenplumObjectListCleaner
implements ObjectListCleaner {
    public boolean doRemovePartitions() {
        return Settings.getInstance().getBoolProperty("workbench.db.greenplum.partitions.tablelist.remove", true);
    }

    @Override
    public void cleanupObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (DbMetadata.typeIncluded("TABLE", stringArray) && this.doRemovePartitions()) {
            this.removePartitions(wbConnection, dataStore, string2, string3);
        }
    }

    private void removePartitions(WbConnection wbConnection, DataStore dataStore, String string, String string2) {
        List<TableIdentifier> list = this.getAllPartitions(wbConnection, string, string2);
        int n = dataStore.getRowCount();
        int n2 = 0;
        long l = System.currentTimeMillis();
        for (int i = n - 1; i >= 0; --i) {
            String string3;
            String string4 = dataStore.getValueAsString(i, 3);
            TableIdentifier tableIdentifier = new TableIdentifier(string4, string3 = dataStore.getValueAsString(i, 0));
            if (TableIdentifier.findTableByNameAndSchema(list, tableIdentifier) == null) continue;
            dataStore.deleteRow(i);
            ++n2;
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Removing " + n2 + " partitions from table list took: " + l2 + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableIdentifier> getAllPartitions(WbConnection wbConnection, String string, String string2) {
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("SELECT partitionschemaname, partitiontablename \nFROM pg_partitions ");
        boolean bl = false;
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(" \nWHERE ");
            SqlUtil.appendExpression(stringBuilder, "schemaname", string, wbConnection);
            bl = true;
        }
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append(bl ? "\n AND " : "\n WHERE ");
            SqlUtil.appendExpression(stringBuilder, "tablename", string2, wbConnection);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        CallerInfo callerInfo = new CallerInfo(){};
        long l = System.currentTimeMillis();
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            if (Settings.getInstance().getDebugMetadataSql()) {
                LogMgr.logInfo(callerInfo, "Retrieving all partitions using:\n" + stringBuilder);
            }
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                arrayList.add(new TableIdentifier(string3, string4));
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logError(callerInfo, "Error retrieving all partitions using:\n" + stringBuilder, exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(callerInfo, "Reading all partitions took: " + l2 + "ms");
        return arrayList;
    }
}

