/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.greenplum;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;

public class GreenplumUtil {
    public static int[] parseIntArray(String string) {
        if (string == null || string.length() < 3) {
            return new int[0];
        }
        String string2 = string.substring(1, string.length() - 1);
        String[] stringArray = string2.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = StringUtil.getIntValue(stringArray[i], 0);
        }
        return nArray;
    }

    public static String[] parseStringArray(String string) {
        if (string == null || string.length() < 3) {
            return new String[0];
        }
        String string2 = string.substring(1, string.length() - 1);
        return string2.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDatabaseVersionString(WbConnection wbConnection) {
        String string;
        ResultSet resultSet;
        Statement statement;
        block10: {
            if (wbConnection.isBusy()) {
                return null;
            }
            statement = null;
            resultSet = null;
            string = null;
            try {
                if (wbConnection.getUrl().startsWith("jdbc:postgresql")) {
                    statement = wbConnection.createStatement();
                    resultSet = statement.executeQuery("select version()");
                    if (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        Pattern pattern = Pattern.compile("Greenplum Database ([0-9.]+)", 2);
                        Matcher matcher = pattern.matcher(string2);
                        if (matcher.find()) {
                            string = matcher.group(1);
                        }
                    }
                    break block10;
                }
                string = wbConnection.getSqlConnection().getMetaData().getDatabaseProductVersion();
            }
            catch (Throwable throwable) {
                try {
                    LogMgr.logWarning(new CallerInfo(){}, "Could not retrieve database version using version()", throwable);
                    try {
                        string = wbConnection.getSqlConnection().getMetaData().getDatabaseProductVersion();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable3) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable3;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        return string;
    }

    public static VersionNumber getDatabaseVersion(WbConnection wbConnection) {
        String string = GreenplumUtil.getDatabaseVersionString(wbConnection);
        return new VersionNumber(string);
    }
}

