/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DomainIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class H2DomainReader
implements ObjectListExtender {
    final String baseSql = "SELECT domain_catalog,  \n       domain_schema, \n       domain_name, \n       type_name, \n       data_type, \n       precision, \n       scale, \n       is_nullable as nullable, \n       column_default as default_value, \n       check_constraint as constraint_definition, \n       remarks \n FROM information_schema.domains ";

    private String getSql(WbConnection wbConnection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("SELECT domain_catalog,  \n       domain_schema, \n       domain_name, \n       type_name, \n       data_type, \n       precision, \n       scale, \n       is_nullable as nullable, \n       column_default as default_value, \n       check_constraint as constraint_definition, \n       remarks \n FROM information_schema.domains ".length() + 40);
        stringBuilder.append("SELECT domain_catalog,  \n       domain_schema, \n       domain_name, \n       type_name, \n       data_type, \n       precision, \n       scale, \n       is_nullable as nullable, \n       column_default as default_value, \n       check_constraint as constraint_definition, \n       remarks \n FROM information_schema.domains ");
        boolean bl = false;
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append(" WHERE domain_name like '");
            stringBuilder.append(wbConnection.getMetadata().quoteObjectname(string2));
            stringBuilder.append("%' ");
            bl = true;
        }
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append(bl ? " AND " : " WHERE ");
            stringBuilder.append(" domain_schema = '");
            stringBuilder.append(wbConnection.getMetadata().quoteObjectname(string));
            stringBuilder.append("'");
        }
        stringBuilder.append(" ORDER BY 1, 2 ");
        LogMgr.logMetadataSql(new CallerInfo(){}, "domains", stringBuilder, new Object[0]);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DomainIdentifier> getDomainList(WbConnection wbConnection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        ArrayList<DomainIdentifier> arrayList = new ArrayList<DomainIdentifier>();
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.createStatementForQuery();
            String string3 = this.getSql(wbConnection, string, string2);
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("domain_catalog");
                String string5 = resultSet.getString("domain_schema");
                String string6 = resultSet.getString("domain_name");
                DomainIdentifier domainIdentifier = new DomainIdentifier(string4, string5, string6);
                domainIdentifier.setCheckConstraint(resultSet.getString("constraint_definition"));
                String string7 = resultSet.getString("type_name");
                int n = resultSet.getInt("data_type");
                int n2 = resultSet.getInt("precision");
                int n3 = resultSet.getInt("scale");
                String string8 = SqlUtil.getSqlTypeDisplay(string7, n, n3, n2);
                domainIdentifier.setDataType(string8);
                domainIdentifier.setNullable(resultSet.getBoolean("nullable"));
                domainIdentifier.setDefaultValue(resultSet.getString("default_value"));
                domainIdentifier.setComment(resultSet.getString("remarks"));
                arrayList.add(domainIdentifier);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logError(new CallerInfo(){}, "Could not read domains", sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public DomainIdentifier getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<DomainIdentifier> list = this.getDomainList(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public String getDomainSource(DomainIdentifier domainIdentifier) {
        if (domainIdentifier == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("CREATE DOMAIN ");
        stringBuilder.append(domainIdentifier.getObjectName());
        stringBuilder.append(" AS ");
        stringBuilder.append(domainIdentifier.getDataType());
        if (domainIdentifier.getDefaultValue() != null) {
            stringBuilder.append("\n   DEFAULT ");
            stringBuilder.append(domainIdentifier.getDefaultValue());
        }
        if (StringUtil.isNonBlank(domainIdentifier.getCheckConstraint()) || !domainIdentifier.isNullable()) {
            stringBuilder.append("\n   CHECK ");
            if (StringUtil.isNonBlank(domainIdentifier.getConstraintName())) {
                stringBuilder.append(domainIdentifier.getConstraintName() + " ");
            }
            if (!domainIdentifier.isNullable()) {
                stringBuilder.append("NOT NULL ");
            }
            if (StringUtil.isNonBlank(domainIdentifier.getCheckConstraint())) {
                stringBuilder.append(domainIdentifier.getCheckConstraint());
            }
        }
        stringBuilder.append(";\n");
        if (StringUtil.isNonBlank(domainIdentifier.getComment())) {
            stringBuilder.append("\nCOMMENT ON DOMAIN " + domainIdentifier.getObjectName() + " IS '");
            stringBuilder.append(SqlUtil.escapeQuotes(domainIdentifier.getComment()));
            stringBuilder.append("';\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("DOMAIN", stringArray)) {
            return false;
        }
        List<DomainIdentifier> list = this.getDomainList(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (DomainIdentifier domainIdentifier : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)domainIdentifier.getSchema());
            dataStore.setValue(n, 0, (Object)domainIdentifier.getObjectName());
            dataStore.setValue(n, 4, (Object)domainIdentifier.getComment());
            dataStore.setValue(n, 1, (Object)domainIdentifier.getObjectType());
            dataStore.getRow(n).setUserObject(domainIdentifier);
        }
        return true;
    }

    @Override
    public boolean handlesType(String string) {
        return StringUtil.equalStringIgnoreCase("DOMAIN", string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        DomainIdentifier domainIdentifier = this.getObjectDefinition(wbConnection, dbObject);
        if (domainIdentifier == null) {
            return null;
        }
        String[] stringArray = new String[]{"DOMAIN", "DATA_TYPE", "NULLABLE", "CONSTRAINT", "REMARKS"};
        int[] nArray = new int[]{12, 12, 16, 12, 12};
        int[] nArray2 = new int[]{20, 10, 5, 30, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        dataStore.addRow();
        dataStore.setValue(0, 0, (Object)domainIdentifier.getObjectName());
        dataStore.setValue(0, 1, (Object)domainIdentifier.getDataType());
        dataStore.setValue(0, 2, (Object)domainIdentifier.isNullable());
        dataStore.setValue(0, 3, (Object)domainIdentifier.getCheckConstraint());
        dataStore.setValue(0, 4, (Object)domainIdentifier.getComment());
        return dataStore;
    }

    @Override
    public List<String> supportedTypes() {
        return Collections.singletonList("DOMAIN");
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        return this.getDomainSource(this.getObjectDefinition(wbConnection, dbObject));
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

