/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import workbench.db.DbMetadata;
import workbench.db.IndexDefinition;
import workbench.db.JdbcIndexReader;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class H2IndexReader
extends JdbcIndexReader {
    private Statement primaryKeysStatement;
    private boolean useJDBCRetrieval = Settings.getInstance().getBoolProperty("workbench.db.h2.getprimarykeyindex.usejdbc", false);

    public H2IndexReader(DbMetadata dbMetadata) {
        super(dbMetadata);
        if (!this.useJDBCRetrieval) {
            this.pkIndexNameColumn = "PK_INDEX_NAME";
        }
    }

    @Override
    protected ResultSet getPrimaryKeyInfo(String string, String string2, String string3) throws SQLException {
        if (this.useJDBCRetrieval) {
            return super.getPrimaryKeyInfo(string, string2, string3);
        }
        if (this.primaryKeysStatement != null) {
            LogMgr.logWarning(new CallerInfo(){}, "getPrimeryKeys() called with pending statement!");
            this.primaryKeysResultDone();
        }
        String string4 = "SELECT table_catalog as table_cat, \n       table_schema as table_schem, \n       table_name, \n       column_name, \n        ordinal_position as key_seq, \n        constraint_name as pk_name, \n       index_name as pk_index_name \nFROM information_schema.indexes \nWHERE primary_key = true \n";
        this.primaryKeysStatement = this.metaData.getSqlConnection().createStatement();
        if (StringUtil.isNonBlank(string2)) {
            string4 = string4 + " AND table_schema = '" + StringUtil.trimQuotes(string2) + "' ";
        }
        string4 = string4 + " AND table_name = '" + StringUtil.trimQuotes(string3) + "'";
        LogMgr.logMetadataSql(new CallerInfo(){}, "primary key info", string4, new Object[0]);
        return this.primaryKeysStatement.executeQuery(string4);
    }

    @Override
    protected void primaryKeysResultDone() {
        JdbcUtils.closeStatement(this.primaryKeysStatement);
        this.primaryKeysStatement = null;
    }

    @Override
    public CharSequence getIndexSource(TableIdentifier tableIdentifier, IndexDefinition indexDefinition) {
        if (indexDefinition == null) {
            return null;
        }
        if (indexDefinition.isUniqueConstraint()) {
            return this.getUniqueConstraint(tableIdentifier, indexDefinition);
        }
        return super.getIndexSource(tableIdentifier, indexDefinition);
    }
}

