/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hana;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ProcedureDefinition;
import workbench.db.SequenceDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class HanaDependencyReader
implements DependencyReader {
    private final Set<String> supportedTypes = CollectionUtil.caseInsensitiveSet("table", "view", "sequence", "procedure", "function", "trigger");
    private final String searchUsedBy = "select dependent_schema_name, dependent_object_name, dependent_object_type  \nfrom sys.object_dependencies\nwhere dependent_object_name not like '\\_SYS\\_TRIGGER\\_%' escape '\\' \n  and dependency_type in (0,1) \n  and base_schema_name = ? \n  and base_object_name = ?";
    private final String searchIsUsing = "select base_schema_name, base_object_name, base_object_type \nfrom sys.object_dependencies\nwhere base_object_name not like '\\_SYS\\_TRIGGER\\_%' escape '\\' \n  and dependency_type in (0,1) \n  and dependent_schema_name = ? \n  and dependent_object_name = ? ";

    @Override
    public List<DbObject> getUsedObjects(WbConnection wbConnection, DbObject dbObject) {
        return this.retrieveObjects(wbConnection, dbObject, "select base_schema_name, base_object_name, base_object_type \nfrom sys.object_dependencies\nwhere base_object_name not like '\\_SYS\\_TRIGGER\\_%' escape '\\' \n  and dependency_type in (0,1) \n  and dependent_schema_name = ? \n  and dependent_object_name = ? ");
    }

    @Override
    public List<DbObject> getUsedBy(WbConnection wbConnection, DbObject dbObject) {
        return this.retrieveObjects(wbConnection, dbObject, "select dependent_schema_name, dependent_object_name, dependent_object_type  \nfrom sys.object_dependencies\nwhere dependent_object_name not like '\\_SYS\\_TRIGGER\\_%' escape '\\' \n  and dependency_type in (0,1) \n  and base_schema_name = ? \n  and base_object_name = ?");
    }

    @Override
    public boolean supportsUsedByDependency(String string) {
        return this.supportedTypes.contains(string);
    }

    @Override
    public boolean supportsIsUsingDependency(String string) {
        return this.supportedTypes.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DbObject> retrieveObjects(WbConnection wbConnection, DbObject dbObject, String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        LogMgr.logMetadataSql(new CallerInfo(){}, "dependent objects", string, dbObject.getSchema(), dbObject.getObjectName());
        boolean bl = wbConnection.getMetadata().isTableType(dbObject.getObjectType());
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, dbObject.getSchema());
            preparedStatement.setString(2, dbObject.getObjectName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                if (bl && "TRIGGER".equalsIgnoreCase(string4)) continue;
                DbObject dbObject2 = null;
                if (string4.equals("PROCEDURE")) {
                    dbObject2 = new ProcedureDefinition(null, string2, string3);
                } else if (string4.equals("FUNCTION")) {
                    dbObject2 = new ProcedureDefinition(null, string2, string3, 2);
                } else if (string4.equals("TRIGGER")) {
                    dbObject2 = new TriggerDefinition(null, string2, string3);
                } else if (string4.equals("SEQUENCE")) {
                    dbObject2 = new SequenceDefinition(string2, string3);
                } else {
                    TableIdentifier tableIdentifier = new TableIdentifier(null, string2, string3, false);
                    tableIdentifier.setNeverAdjustCase(true);
                    tableIdentifier.setType(string4);
                    dbObject2 = tableIdentifier;
                }
                arrayList.add(dbObject2);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "dependent objects", string, dbObject.getSchema(), dbObject.getObjectName());
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }
}

