/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hana;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class HanaSequenceReader
implements SequenceReader {
    private WbConnection dbConn;
    private String baseQuery;
    private static final String PROP_RESET_QUERY = "reset_by_query";

    public HanaSequenceReader(WbConnection wbConnection) {
        this.dbConn = wbConnection;
        this.baseQuery = "SELECT schema_name, \n       sequence_name, \n       start_number, \n       min_value, \n       max_value, \n       increment_by, \n       is_cycled, \n       cache_size, \n       reset_by_query \nFROM sys.sequences";
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        CharSequence charSequence = this.getSequenceSource(sequenceDefinition.getCatalog(), sequenceDefinition.getSequenceOwner(), sequenceDefinition.getSequenceName());
        sequenceDefinition.setSource(charSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(this.baseQuery.length() + 20);
        stringBuilder.append(this.baseQuery);
        boolean bl = false;
        CallerInfo callerInfo = new CallerInfo(){};
        if (StringUtil.isNonBlank(string3)) {
            bl = true;
            stringBuilder.append(" WHERE ");
            SqlUtil.appendExpression(stringBuilder, "sequence_name", StringUtil.trimQuotes(string3), this.dbConn);
        }
        if (StringUtil.isNonBlank(string2)) {
            if (!bl) {
                stringBuilder.append(" WHERE ");
            } else {
                stringBuilder.append(" AND ");
            }
            SqlUtil.appendExpression(stringBuilder, "schema_name", StringUtil.trimQuotes(string2), null);
        }
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logInfo(callerInfo, "Using query=" + stringBuilder);
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        try {
            preparedStatement = this.dbConn.getSqlConnection().prepareStatement(stringBuilder.toString());
            resultSet = preparedStatement.executeQuery();
            dataStore = new DataStore(resultSet, true);
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logError(callerInfo, "Error when retrieving sequence definition", throwable);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable2;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createSequenceDefinition(dataStore, i));
        }
        return arrayList;
    }

    private SequenceDefinition createSequenceDefinition(DataStore dataStore, int n) {
        SequenceDefinition sequenceDefinition = null;
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        String string = null;
        String string2 = dataStore.getValueAsString(n, "sequence_name");
        String string3 = dataStore.getValueAsString(n, "schema_name");
        sequenceDefinition = new SequenceDefinition(string3, string2);
        sequenceDefinition.setCatalog(string);
        sequenceDefinition.setSequenceProperty("start_value", dataStore.getValue(n, "start_number"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(n, "max_value"));
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(n, "min_value"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "increment_by"));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(n, "cache_size"));
        sequenceDefinition.setSequenceProperty(PROP_RESET_QUERY, dataStore.getValue(n, PROP_RESET_QUERY));
        sequenceDefinition.setSequenceProperty("cycle", StringUtil.stringToBool(dataStore.getValueAsString(n, "is_cycled")));
        sequenceDefinition.setSource(this.buildSource(sequenceDefinition));
        return sequenceDefinition;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return null;
        }
        return this.createSequenceDefinition(dataStore, 0);
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        return this.buildSource(sequenceDefinition);
    }

    protected CharSequence buildSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE SEQUENCE ");
        String string = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append(SqlUtil.quoteObjectname(sequenceDefinition.getSchema()));
        stringBuilder.append('.');
        stringBuilder.append(SqlUtil.quoteObjectname(sequenceDefinition.getSequenceName()));
        Number number = (Number)sequenceDefinition.getSequenceProperty("start_value");
        stringBuilder.append(string);
        stringBuilder.append("       START WITH ");
        stringBuilder.append(number);
        long l = ((Number)sequenceDefinition.getSequenceProperty("increment")).longValue();
        stringBuilder.append(string);
        stringBuilder.append("       INCREMENT BY ");
        stringBuilder.append(l);
        Number number2 = (Number)sequenceDefinition.getSequenceProperty("min_value");
        stringBuilder.append(string);
        if (number2 == null || number2.intValue() == 1 || l < 0L && number2.toString().equals("-4611686018427387903")) {
            stringBuilder.append("       NO MINVALUE");
        } else {
            stringBuilder.append("       MINVALUE");
            stringBuilder.append(number2);
        }
        Number number3 = (Number)sequenceDefinition.getSequenceProperty("max_value");
        stringBuilder.append(string);
        if (number3 == null || number3.toString().equals("4611686018427387903") || l < 0L && number3.intValue() == -1) {
            stringBuilder.append("       NO MAXVALUE");
        } else {
            stringBuilder.append("       MAXVALUE");
            stringBuilder.append(number3);
        }
        Boolean bl = (Boolean)sequenceDefinition.getSequenceProperty("cycle");
        stringBuilder.append(string);
        stringBuilder.append("       ");
        if (bl == null || !bl.booleanValue()) {
            stringBuilder.append("NO");
        }
        stringBuilder.append(" CYCLE");
        Number number4 = (Number)sequenceDefinition.getSequenceProperty("cache");
        stringBuilder.append(string);
        if (number4 != null) {
            stringBuilder.append("       CACHE ");
            stringBuilder.append(number4);
        } else {
            stringBuilder.append("       NO CACHE ");
        }
        String string2 = (String)sequenceDefinition.getSequenceProperty(PROP_RESET_QUERY);
        if (StringUtil.isNonBlank(string2)) {
            stringBuilder.append(string);
            stringBuilder.append("       RESET BY ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(';');
        stringBuilder.append(string);
        return stringBuilder;
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

