/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hana;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DataTypeResolver;
import workbench.db.JdbcTableDefinitionReader;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.SqlUtil;

public class HanaTableDefinitionReader
extends JdbcTableDefinitionReader {
    public static final String PROP_USE_JDBC_GETCOLUMNS = "tabledefinition.usejdbc";
    private PreparedStatement columnsStatement;

    public HanaTableDefinitionReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ColumnIdentifier> getTableColumns(TableIdentifier tableIdentifier, DataTypeResolver dataTypeResolver) throws SQLException {
        try {
            List<ColumnIdentifier> list;
            List<ColumnIdentifier> list2 = list = super.getTableColumns(tableIdentifier, dataTypeResolver);
            return list2;
        }
        finally {
            JdbcUtils.closeStatement(this.columnsStatement);
            this.columnsStatement = null;
        }
    }

    @Override
    protected void processColumnsResultRow(ResultSet resultSet, ColumnIdentifier columnIdentifier) throws SQLException {
        String string;
        if (!this.useJDBC() && (string = resultSet.getString("GENERATION_TYPE")) != null) {
            columnIdentifier.setDefaultValue(null);
            columnIdentifier.setComputedColumnExpression("GENERATED " + string);
            columnIdentifier.setIsAutoincrement(true);
        }
    }

    private boolean useJDBC() {
        if (this.dbConnection == null) {
            return false;
        }
        return this.dbConnection.getDbSettings().getBoolProperty(PROP_USE_JDBC_GETCOLUMNS, true);
    }

    @Override
    protected ResultSet getColumns(String string, String string2, String string3, String string4, String string5) throws SQLException {
        if (this.useJDBC()) {
            return super.getColumns(string, string2, string3, string4, string5);
        }
        String string6 = "sys.table_columns";
        String string7 = "table_name";
        if (this.dbConnection.getMetadata().isViewType(string5)) {
            string6 = "sys.view_columns";
            string7 = "view_name";
        }
        String string8 = "select null as table_cat,  \n       schema_name as table_schem,  \n       " + string7 + " as table_name,  \n       column_name,  \n       case data_type_id \n         when -10 then 2011 \n         else data_type_id \n       end as data_type, \n       data_type_name as type_name,  \n       length as column_size, \n       null as buffer_length, \n       case data_type_name \n         when 'DECIMAL' then scale \n         else null \n       end as decimal_digits, \n       case is_nullable \n         when 'TRUE' then 1 \n         else 0 \n       end as nullable, \n       comments as remarks, \n       default_value as column_def, \n       null as sql_data_type, \n       null as sql_datetime_sub, \n       case data_type_name \n         when 'CHAR' then length \n         when 'NCHAR' then length \n         when 'VARCHAR' then length \n         when 'NVARCHAR' then length \n         else null \n       end as char_octet_length, \n       position as ordinal_position, \n       case is_nullable \n         when 'TRUE' then 'YES' \n         else 'NO' \n       end as is_nullable, \n       case  \n         when generation_type is not null then 'YES' \n         else 'NO' \n       end as is_generatedcolumn, \n       case  \n         when generation_type LIKE '%AS IDENTITY' then 'YES' \n         else 'NO' \n       end as is_autoincrement, \n       generation_type \nfrom " + string6 + " tc \nwhere " + string7 + " LIKE ? ESCAPE '\\' \n  and schema_name LIKE ? ESCAPE '\\' \norder by position";
        this.columnsStatement = this.dbConnection.getSqlConnection().prepareStatement(string8);
        this.columnsStatement.setString(1, string3);
        this.columnsStatement.setString(2, string2);
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logDebug(new CallerInfo(){}, "Query to retrieve column information: " + SqlUtil.replaceParameters(string8, string3, string2));
        }
        return this.columnsStatement.executeQuery();
    }
}

