/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ArrayValueHandler;
import workbench.db.ColumnIdentifier;
import workbench.db.WbConnection;
import workbench.db.compare.BatchedStatement;
import workbench.util.ConverterException;
import workbench.util.CsvLineParser;
import workbench.util.QuoteEscapeType;
import workbench.util.ValueConverter;

public class HsqlArrayHandler
implements ArrayValueHandler {
    private final WbConnection conn;

    public HsqlArrayHandler(WbConnection wbConnection) {
        this.conn = wbConnection;
    }

    @Override
    public void setValue(BatchedStatement batchedStatement, int n, Object object, ColumnIdentifier columnIdentifier) throws SQLException {
        if (object == null) {
            batchedStatement.setNull(n, 2003);
        } else {
            Array array = this.parseArrayString(object, columnIdentifier);
            batchedStatement.setObject(n, array, 2003);
        }
    }

    @Override
    public void setValue(PreparedStatement preparedStatement, int n, Object object, ColumnIdentifier columnIdentifier) throws SQLException {
        if (object == null) {
            preparedStatement.setNull(n, 2003);
        } else {
            Array array = this.parseArrayString(object, columnIdentifier);
            preparedStatement.setArray(n, array);
        }
    }

    public Array parseArrayString(Object object, ColumnIdentifier columnIdentifier) throws SQLException {
        if (object instanceof Array) {
            return (Array)object;
        }
        String string = this.getBaseType(columnIdentifier);
        Object[] objectArray = this.createArray(object, string);
        Array array = this.conn.getSqlConnection().createArrayOf(string, objectArray);
        return array;
    }

    public Object[] createArray(Object object, String string) throws SQLException {
        String string2 = object.toString();
        if (string2.length() < 2) {
            return null;
        }
        string2 = string2.replaceFirst("(?i)^ARRAY", "");
        string2 = string2.substring(1, string2.length() - 1);
        CsvLineParser csvLineParser = new CsvLineParser(',', '\'');
        csvLineParser.setQuoteEscaping(QuoteEscapeType.duplicate);
        csvLineParser.setLine(string2);
        List<String> list = csvLineParser.getAllElements();
        ValueConverter valueConverter = new ValueConverter();
        int n = this.getJdbcType(string);
        Object[] objectArray = new Object[list.size()];
        try {
            for (int i = 0; i < list.size(); ++i) {
                objectArray[i] = valueConverter.convertValue(list.get(i), n);
            }
        }
        catch (ConverterException converterException) {
            throw new SQLException("Invalid literal", converterException);
        }
        return objectArray;
    }

    protected int getJdbcType(String string) {
        switch (string) {
            case "VARCHAR": 
            case "CHARACTER VARYING": 
            case "LONGVARCHAR": {
                return 12;
            }
            case "CHARACTER": 
            case "CHAR": {
                return 1;
            }
            case "CLOB": {
                return 2005;
            }
            case "BLOB": 
            case "BINARY LARGE OBJECT": {
                return 2004;
            }
            case "VARBINARY": {
                return -3;
            }
            case "BIT": {
                return -7;
            }
            case "BOOLEAN": {
                return 16;
            }
            case "INTEGER": {
                return 4;
            }
            case "TINYINT": {
                return -6;
            }
            case "BIGINT": {
                return -5;
            }
            case "SMALLINT": {
                return 5;
            }
            case "TIMESTAMP": {
                return 93;
            }
            case "TIME": {
                return 92;
            }
            case "DATE": {
                return 91;
            }
            case "REAL": {
                return 7;
            }
            case "DOUBLE": {
                return 8;
            }
            case "NUMERIC": 
            case "DECIMAL": {
                return 3;
            }
        }
        return 1111;
    }

    public String getBaseType(ColumnIdentifier columnIdentifier) {
        String string = columnIdentifier.getDbmsType();
        int n = string.indexOf("ARRAY");
        String string2 = string.substring(0, n - 1);
        if ((n = string2.indexOf(40)) > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }
}

