/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class HsqlColumnEnhancer
implements ColumnDefinitionEnhancer {
    private boolean supportColumnSequence = true;

    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        this.updateComputedColumns(tableDefinition, wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComputedColumns(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = tableDefinition.getTable().getRawTableName();
        String string2 = tableDefinition.getTable().getRawSchema();
        String string3 = "select column_name, \n       generation_expression, \n       is_generated, \n       is_identity, \n       identity_generation, \n       identity_start, \n       identity_increment, \n       data_type, \n       character_maximum_length \nfrom information_schema.columns \nwhere table_name = ? \nand table_schema = ? \nand (is_generated = 'ALWAYS' OR (is_identity = 'YES' AND identity_generation IS NOT NULL))";
        Map<String, SequenceDefinition> map = this.getColumnSequences(wbConnection, tableDefinition.getTable());
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object object;
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                String string8 = resultSet.getString(5);
                ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(tableDefinition.getColumns(), string4);
                if (columnIdentifier == null) continue;
                String string9 = null;
                if (map.containsKey(string4)) {
                    object = map.get(string4);
                    string9 = "GENERATED " + string8 + " AS SEQUENCE " + ((SequenceDefinition)object).getSequenceName();
                } else if (StringUtil.equalString(string6, "ALWAYS")) {
                    int n = string5.lastIndexOf(46);
                    if (n > 1) {
                        string5 = string5.substring(n + 1);
                    }
                    string9 = "GENERATED ALWAYS AS (" + string5 + ")";
                } else if (StringUtil.equalString(string7, "YES")) {
                    object = resultSet.getString(6);
                    String string10 = resultSet.getString(7);
                    string9 = "GENERATED " + string8 + " AS IDENTITY";
                    if (StringUtil.stringsAreNotEqual("0", (String)object) || StringUtil.stringsAreNotEqual("1", string10)) {
                        string9 = string9 + " (START WITH " + (String)object + " INCREMENT BY " + string10 + ")";
                    }
                }
                if (!StringUtil.isNonBlank(string9)) continue;
                columnIdentifier.setDefaultValue(null);
                columnIdentifier.setComputedColumnExpression(string9);
                columnIdentifier.setIsIdentity(string9.contains("IDENTITY"));
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error updating column information", exception);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SequenceDefinition> getColumnSequences(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        if (!this.supportColumnSequence || !JdbcUtils.hasMinimumServerVersion(wbConnection, "2.2")) {
            this.supportColumnSequence = false;
            return Collections.emptyMap();
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<String, SequenceDefinition> hashMap = new HashMap<String, SequenceDefinition>();
        try {
            String string = "SELECT column_name, sequence_catalog, sequence_schema, sequence_name \nFROM information_schema.system_column_sequence_usage \nWHERE table_schema = ? \n   AND table_name = ? ";
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getSchema());
            preparedStatement.setString(2, tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                String string5 = resultSet.getString(4);
                SequenceDefinition sequenceDefinition = new SequenceDefinition(string3, string4, string5);
                hashMap.put(string2, sequenceDefinition);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.supportColumnSequence = false;
                LogMgr.logError(new CallerInfo(){}, "Error retrieving sequence for column", sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return hashMap;
    }
}

