/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceAdjuster;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class HsqlSequenceAdjuster
implements SequenceAdjuster {
    @Override
    public int adjustTableSequences(WbConnection wbConnection, TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        List<String> list = this.getIdentityColumns(wbConnection, tableIdentifier);
        for (String string : list) {
            this.syncSingleSequence(wbConnection, tableIdentifier, string);
        }
        if (bl && !wbConnection.getAutoCommit()) {
            wbConnection.commit();
        }
        return list.size();
    }

    private void syncSingleSequence(WbConnection wbConnection, TableIdentifier tableIdentifier, String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            statement = wbConnection.createStatement();
            long l = -1L;
            resultSet = statement.executeQuery("select max(" + string + ") from " + tableIdentifier.getTableExpression(wbConnection));
            if (resultSet.next()) {
                l = resultSet.getLong(1) + 1L;
                JdbcUtils.closeResult(resultSet);
            }
            if (l > 0L) {
                string2 = "alter table " + tableIdentifier.getTableExpression(wbConnection) + " alter column " + string + " restart with " + Long.toString(l);
                LogMgr.logDebug(new CallerInfo(){}, "Syncing sequence using: " + string2);
                statement.execute(string2);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not adjust sequence using:\n" + string2, sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getIdentityColumns(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "select column_name from information_schema.columns \nwhere table_name = ? \n and table_schema = ? \n and (is_generated = 'ALWAYS' OR (is_identity = 'YES' AND identity_generation IS NOT NULL))";
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            preparedStatement.setString(2, tableIdentifier.getRawSchema());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                arrayList.add(string2);
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read sequence columns", sQLException);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        return arrayList;
    }
}

