/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class HsqlSequenceReader
implements SequenceReader {
    private WbConnection dbConn;
    private String baseQuery;
    private boolean supportsColumnSequence;

    public HsqlSequenceReader(WbConnection wbConnection) {
        this.dbConn = wbConnection;
        String string = "SELECT sequence_catalog, \n       sequence_schema, \n       sequence_name, \n       dtd_identifier as data_type, \n       maximum_value, \n       minimum_value, \n       increment, \n       cycle_option,  \n       start_with \nFROM ";
        if (JdbcUtils.hasMinimumServerVersion(wbConnection, "2.0")) {
            string = string + "information_schema.sequences";
            string = string.replace("dtd_identifier as data_type", "data_type");
        } else {
            string = string + "information_schema.system_sequences";
        }
        this.baseQuery = string;
        this.supportsColumnSequence = JdbcUtils.hasMinimumServerVersion(wbConnection, "2.1.1");
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        CharSequence charSequence = this.getSequenceSource(sequenceDefinition.getCatalog(), sequenceDefinition.getSequenceOwner(), sequenceDefinition.getSequenceName());
        sequenceDefinition.setSource(charSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(this.baseQuery.length() + 20);
        stringBuilder.append(this.baseQuery);
        boolean bl = false;
        if (StringUtil.isNonBlank(string3)) {
            bl = true;
            stringBuilder.append(" WHERE ");
            SqlUtil.appendExpression(stringBuilder, "sequence_name", StringUtil.trimQuotes(string3), this.dbConn);
        }
        if (StringUtil.isNonBlank(string2)) {
            if (!bl) {
                stringBuilder.append(" WHERE ");
            } else {
                stringBuilder.append(" AND ");
            }
            SqlUtil.appendExpression(stringBuilder, "sequence_schema", StringUtil.trimQuotes(string2), null);
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence definition", stringBuilder, new Object[0]);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        try {
            preparedStatement = this.dbConn.getSqlConnection().prepareStatement(stringBuilder.toString());
            resultSet = preparedStatement.executeQuery();
            dataStore = new DataStore(resultSet, true);
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, throwable, "sequence definition", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable2;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            arrayList.add(this.createSequenceDefinition(dataStore, i));
        }
        return arrayList;
    }

    private SequenceDefinition createSequenceDefinition(DataStore dataStore, int n) {
        SequenceDefinition sequenceDefinition = null;
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        String string = dataStore.getValueAsString(n, "SEQUENCE_CATALOG");
        String string2 = dataStore.getValueAsString(n, "SEQUENCE_NAME");
        String string3 = dataStore.getValueAsString(n, "SEQUENCE_SCHEMA");
        sequenceDefinition = new SequenceDefinition(string3, string2);
        sequenceDefinition.setCatalog(string);
        sequenceDefinition.setSequenceProperty("start_value", dataStore.getValue(n, "START_WITH"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(n, "MAXIMUM_VALUE"));
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(n, "MINIMUM_VALUE"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "INCREMENT"));
        sequenceDefinition.setSequenceProperty("cycle", dataStore.getValue(n, "CYCLE_OPTION"));
        sequenceDefinition.setSequenceProperty("data_type", dataStore.getValue(n, "DATA_TYPE"));
        this.readRelatedTable(sequenceDefinition);
        sequenceDefinition.setSource(this.buildSource(sequenceDefinition));
        return sequenceDefinition;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null) {
            return null;
        }
        return this.createSequenceDefinition(dataStore, 0);
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        return this.buildSource(sequenceDefinition);
    }

    protected CharSequence buildSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE SEQUENCE ");
        String string = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append(sequenceDefinition.getSequenceName());
        String string2 = (String)sequenceDefinition.getSequenceProperty("data_type");
        if (!"INTEGER".equals(string2)) {
            stringBuilder.append(" AS ");
            stringBuilder.append(string2);
        }
        String string3 = (String)sequenceDefinition.getSequenceProperty("start_value");
        stringBuilder.append(string);
        stringBuilder.append("       START WITH ");
        stringBuilder.append(string3);
        String string4 = (String)sequenceDefinition.getSequenceProperty("increment");
        stringBuilder.append(string);
        stringBuilder.append("       INCREMENT BY ");
        stringBuilder.append(string4);
        stringBuilder.append(';');
        stringBuilder.append(string);
        if (sequenceDefinition.getRelatedTable() != null) {
            stringBuilder.append(string);
            stringBuilder.append("-- Sequence for: ");
            stringBuilder.append(sequenceDefinition.getRelatedTable().getTableExpression());
            stringBuilder.append('.');
            stringBuilder.append(sequenceDefinition.getRelatedColumn());
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRelatedTable(SequenceDefinition sequenceDefinition) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block6: {
            if (sequenceDefinition == null) {
                return;
            }
            if (!this.supportsColumnSequence) {
                return;
            }
            String string = "SELECT table_catalog, table_schema, table_name, column_name \nFROM information_schema.system_column_sequence_usage \nWHERE sequence_schema = ? \n   AND sequence_name = ? ";
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.dbConn.getSqlConnection().prepareStatement(string);
                preparedStatement.setString(1, sequenceDefinition.getSchema());
                preparedStatement.setString(2, sequenceDefinition.getSequenceName());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block6;
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                String string5 = resultSet.getString(4);
                if (!StringUtil.isNonEmpty(string4) || !StringUtil.isNonEmpty(string5)) break block6;
                sequenceDefinition.setRelatedTable(new TableIdentifier(string2, string3, string4), string5);
            }
            catch (SQLException sQLException) {
                try {
                    this.supportsColumnSequence = false;
                    LogMgr.logError(new CallerInfo(){}, "Error retrieving sequence column", sQLException);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

