/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SynonymReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class HsqlSynonymReader
implements SynonymReader {
    @Override
    public List<TableIdentifier> getSynonymList(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        String string4 = "SELECT synonym_catalog, \n       synonym_schema, \n       synonym_name \n FROM information_schema.system_synonyms \nWHERE synonym_schema = ? \n";
        if (StringUtil.isNonBlank(string3)) {
            string4 = string4 + " AND synonym_name LIKE ?";
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonyms", string4, string2, string3);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
            preparedStatement.setString(1, string2);
            if (StringUtil.isNonBlank(string3)) {
                preparedStatement.setString(2, string3);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                String string7 = resultSet.getString(3);
                if (resultSet.wasNull()) continue;
                TableIdentifier tableIdentifier = new TableIdentifier(string5, string6, string7, false);
                tableIdentifier.setType("SYNONYM");
                tableIdentifier.setNeverAdjustCase(true);
                arrayList.add(tableIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonyms", string4, string2, string3);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    @Override
    public TableIdentifier getSynonymTable(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT object_catalog, \n       object_schema, \n       object_name, \n       object_type \nFROM information_schema.system_synonyms \nWHERE synonym_schema = ? \n  AND synonym_name = ?";
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonym table", string4, string2, string3);
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        TableIdentifier tableIdentifier = null;
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                String string7 = resultSet.getString(3);
                String string8 = resultSet.getString(4);
                tableIdentifier = new TableIdentifier(string5, string6, string7, false);
                tableIdentifier.setType(string8);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "synonym table", string4, string2, string3);
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return tableIdentifier;
    }

    @Override
    public boolean supportsReplace(WbConnection wbConnection) {
        return false;
    }
}

