/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.BaseObjectType;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.hsqldb.HsqlType;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class HsqlTypeReader
implements ObjectListExtender {
    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("TYPE", stringArray)) {
            return false;
        }
        List<HsqlType> list = this.getTypes(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (BaseObjectType baseObjectType : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, (Object)baseObjectType.getCatalog());
            dataStore.setValue(n, 3, (Object)baseObjectType.getSchema());
            dataStore.setValue(n, 0, (Object)baseObjectType.getObjectName());
            dataStore.setValue(n, 1, (Object)baseObjectType.getObjectType());
            dataStore.setValue(n, 4, (Object)baseObjectType.getComment());
            dataStore.getRow(n).setUserObject(baseObjectType);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HsqlType> getTypes(WbConnection wbConnection, String string, String string2) {
        ArrayList<HsqlType> arrayList = new ArrayList<HsqlType>();
        StringBuilder stringBuilder = new StringBuilder(100);
        String string3 = "SELECT user_defined_type_catalog, user_defined_type_schema, user_defined_type_name, source_dtd_identifier \nFROM information_schema.user_defined_types";
        stringBuilder.append(string3);
        boolean bl = false;
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append("\n WHERE ");
            SqlUtil.appendExpression(stringBuilder, "user_defined_type_schema", string, wbConnection);
            bl = true;
        }
        if (StringUtil.isNonEmpty(string2)) {
            if (bl) {
                stringBuilder.append(" AND ");
            } else {
                stringBuilder.append("\n WHERE ");
            }
            SqlUtil.appendExpression(stringBuilder, "user_defined_type_name", string2, wbConnection);
        }
        stringBuilder.append("\n ORDER BY 2,3 ");
        LogMgr.logMetadataSql(new CallerInfo(){}, "object types", stringBuilder, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                String string4 = resultSet.getString("user_defined_type_catalog");
                String string5 = resultSet.getString("user_defined_type_schema");
                String string6 = resultSet.getString("user_defined_type_name");
                String string7 = resultSet.getString("source_dtd_identifier");
                HsqlType hsqlType = new HsqlType(string5, string6);
                hsqlType.setCatalog(string4);
                hsqlType.setDataTypeName(string7);
                arrayList.add(hsqlType);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "object types", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("TYPE");
    }

    @Override
    public boolean handlesType(String string) {
        return "TYPE".equalsIgnoreCase(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        try {
            HsqlType hsqlType = this.getObjectDefinition(wbConnection, dbObject);
            if (hsqlType != null) {
                DataStore dataStore = new DataStore(new String[]{"TYPE_NAME", "DATA_TYPE"}, new int[]{12, 12});
                dataStore.addRow();
                dataStore.setValue(0, 0, (Object)hsqlType.getObjectName());
                dataStore.setValue(0, 1, (Object)hsqlType.getDataTypeName());
                return dataStore;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Cannot retrieve type columns", exception);
        }
        return null;
    }

    @Override
    public HsqlType getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        try {
            List<HsqlType> list = this.getTypes(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
            if (list.size() == 1) {
                return list.get(0);
            }
            return null;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Cannot retrieve type columns", exception);
            return null;
        }
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        HsqlType hsqlType = this.getObjectDefinition(wbConnection, dbObject);
        if (hsqlType == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE TYPE ");
        stringBuilder.append(hsqlType.getObjectName());
        stringBuilder.append(" AS ");
        stringBuilder.append(hsqlType.getDataTypeName());
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        return null;
    }

    @Override
    public boolean hasColumns() {
        return false;
    }
}

