/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.AbstractConstraintReader;
import workbench.db.DBID;
import workbench.db.WbConnection;

public class Db2ConstraintReader
extends AbstractConstraintReader {
    private final String HOST_TABLE_SQL = "select checkname, '('||checkcondition||')' \nfrom  sysibm.syschecks \nwhere tbname = ?   and tbowner = ?";
    private final String DB2I_TABLE_SQL = "select chk.constraint_name, '('||chk.check_clause||')' \nfrom  qsys2.syschkcst chk \n  JOIN qsys2.syscst cons ON cons.constraint_schema = chk.constraint_schema AND cons.constraint_name = chk.constraint_name where cons.table_name = ?   and cons.table_schema = ?";
    private final String LUW_TABLE_SQL = "select cons.constname, '('||cons.text||')' \nfrom syscat.checks cons \nwhere type <> 'S'   AND tabname = ?   and tabschema = ?";
    private final DBID dbid;
    private final Pattern sysname = Pattern.compile("^SQL[0-9]+");
    private final char catalogSeparator;

    public Db2ConstraintReader(WbConnection wbConnection) {
        super(wbConnection.getDbId());
        this.dbid = DBID.fromConnection(wbConnection);
        this.catalogSeparator = wbConnection.getMetadata().getCatalogSeparator();
    }

    @Override
    public boolean isSystemConstraintName(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = this.sysname.matcher(string);
        return matcher.matches();
    }

    @Override
    public String getColumnConstraintSql() {
        return null;
    }

    @Override
    public String getTableConstraintSql() {
        switch (this.dbid) {
            case DB2_ZOS: {
                return "select checkname, '('||checkcondition||')' \nfrom  sysibm.syschecks \nwhere tbname = ?   and tbowner = ?";
            }
            case DB2_ISERIES: {
                return "select chk.constraint_name, '('||chk.check_clause||')' \nfrom  qsys2.syschkcst chk \n  JOIN qsys2.syscst cons ON cons.constraint_schema = chk.constraint_schema AND cons.constraint_name = chk.constraint_name where cons.table_name = ?   and cons.table_schema = ?".replace("qsys2.", "qsys2" + this.catalogSeparator);
            }
        }
        return "select cons.constname, '('||cons.text||')' \nfrom syscat.checks cons \nwhere type <> 'S'   AND tabname = ?   and tabschema = ?";
    }

    @Override
    public int getIndexForTableNameParameter() {
        return 1;
    }

    @Override
    public int getIndexForSchemaParameter() {
        return 2;
    }
}

