/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class Db2iColumnEnhancer
implements ColumnDefinitionEnhancer {
    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        boolean bl = wbConnection.getDbSettings().getBoolProperty("remarks.columns.use_columntext", false);
        boolean bl2 = wbConnection.getDbSettings().getBoolProperty("remarks.columns.show_ccsid", true);
        if (bl2 || bl) {
            this.updateColumns(tableDefinition, wbConnection, bl, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateColumns(TableDefinition tableDefinition, WbConnection wbConnection, boolean bl, boolean bl2) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = wbConnection.getMetadata().removeQuotes(tableDefinition.getTable().getTableName());
        String string2 = wbConnection.getMetadata().removeQuotes(tableDefinition.getTable().getSchema());
        String string3 = "select column_name, \n       column_text, \n       ccsid \nfrom qsys2" + wbConnection.getMetadata().getCatalogSeparator() + "syscolumns \nwhere table_schema = ? \n  and table_name  = ?";
        LogMgr.logMetadataSql(new CallerInfo(){}, "column information", string3, string2, string);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ColumnIdentifier columnIdentifier;
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                int n = resultSet.getInt(3);
                if (resultSet.wasNull()) {
                    n = -1;
                }
                if ((columnIdentifier = ColumnIdentifier.findColumnInList(tableDefinition.getColumns(), string4)) == null) continue;
                if (bl && StringUtil.isNonEmpty(string5)) {
                    columnIdentifier.setComment(string5);
                }
                if (!bl2 || n <= 0 || !SqlUtil.isCharacterType(columnIdentifier.getDataType())) continue;
                columnIdentifier.setCollationExpression("CCSID " + n);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "column information", string3, string2, string);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }
}

