/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListEnhancer;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.SqlUtil;

public class Db2iObjectListEnhancer
implements ObjectListEnhancer {
    @Override
    public void updateObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (wbConnection.getDbSettings().getBoolProperty("remarks.tables.use_tabletext", false)) {
            this.updateObjectRemarks(wbConnection, dataStore, string, string2, string3, stringArray);
        }
    }

    public void updateObjectRemarks(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (dataStore == null) {
            return;
        }
        if (dataStore.getRowCount() == 0) {
            return;
        }
        boolean bl = DbMetadata.typeIncluded("TABLE", stringArray);
        if (!bl) {
            return;
        }
        String string4 = null;
        if (dataStore.getRowCount() == 1) {
            string4 = dataStore.getValueAsString(0, 0);
            stringArray = new String[]{dataStore.getValueAsString(0, 1)};
        }
        Map<String, String> map = this.readRemarks(wbConnection, string2, string4, stringArray);
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string5 = dataStore.getValueAsString(i, 0);
            String string6 = dataStore.getValueAsString(i, 3);
            String string7 = map.get(string6 + "." + string5);
            if (string7 == null) continue;
            dataStore.setValue(i, 4, (Object)string7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readRemarks(WbConnection wbConnection, String string, String string2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("select table_schema, table_name, table_text\nfrom qsys2" + wbConnection.getMetadata().getCatalogSeparator() + "systables t\n");
        boolean bl = false;
        if (string != null) {
            bl = true;
            stringBuilder.append("where ");
            SqlUtil.appendExpression(stringBuilder, "table_schema", string, wbConnection);
        }
        if (string2 != null) {
            if (bl) {
                stringBuilder.append("\n  and ");
            } else {
                stringBuilder.append("where ");
            }
            SqlUtil.appendExpression(stringBuilder, "table_name", string, wbConnection);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        if (string == null) {
            string = wbConnection.getMetadata().getCurrentSchema();
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
        String string3 = null;
        LogMgr.logMetadataSql(new CallerInfo(){}, "table remarks", stringBuilder, new Object[0]);
        try {
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string4;
                string3 = string4 = stringArray2[i];
                statement = wbConnection.createStatementForQuery();
                resultSet = statement.executeQuery(stringBuilder.toString());
                while (resultSet.next()) {
                    String string5 = resultSet.getString(2);
                    String string6 = resultSet.getString(3);
                    if (string5 == null || string6 == null) continue;
                    treeMap.put(string + "." + string5.trim(), string6);
                }
                JdbcUtils.closeResult(resultSet);
            }
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "table remarks", stringBuilder, new Object[0]);
        }
        finally {
            JdbcUtils.closeAll(resultSet, statement);
        }
        return treeMap;
    }
}

