/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class InformixColumnEnhancer
implements ColumnDefinitionEnhancer {
    private final Map<Integer, String> limits = new HashMap<Integer, String>(11);

    public InformixColumnEnhancer() {
        this.limits.put(0, "YEAR");
        this.limits.put(2, "MONTH");
        this.limits.put(4, "DAY");
        this.limits.put(6, "HOUR");
        this.limits.put(8, "MINUTE");
        this.limits.put(10, "SECOND");
        this.limits.put(11, "FRACTION(1)");
        this.limits.put(12, "FRACTION(2)");
        this.limits.put(13, "FRACTION(3)");
        this.limits.put(14, "FRACTION(4)");
        this.limits.put(15, "FRACTION(5)");
    }

    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        String string = wbConnection.getDbSettings().getProperty("qualifier.typenames", "datetime,interval");
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(StringUtil.stringToList(string, ",", true, true, false, false));
        boolean bl = false;
        for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
            String string2 = SqlUtil.getPlainTypeName(columnIdentifier.getDbmsType());
            if (set.contains(string2)) {
                bl = true;
            }
            int n = columnIdentifier.getDataType();
            String string3 = columnIdentifier.getDefaultValue();
            if (!this.defaultNeedsQuotes(string3, n, string2)) continue;
            string3 = "'" + string3 + "'";
            columnIdentifier.setDefaultValue(string3);
        }
        if (bl) {
            this.updateDateColumns(tableDefinition, wbConnection);
        }
    }

    private boolean defaultNeedsQuotes(String string, int n, String string2) {
        if (string == null) {
            return false;
        }
        if (SqlUtil.isNumberType(n)) {
            return false;
        }
        if (SqlUtil.isCharacterType(n)) {
            return true;
        }
        if ("boolean".equalsIgnoreCase(string2)) {
            return true;
        }
        if (SqlUtil.isDateType(n)) {
            Set<String> set = CollectionUtil.caseInsensitiveSet("today", "current");
            return !set.contains(string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDateColumns(TableDefinition tableDefinition, WbConnection wbConnection) {
        String string = tableDefinition.getTable().getRawCatalog();
        String string2 = wbConnection.getDbSettings().getProperty("systemschema", "informix");
        TableIdentifier tableIdentifier = new TableIdentifier(string, string2, "systables");
        TableIdentifier tableIdentifier2 = new TableIdentifier(string, string2, "syscolumns");
        String string3 = tableIdentifier.getFullyQualifiedName(wbConnection);
        String string4 = tableIdentifier2.getFullyQualifiedName(wbConnection);
        String string5 = wbConnection.getDbSettings().getProperty("qualifier.typevalues", "10,14,266,270");
        String string6 = "select c.colname, c.collength \nfrom " + string3 + " t \n  join " + string4 + " c on t.tabid = c.tabid \nwhere t.tabname = ? \n  and t.owner = ? \n  and c.coltype in (" + string5 + ")";
        String string7 = tableDefinition.getTable().getRawTableName();
        String string8 = tableDefinition.getTable().getRawSchema();
        LogMgr.logMetadataSql(new CallerInfo(){}, "column details", string6, string7, string8);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TreeMap<String, ColumnIdentifier> treeMap = new TreeMap<String, ColumnIdentifier>(CaseInsensitiveComparator.INSTANCE);
        for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
            treeMap.put(columnIdentifier.getColumnName(), columnIdentifier);
        }
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string6);
            preparedStatement.setString(1, string7);
            preparedStatement.setString(2, string8);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string9 = resultSet.getString(1);
                int n = resultSet.getInt(2);
                ColumnIdentifier columnIdentifier = (ColumnIdentifier)treeMap.get(string9);
                if (columnIdentifier != null) {
                    String string10 = this.getQualifier(n);
                    String string11 = SqlUtil.getPlainTypeName(columnIdentifier.getDbmsType());
                    String string12 = string11 + " " + string10;
                    LogMgr.logDebug(new CallerInfo(){}, "Column " + string7 + "." + (String)string9 + " has collength of: " + n + ". Changing type '" + columnIdentifier.getDbmsType() + "' to '" + string12 + "'");
                    columnIdentifier.setDbmsType(string12);
                    continue;
                }
                LogMgr.logError(new CallerInfo(){}, "The query returned a column name (" + (String)string9 + ") that was not part of the passed table definition!", null);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "column details", string6, string7, string8);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
    }

    String getQualifier(int n) {
        int n2 = n / 256;
        int n3 = n - n2 * 256;
        int n4 = n3 / 16;
        int n5 = n3 - n4 * 16;
        return this.limits.get(n4) + " TO " + this.limits.get(n5);
    }
}

