/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.ProcedureDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class InformixProcedureReader
extends JdbcProcedureReader {
    private boolean fixProcRetrieval;
    private boolean fixParamsRetrieval;
    private Map<String, Integer> typeMap;

    public InformixProcedureReader(WbConnection wbConnection) {
        super(wbConnection);
        boolean bl = this.connection.getDbSettings().getBoolProperty("procedurelist.usedriver", false);
        if (bl) {
            this.fixProcRetrieval = false;
            this.fixParamsRetrieval = false;
        } else {
            this.fixProcRetrieval = JdbcUtils.hasMinimumServerVersion(wbConnection, "10.0");
            this.fixParamsRetrieval = JdbcUtils.hasMinimumServerVersion(wbConnection, "11.0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getProcedures(String string, String string2, String string3) throws SQLException {
        Object object;
        if (!this.fixProcRetrieval) {
            LogMgr.logDebug(new CallerInfo(){}, "Using JDBC driver to retrieve procedures.");
            return super.getProcedures(string, string2, string3);
        }
        string = DbMetadata.cleanupWildcards(string);
        string2 = DbMetadata.cleanupWildcards(string2);
        string3 = DbMetadata.cleanupWildcards(string3);
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = this.getSQL(string, string2, string3);
        DataStore dataStore = this.buildProcedureListDataStore(this.connection.getMetadata(), false);
        boolean bl = this.connection.getDbSettings().getBoolProperty("procedurelist.showparameters", true);
        LogMgr.logMetadataSql(new CallerInfo(){}, "procedures", string4, new Object[0]);
        try {
            statement = this.connection.createStatementForQuery();
            resultSet = statement.executeQuery(string4);
            while (resultSet.next()) {
                object = resultSet.getString("PROCEDURE_SCHEM");
                String string5 = resultSet.getString("PROCEDURE_NAME");
                String string6 = resultSet.getString("SPECIFIC_NAME");
                String string7 = resultSet.getString("parameter_types");
                long l = resultSet.getLong("procid");
                int n = resultSet.getInt("PROCEDURE_TYPE");
                int n2 = dataStore.addRow();
                ProcedureDefinition procedureDefinition = new ProcedureDefinition(null, (String)object, string5, n);
                List<ParamDef> list = this.convertTypeList(string7);
                ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
                String string8 = "";
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        string8 = string8 + ",";
                    }
                    String string9 = "parameter_" + Integer.toString(i + 1);
                    ColumnIdentifier columnIdentifier = new ColumnIdentifier(string9);
                    String string10 = list.get((int)i).ifxTypeName;
                    string8 = string8 + string10;
                    columnIdentifier.setDbmsType(string10);
                    columnIdentifier.setDataType(this.getJdbcType(string10));
                    columnIdentifier.setArgumentMode(list.get((int)i).mode);
                    arrayList.add(columnIdentifier);
                }
                procedureDefinition.setParameters(arrayList);
                procedureDefinition.setSpecificName(string6);
                procedureDefinition.setInternalIdentifier(l);
                procedureDefinition.setDisplayName(string5 + "(" + string8 + ")");
                dataStore.setValue(n2, 2, null);
                dataStore.setValue(n2, 3, object);
                dataStore.setValue(n2, 0, (Object)(bl ? procedureDefinition.getDisplayName() : string5));
                dataStore.setValue(n2, 1, (Object)n);
                dataStore.setValue(n2, 4, null);
                dataStore.getRow(n2).setUserObject(procedureDefinition);
            }
            object = dataStore;
        }
        catch (Exception exception) {
            DataStore dataStore2;
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "procedures", string4, new Object[0]);
                this.fixProcRetrieval = false;
                dataStore2 = super.getProcedures(string, string2, string3);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
            return dataStore2;
        }
        JdbcUtils.closeAll(resultSet, statement);
        return object;
    }

    private List<ParamDef> convertTypeList(String string) {
        List<String> list = StringUtil.stringToList(string, ",", true, true);
        ArrayList<ParamDef> arrayList = new ArrayList<ParamDef>(list.size());
        for (String string2 : list) {
            String[] stringArray = string2.split(" ");
            ParamDef paramDef = new ParamDef();
            if (stringArray.length == 1) {
                paramDef.ifxTypeName = stringArray[0];
                paramDef.mode = "INPUT";
            } else if (stringArray.length == 2) {
                paramDef.mode = stringArray[0].toUpperCase();
                paramDef.ifxTypeName = stringArray[1];
            }
            arrayList.add(paramDef);
        }
        return arrayList;
    }

    private String getSQL(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(100);
        String string4 = this.getSysProceduresTable(string);
        stringBuilder.append("SELECT '' as PROCEDURE_CAT,  \n       owner as PROCEDURE_SCHEM, \n       procname as PROCEDURE_NAME, \n       '' as remarks, \n       CASE  \n         WHEN isproc = 'f' THEN 2  \n         ELSE 1  \n       END as PROCEDURE_TYPE, \n       specificname as specific_name, \n       procid, \n       paramtypes::LVARCHAR as parameter_types \nFROM " + string4 + " \nWHERE internal = 'f' \n  AND mode IN ('D', 'd', 'O', 'o', 'R', 'r') \n");
        SqlUtil.appendAndCondition(stringBuilder, "owner", string2, this.connection);
        SqlUtil.appendAndCondition(stringBuilder, "procname", string3, this.connection);
        return stringBuilder.toString();
    }

    @Override
    public DataStore getProcedureColumns(ProcedureDefinition procedureDefinition) throws SQLException {
        DataStore dataStore = null;
        if (this.fixParamsRetrieval) {
            dataStore = this.retrieveColumns(procedureDefinition);
        }
        if (dataStore == null && procedureDefinition != null && !procedureDefinition.getParameterTypes().isEmpty()) {
            dataStore = this.createProcColsDataStore();
            List<ColumnIdentifier> list = procedureDefinition.getParameters(null);
            int n = 1;
            for (ColumnIdentifier columnIdentifier : list) {
                int n2 = dataStore.addRow();
                dataStore.setValue(n2, 0, (Object)columnIdentifier.getColumnName());
                dataStore.setValue(n2, 2, (Object)columnIdentifier.getDbmsType());
                dataStore.setValue(n2, 5, (Object)n);
                dataStore.setValue(n2, 1, (Object)columnIdentifier.getArgumentMode());
                dataStore.setValue(n2, 3, (Object)this.getJdbcType(columnIdentifier.getDbmsType()));
                ++n;
            }
        } else if (dataStore == null) {
            dataStore = super.getProcedureColumns(procedureDefinition);
        }
        return dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore retrieveColumns(ProcedureDefinition procedureDefinition) {
        Object object;
        Object object2;
        String string = this.getSysProceduresTable(procedureDefinition.getCatalog());
        String string2 = this.getSysProcColumnsTable(procedureDefinition.getCatalog());
        String string3 = "select col.paramid,  \n       col.paramname,  \n       ifx_param_types(col.procid) as param_types, \n       ifx_ret_types(col.procid) as ret_types, \n       case  \n         when col.paramattr = 1 then 'INPUT' \n         when col.paramattr = 2 then 'INOUT' \n         when col.paramattr in (3,5) then 'RETURN' \n         when col.paramattr = 4 then 'OUT' \n         else '' \n       end as param_mode \nfrom " + string2 + " col \n  join " + string + " p on p.procid = col.procid \n";
        if (procedureDefinition.getInternalIdentifier() != null) {
            string3 = string3 + "where p.procid = " + procedureDefinition.getInternalIdentifier() + " \n";
        } else if (CollectionUtil.isNonEmpty(procedureDefinition.getParameterTypes())) {
            object2 = StringUtil.listToString(procedureDefinition.getParameterTypes(), ",", false);
            string3 = string3 + "where p.procname = '" + procedureDefinition.getProcedureName() + "' \n   and ifx_param_types(p.procid) = '" + (String)object2 + "' \n";
        }
        string3 = string3 + "order by col.paramid";
        LogMgr.logMetadataSql(new CallerInfo(){}, "procedure parameters", string3, new Object[0]);
        object2 = this.createProcColsDataStore();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatementForQuery();
            resultSet = statement.executeQuery(string3);
            boolean bl = true;
            List<ParamDef> list = null;
            while (resultSet.next()) {
                int n = resultSet.getInt("paramid");
                String string4 = resultSet.getString("paramname");
                String string5 = resultSet.getString("param_types");
                String string6 = resultSet.getString("param_mode");
                String string7 = resultSet.getString("ret_types");
                if (bl) {
                    list = this.convertTypeList(string5);
                    bl = false;
                }
                String string8 = null;
                if (n == 0) {
                    string8 = string7;
                } else if (n - 1 < list.size()) {
                    string8 = list.get((int)(n - 1)).ifxTypeName;
                }
                int n2 = ((DataStore)object2).addRow();
                ((DataStore)object2).setValue(n2, 0, (Object)string4);
                ((DataStore)object2).setValue(n2, 2, (Object)string8);
                ((DataStore)object2).setValue(n2, 5, (Object)n);
                ((DataStore)object2).setValue(n2, 1, (Object)string6);
                ((DataStore)object2).setValue(n2, 3, (Object)this.getJdbcType(string8));
            }
            object = object2;
        }
        catch (Exception exception) {
            DataStore dataStore;
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "procedure parameters", string3, new Object[0]);
                this.fixParamsRetrieval = false;
                dataStore = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
            return dataStore;
        }
        JdbcUtils.closeAll(resultSet, statement);
        return object;
    }

    private int getJdbcType(String string) {
        if (string == null) {
            return 1111;
        }
        String string2 = SqlUtil.getBaseTypeName(string);
        Integer n = this.getJavaTypeMapping().get(string2.toLowerCase());
        if (n == null) {
            return 1111;
        }
        return n;
    }

    private Map<String, Integer> getJavaTypeMapping() {
        if (this.typeMap == null) {
            this.typeMap = new HashMap<String, Integer>();
            this.typeMap.put("smallint", 5);
            this.typeMap.put("byte", 5);
            this.typeMap.put("integer", 4);
            this.typeMap.put("int8", -5);
            this.typeMap.put("int", 4);
            this.typeMap.put("serial", 4);
            this.typeMap.put("serial8", -5);
            this.typeMap.put("bigserial", -5);
            this.typeMap.put("money", 8);
            this.typeMap.put("numeric", 2);
            this.typeMap.put("decimal", 3);
            this.typeMap.put("dec", 3);
            this.typeMap.put("smallfloat", 6);
            this.typeMap.put("double precision", 6);
            this.typeMap.put("float", 8);
            this.typeMap.put("smallfloat", 6);
            this.typeMap.put("char", 1);
            this.typeMap.put("character", 1);
            this.typeMap.put("character varying", 12);
            this.typeMap.put("nchar", -15);
            this.typeMap.put("varchar", 12);
            this.typeMap.put("lvarchar", 12);
            this.typeMap.put("nvarchar", -9);
            this.typeMap.put("text", 2005);
            this.typeMap.put("boolean", 16);
            this.typeMap.put("bit", -7);
            this.typeMap.put("blob", 2004);
            this.typeMap.put("clob", 2005);
            this.typeMap.put("date", 91);
            this.typeMap.put("datetime", 93);
            this.typeMap.put("time", 92);
            this.typeMap.put("timetz", 92);
            this.typeMap.put("timestamp", 93);
            this.typeMap.put("timestamptz", 93);
        }
        return this.typeMap;
    }

    private String getSysProceduresTable(String string) {
        String string2 = this.getSystemSchema();
        TableIdentifier tableIdentifier = new TableIdentifier(string, string2, "sysprocedures");
        return tableIdentifier.getFullyQualifiedName(this.connection);
    }

    private String getSysProcColumnsTable(String string) {
        String string2 = this.getSystemSchema();
        TableIdentifier tableIdentifier = new TableIdentifier(string, string2, "sysproccolumns");
        return tableIdentifier.getFullyQualifiedName(this.connection);
    }

    private String getSystemSchema() {
        return this.connection.getDbSettings().getProperty("systemschema", "informix");
    }

    private static class ParamDef {
        String ifxTypeName = "";
        String mode = "INPUT";

        private ParamDef() {
        }
    }
}

