/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObjectFinder;
import workbench.db.DbSearchPath;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.db.exporter.BlobMode;
import workbench.db.importer.CycleErrorException;
import workbench.db.importer.DataReceiver;
import workbench.db.importer.DefaultTablenameResolver;
import workbench.db.importer.ImportFileColumn;
import workbench.db.importer.ImportFileHandler;
import workbench.db.importer.ImportFileLister;
import workbench.db.importer.TablenameResolver;
import workbench.db.importer.modifier.ImportValueModifier;
import workbench.interfaces.ImportFileParser;
import workbench.interfaces.JobErrorHandler;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.RowActionMonitor;
import workbench.util.BlobDecoder;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.MessageBuffer;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.ValueConverter;
import workbench.util.WbFile;

public abstract class AbstractImportFileParser
implements ImportFileParser {
    protected File inputFile;
    protected ImportFileLister sourceFiles;
    protected String tableName;
    protected String targetSchema;
    protected TableDefinition targetTable;
    protected String encoding;
    protected boolean multiFileImport;
    protected boolean trimValues;
    protected List<ImportFileColumn> importColumns;
    protected volatile boolean cancelImport;
    protected boolean regularStop;
    protected DataReceiver receiver;
    protected boolean abortOnError;
    protected WbConnection connection;
    protected MessageBuffer messages = new MessageBuffer();
    protected boolean sharedMessages;
    protected boolean hasErrors;
    protected boolean hasWarnings;
    protected ImportFileHandler fileHandler = new ImportFileHandler();
    protected List<String> currentRowValues;
    protected ImportValueModifier valueModifier;
    protected ValueConverter converter = new ValueConverter();
    protected JobErrorHandler errorHandler;
    protected List<File> filesProcessed = new ArrayList<File>(25);
    protected final BlobDecoder blobDecoder = new BlobDecoder();
    private BlobMode defaultBlobMode = BlobMode.SaveToFile;
    private final Map<String, BlobMode> columnBlobModes = new TreeMap<String, BlobMode>(CaseInsensitiveComparator.INSTANCE);
    protected RowActionMonitor rowMonitor;
    protected boolean ignoreMissingColumns;
    protected boolean clobsAreFilenames;
    protected boolean ignoreAllNullRows = Settings.getInstance().getBoolProperty("workbench.import.ignore.all_nulls", true);
    protected boolean checkTargetWithQuery;

    public AbstractImportFileParser() {
    }

    public AbstractImportFileParser(File file) {
        this();
        this.inputFile = file;
    }

    @Override
    public void setMessageBuffer(MessageBuffer messageBuffer) {
        if (messageBuffer != null) {
            this.messages = messageBuffer;
            this.sharedMessages = true;
        }
    }

    @Override
    public void setIgnoreMissingColumns(boolean bl) {
        this.ignoreMissingColumns = bl;
    }

    @Override
    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.rowMonitor = rowActionMonitor;
    }

    @Override
    public List<File> getProcessedFiles() {
        return this.filesProcessed;
    }

    @Override
    public ImportFileHandler getFileHandler() {
        return this.fileHandler;
    }

    public ImportValueModifier getValueModifier() {
        return this.valueModifier;
    }

    @Override
    public void setValueModifier(ImportValueModifier importValueModifier) {
        this.valueModifier = importValueModifier;
    }

    @Override
    public void setTargetSchema(String string) {
        this.targetSchema = string;
    }

    @Override
    public void setReceiver(DataReceiver dataReceiver) {
        this.receiver = dataReceiver;
    }

    @Override
    public void setInputFile(File file) {
        this.sourceFiles = null;
        this.inputFile = file;
    }

    @Override
    public void setCheckTargetWithQuery(boolean bl) {
        this.checkTargetWithQuery = bl;
    }

    @Override
    public void setMultiFileImport(boolean bl) {
        this.multiFileImport = bl;
    }

    @Override
    public boolean isMultiFileImport() {
        return this.multiFileImport;
    }

    @Override
    public void setSourceFiles(ImportFileLister importFileLister) {
        this.inputFile = null;
        this.sourceFiles = importFileLister;
    }

    @Override
    public void setTableName(String string) {
        this.tableName = string;
        this.targetTable = null;
        this.importColumns = null;
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Override
    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    @Override
    public String getSourceFilename() {
        if (this.inputFile == null) {
            return null;
        }
        if (this.fileHandler != null) {
            return this.fileHandler.getInputFilename();
        }
        return this.inputFile.getAbsolutePath();
    }

    @Override
    public String getLastRecord() {
        return StringUtil.listToString(this.currentRowValues, ',');
    }

    @Override
    public void setValueConverter(ValueConverter valueConverter) {
        if (valueConverter != null) {
            this.converter = valueConverter;
        }
    }

    public void setBlobModeForColumn(String string, BlobMode blobMode) {
        if (StringUtil.isNonEmpty(string) && blobMode != null) {
            this.columnBlobModes.put(string, blobMode);
        }
    }

    public BlobMode getBlobMode(String string) {
        return this.columnBlobModes.getOrDefault(string, this.defaultBlobMode);
    }

    public BlobMode getDefaultBlobMode() {
        return this.defaultBlobMode;
    }

    @Override
    public void setDefaultBlobMode(BlobMode blobMode) {
        this.defaultBlobMode = blobMode;
    }

    @Override
    public void setColumnBlobModes(Map<String, BlobMode> map) {
        if (map != null) {
            this.columnBlobModes.clear();
            this.columnBlobModes.putAll(map);
        }
    }

    @Override
    public abstract void setColumns(List<ColumnIdentifier> var1) throws SQLException;

    public void setColumnMap(List<ColumnIdentifier> list, List<ColumnIdentifier> list2) {
        this.importColumns = ImportFileColumn.createList();
        for (ColumnIdentifier columnIdentifier : list) {
            int n = list2.indexOf(columnIdentifier);
            if (n > -1) {
                ColumnIdentifier columnIdentifier2 = list2.get(n);
                ImportFileColumn importFileColumn = new ImportFileColumn(columnIdentifier2);
                importFileColumn.setTargetIndex(n);
                this.importColumns.add(importFileColumn);
                continue;
            }
            this.importColumns.add(ImportFileColumn.SKIP_COLUMN);
        }
    }

    protected TableIdentifier createTargetTableId() {
        TableIdentifier tableIdentifier = new TableIdentifier(this.getTablename(), this.connection);
        tableIdentifier.setPreserveQuotes(true);
        if (this.targetSchema != null) {
            tableIdentifier.setSchema(this.targetSchema);
        }
        if (this.connection != null && !this.checkTargetWithQuery) {
            tableIdentifier.adjustCase(this.connection);
            if (tableIdentifier.getSchema() == null) {
                tableIdentifier.setSchema(tableIdentifier.getSchemaToUse(this.connection));
            }
            if (tableIdentifier.getCatalog() == null) {
                tableIdentifier.setCatalog(tableIdentifier.getCatalogToUse(this.connection));
            }
        }
        return tableIdentifier;
    }

    protected String getTablename() {
        return this.tableName;
    }

    protected TableDefinition getTargetTable() throws SQLException {
        if (this.getTablename() == null) {
            return null;
        }
        if (this.targetTable != null) {
            return this.targetTable;
        }
        TableIdentifier tableIdentifier = this.createTargetTableId();
        if (this.connection == null) {
            LogMgr.logWarning(new CallerInfo(){}, "Can't verify target: " + tableIdentifier.getTableExpression());
            return null;
        }
        try {
            if (this.checkTargetWithQuery) {
                try {
                    TableSelectBuilder tableSelectBuilder = new TableSelectBuilder(this.connection, "tabledata");
                    tableSelectBuilder.setNeverUseFQN(true);
                    String string = tableSelectBuilder.getSelectForColumns(tableIdentifier, null, 1);
                    LogMgr.logDebug(new CallerInfo(){}, "Using query to detect table columns:\n" + string);
                    List<ColumnIdentifier> list = SqlUtil.getResultSetColumns(string, this.connection);
                    this.targetTable = new TableDefinition(tableIdentifier, list);
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error trying to detect the target table using a query", exception);
                }
            } else {
                DbSearchPath dbSearchPath;
                if (tableIdentifier.getSchema() == null && (dbSearchPath = DbSearchPath.Factory.getSearchPathHandler(this.connection)).isRealSearchPath()) {
                    DbObjectFinder dbObjectFinder = new DbObjectFinder(this.connection);
                    tableIdentifier = dbObjectFinder.searchObjectOnPath(tableIdentifier, this.connection.getMetadata().getTableTypesArray());
                }
                this.targetTable = this.connection.getMetadata().getTableDefinition(tableIdentifier, true);
            }
        }
        catch (SQLException sQLException) {
            String string = ResourceMgr.getFormattedString("ErrTargetTableNotFound", tableIdentifier.getTableExpression(this.connection));
            this.messages.append(string);
            this.messages.appendNewLine();
            this.messages.append(sQLException.getMessage());
            this.messages.appendNewLine();
            this.hasErrors = true;
            throw sQLException;
        }
        return this.targetTable;
    }

    @Override
    public void setConnection(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    @Override
    public String getEncoding() {
        return this.encoding == null ? Settings.getInstance().getDefaultDataEncoding() : this.encoding;
    }

    public void setEncoding(String string) {
        if (string == null) {
            return;
        }
        this.encoding = string;
    }

    @Override
    public MessageBuffer getMessages() {
        if (this.sharedMessages) {
            return null;
        }
        return this.messages;
    }

    @Override
    public void setAbortOnError(boolean bl) {
        this.abortOnError = bl;
    }

    @Override
    public void stop() {
        LogMgr.logDebug(new CallerInfo(){}, "Stopping import");
        this.cancelImport = true;
        this.regularStop = true;
    }

    @Override
    public void cancel() {
        LogMgr.logDebug(new CallerInfo(){}, "Cancelling import");
        this.cancelImport = true;
        this.regularStop = false;
    }

    @Override
    public void start() throws Exception {
        this.receiver.setTableCount(-1);
        this.receiver.setCurrentTable(-1);
        try {
            if (this.sourceFiles != null) {
                this.processDirectory();
            } else {
                this.processOneFile();
            }
        }
        finally {
            if (this.sourceFiles != null) {
                this.receiver.endMultiTable();
            }
            if (this.cancelImport && !this.regularStop) {
                this.receiver.importCancelled();
            } else {
                this.receiver.importFinished();
            }
            try {
                this.fileHandler.done();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void resetForFile() {
        this.cancelImport = false;
        this.regularStop = false;
        if (!this.sharedMessages) {
            this.messages.clear();
        }
        if (!this.multiFileImport) {
            this.tableName = null;
        }
    }

    protected TablenameResolver getTableNameResolver() {
        return new DefaultTablenameResolver();
    }

    protected void processDirectory() throws Exception {
        int n;
        if (this.sourceFiles == null) {
            throw new IllegalStateException("Cannot process source directory without FileNameSorter");
        }
        this.sourceFiles.setTableNameResolver(this.getTableNameResolver());
        if (!this.sourceFiles.containsFiles()) {
            String string = ResourceMgr.getFormattedString("ErrImpNoFiles", this.sourceFiles.getExtension(), this.sourceFiles.getDirectory());
            this.messages.append(string);
            this.hasErrors = true;
            throw new SQLException("No files with extension '" + this.sourceFiles.getExtension() + "' in directory " + this.sourceFiles.getDirectory());
        }
        List<WbFile> list = null;
        try {
            list = this.sourceFiles.getFiles();
        }
        catch (CycleErrorException cycleErrorException) {
            this.cancelImport = true;
            LogMgr.logError(new CallerInfo(){}, "Error when checking dependencies", cycleErrorException);
            throw cycleErrorException;
        }
        this.receiver.setTableList(this.sourceFiles.getTableList());
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            String string = ResourceMgr.getFormattedString("ErrImpNoMatch", this.sourceFiles.getDirectory());
            this.messages.append(string);
            this.hasErrors = true;
            throw new SQLException("No matching tables found for files in directory " + this.sourceFiles.getDirectory());
        }
        this.receiver.setTableCount(n);
        if (!this.multiFileImport) {
            this.receiver.beginMultiTable();
        }
        int n3 = 0;
        for (WbFile wbFile : list) {
            if (this.cancelImport) break;
            try {
                this.resetForFile();
                this.receiver.setCurrentTable(++n3);
                if (!this.multiFileImport) {
                    TableIdentifier tableIdentifier = this.sourceFiles.getTableForFile(wbFile);
                    this.setTableName(tableIdentifier.getTableExpression());
                }
                this.inputFile = wbFile;
                this.processOneFile();
            }
            catch (Exception exception) {
                this.hasErrors = true;
                this.receiver.tableImportError();
                if (!this.abortOnError) continue;
                throw exception;
            }
        }
    }

    protected List<ColumnIdentifier> getColumnsToImport() {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        for (ImportFileColumn importFileColumn : this.importColumns) {
            if (importFileColumn.getTargetIndex() < 0) continue;
            arrayList.add(importFileColumn.getColumn());
        }
        return arrayList;
    }

    protected void setupFileHandler() throws IOException {
        this.fileHandler.setMainFile(this.inputFile, this.getEncoding());
    }

    protected abstract void processOneFile() throws Exception;

    @Override
    public abstract Map<Integer, Object> getInputColumnValues(Collection<Integer> var1);

    @Override
    public String getColumns() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (ImportFileColumn importFileColumn : this.importColumns) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            if (importFileColumn != null && importFileColumn.getTargetIndex() != -1) {
                stringBuilder.append(importFileColumn.getColumn().getColumnName());
            } else {
                stringBuilder.append("$wb_skip$");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public void setErrorHandler(JobErrorHandler jobErrorHandler) {
        this.errorHandler = jobErrorHandler;
    }

    @Override
    public void setTrimValues(boolean bl) {
        this.trimValues = bl;
    }

    protected boolean isColumnFiltered(int n, String string) {
        if (this.importColumns == null) {
            return false;
        }
        if (n < 0 || n > this.importColumns.size()) {
            return false;
        }
        ImportFileColumn importFileColumn = this.importColumns.get(n);
        if (importFileColumn.getColumnFilter() == null) {
            return false;
        }
        int n2 = importFileColumn.getColumn().getDataType();
        if (SqlUtil.isBlobType(n2)) {
            return false;
        }
        if (SqlUtil.isClobType(n2) && this.clobsAreFilenames) {
            return false;
        }
        if (string == null) {
            return true;
        }
        Matcher matcher = importFileColumn.getColumnFilter().matcher(string);
        return !matcher.matches();
    }

    protected int getColumnIndex(String string) {
        if (string == null) {
            return -1;
        }
        if (this.importColumns == null) {
            return -1;
        }
        return this.importColumns.indexOf(string);
    }

    protected ColumnIdentifier getColumn(String string) {
        if (string == null) {
            return null;
        }
        if (this.importColumns == null) {
            return null;
        }
        for (ImportFileColumn importFileColumn : this.importColumns) {
            if (!importFileColumn.getColumn().getColumnName().equalsIgnoreCase(string)) continue;
            return importFileColumn.getColumn();
        }
        return null;
    }

    @Override
    public void addColumnFilter(String string, String string2) {
        int n = this.getColumnIndex(string);
        if (n == -1) {
            return;
        }
        try {
            Pattern pattern = Pattern.compile(string2);
            this.importColumns.get(n).setColumnFilter(pattern);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error compiling regular expression " + string2 + " for column " + string, exception);
            String string3 = ResourceMgr.getString("ErrImportBadRegex");
            string3 = StringUtil.replace(string3, "%regex%", string2);
            this.messages.append(string3);
            this.messages.appendNewLine();
            this.hasWarnings = true;
            this.importColumns.get(n).setColumnFilter(null);
        }
    }

    protected boolean isOnlyNull(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        for (Object object : objectArray) {
            if (object == null) continue;
            return false;
        }
        return true;
    }
}

