/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import workbench.db.ArrayValueHandler;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObjectFinder;
import workbench.db.DmlExpressionBuilder;
import workbench.db.DmlExpressionType;
import workbench.db.JdbcUtils;
import workbench.db.PkDefinition;
import workbench.db.SequenceAdjuster;
import workbench.db.TableCreator;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.compare.BatchedStatement;
import workbench.db.importer.BadfileWriter;
import workbench.db.importer.ColumnFilter;
import workbench.db.importer.ConstantColumnValues;
import workbench.db.importer.CycleErrorException;
import workbench.db.importer.DataReceiver;
import workbench.db.importer.DeleteType;
import workbench.db.importer.ImportDMLStatementBuilder;
import workbench.db.importer.ImportFileHandler;
import workbench.db.importer.ImportMode;
import workbench.db.importer.ImportTableDeleter;
import workbench.db.importer.ModeNotPossibleException;
import workbench.db.importer.OverrideIdentityType;
import workbench.db.importer.RowDataProducer;
import workbench.db.importer.SetObjectStrategy;
import workbench.db.importer.StreamImporter;
import workbench.db.importer.TableStatementError;
import workbench.db.importer.TableStatements;
import workbench.db.importer.ValueDisplay;
import workbench.db.importer.ValueStatement;
import workbench.interfaces.BatchCommitter;
import workbench.interfaces.ImportFileParser;
import workbench.interfaces.Interruptable;
import workbench.interfaces.ProgressReporter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.BlobLiteralType;
import workbench.storage.ColumnData;
import workbench.storage.RowActionMonitor;
import workbench.storage.SqlLiteralFormatter;
import workbench.storage.reader.TimestampTZHandler;
import workbench.util.BlobDecoder;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.ConverterException;
import workbench.util.EncodingUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.MemoryWatcher;
import workbench.util.MessageBuffer;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DataImporter
implements Interruptable,
DataReceiver,
ProgressReporter,
BatchCommitter,
ColumnFilter {
    private WbConnection dbConn;
    private RowDataProducer source;
    private BatchedStatement insertStatement;
    private BatchedStatement updateStatement;
    private TableIdentifier targetTable;
    private int commitEvery = 0;
    private DeleteType deleteTarget = DeleteType.none;
    private boolean createTarget;
    private String createType;
    private boolean continueOnError;
    private boolean ignoreIdentityColumns;
    private long totalRows = 0L;
    private long updatedRows = 0L;
    private long insertedRows = 0L;
    private long currentImportRow = 0L;
    private ImportMode mode = ImportMode.insert;
    private boolean useBatch;
    private int batchSize = -1;
    private boolean commitBatch;
    private boolean hasErrors;
    private boolean hasWarnings;
    private int reportInterval = 10;
    private MessageBuffer messages;
    private int totalTables = -1;
    private int currentTable = -1;
    private boolean transactionControl = true;
    private boolean useSetNull;
    private List<TableIdentifier> tablesToBeProcessed;
    private ImportTableDeleter tableDeleter;
    private int[] columnMap = null;
    private List<ColumnIdentifier> targetColumns;
    private List<ColumnIdentifier> keyColumns;
    private ConstantColumnValues columnConstants;
    private RowActionMonitor progressMonitor;
    private boolean isRunning;
    private ImportFileParser parser;
    private long startRow = 0L;
    private long endRow = Long.MAX_VALUE;
    private boolean partialImportEnded;
    private String whereClauseForUpdate;
    private BadfileWriter badWriter;
    private String badfileName;
    private boolean useSavepoint;
    private Savepoint insertSavepoint;
    private Savepoint updateSavepoint;
    private boolean checkRealClobLength;
    private boolean useSetStringForClobs;
    private boolean useSetClob;
    private boolean useSetBlob;
    private boolean useSetBytes;
    private boolean isOracle;
    private SetObjectStrategy useSetObjectWithType;
    private int maxErrorCount = 1000;
    private boolean verifyTargetTable = true;
    private boolean adjustSequences;
    private String insertSqlStart;
    private OverrideIdentityType overrideIdentity;
    private ArrayValueHandler arrayHandler;
    private BlobDecoder blobDecoder;
    private final Map<String, String> columnExpressions = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
    private boolean multiTable;
    private TableStatements tableStatements;
    private Map<Integer, Integer> typeMapping = new HashMap<Integer, Integer>();
    private int errorCount;
    private boolean errorLimitAdded;
    private TimestampTZHandler tzHandler;

    public DataImporter() {
        this.messages = new MessageBuffer();
        this.maxErrorCount = Settings.getInstance().getIntProperty("workbench.import.maxerrors", 1000);
    }

    public void setConnection(WbConnection wbConnection) {
        this.dbConn = wbConnection;
        if (this.dbConn == null) {
            return;
        }
        this.checkRealClobLength = this.dbConn.getDbSettings().needsExactClobLength();
        this.isOracle = this.dbConn.getMetadata().isOracle();
        this.useSetNull = this.dbConn.getDbSettings().useSetNull();
        this.useSetStringForClobs = this.dbConn.getDbSettings().sendClobsAsStrings();
        this.useSetClob = this.dbConn.getDbSettings().sendClobAsClob();
        this.useSetBlob = this.dbConn.getDbSettings().sendBlobAsBlob();
        this.useSetBytes = this.dbConn.getDbSettings().sendBlobAsBytes();
        this.useSetObjectWithType = this.dbConn.getDbSettings().getUseTypeWithSetObject();
        this.typeMapping = this.dbConn.getDbSettings().getTypeMappingForPreparedStatement();
        this.arrayHandler = ArrayValueHandler.Factory.getInstance(wbConnection);
        if (this.dbConn.getMetadata().isOracle()) {
            this.blobDecoder = new BlobDecoder();
        }
        this.tzHandler = TimestampTZHandler.Factory.getHandler(wbConnection);
    }

    public void setOverrideIdentity(OverrideIdentityType overrideIdentityType) {
        this.overrideIdentity = overrideIdentityType;
    }

    public void setColumnExpressions(Map<String, String> map) {
        this.columnExpressions.clear();
        if (map != null) {
            this.columnExpressions.putAll(map);
        }
    }

    public void setUseSavepoint(boolean bl) {
        this.useSavepoint = bl;
        if (this.dbConn != null) {
            if (this.dbConn.getAutoCommit()) {
                this.useSavepoint = false;
            }
            if (this.useSavepoint && !this.dbConn.supportsSavepoints()) {
                LogMgr.logWarning(new CallerInfo(){}, "A savepoint should be used for each statement but the driver does not support savepoints!");
                this.useSavepoint = false;
            }
        }
        LogMgr.logInfo(new CallerInfo(){}, "Using savepoints for DML: " + this.useSavepoint);
    }

    public void setAdjustSequences(boolean bl) {
        this.adjustSequences = bl;
    }

    public void setIgnoreIdentityColumns(boolean bl) {
        this.ignoreIdentityColumns = bl;
    }

    public void setInsertStart(String string) {
        this.insertSqlStart = StringUtil.isBlank(string) ? null : string;
    }

    private boolean supportsBatch() {
        if (this.dbConn == null) {
            return true;
        }
        return this.dbConn.getMetadata().supportsBatchUpdates();
    }

    @Override
    public boolean isTransactionControlEnabled() {
        return this.transactionControl;
    }

    public void setTransactionControl(boolean bl) {
        this.transactionControl = bl;
    }

    public RowActionMonitor getRowActionMonitor() {
        return this.progressMonitor;
    }

    public void setRowActionMonitor(RowActionMonitor rowActionMonitor) {
        this.progressMonitor = rowActionMonitor;
        if (this.progressMonitor != null) {
            this.progressMonitor.setMonitorType(0);
        }
    }

    public void setProducer(RowDataProducer rowDataProducer) {
        this.source = rowDataProducer;
        this.source.setReceiver(this);
        this.source.setAbortOnError(!this.continueOnError);
        if (rowDataProducer instanceof ImportFileParser) {
            this.parser = (ImportFileParser)rowDataProducer;
        }
    }

    public void setPerTableStatements(TableStatements tableStatements) {
        this.tableStatements = tableStatements != null && tableStatements.hasStatements() ? tableStatements : null;
    }

    @Override
    public void beginMultiTable() throws SQLException {
        this.multiTable = true;
        if (this.deleteTarget != DeleteType.none && this.tablesToBeProcessed != null) {
            this.deleteTargetTables();
        }
    }

    @Override
    public void endMultiTable() {
        this.multiTable = false;
        if (this.progressMonitor != null) {
            this.progressMonitor.jobFinished();
        }
    }

    public void setStartRow(long l) {
        this.startRow = l >= 0L ? l : 0L;
    }

    public void setEndRow(long l) {
        this.endRow = l >= 0L ? l : Long.MAX_VALUE;
    }

    @Override
    public void setCommitBatch(boolean bl) {
        this.commitBatch = bl;
        if (bl) {
            this.commitEvery = 0;
        }
    }

    @Override
    public void commitNothing() {
        this.commitBatch = false;
        this.commitEvery = Integer.MIN_VALUE;
    }

    public RowDataProducer getProducer() {
        return this.source;
    }

    @Override
    public void setCommitEvery(int n) {
        if (n > 0 || n == Integer.MIN_VALUE) {
            this.commitBatch = false;
        }
        this.commitEvery = n;
    }

    public boolean getContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean bl) {
        this.continueOnError = bl;
    }

    private int getRealBatchSize() {
        if (!this.useBatch || this.batchSize < 1) {
            return 1;
        }
        switch (this.mode) {
            case insert: 
            case update: 
            case upsert: {
                return this.batchSize;
            }
        }
        return 1;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    @Override
    public void setUseBatch(boolean bl) {
        this.useBatch = bl;
    }

    public void setBadfileName(String string) {
        this.badfileName = string;
    }

    public void setWhereClauseForUpdate(String string) {
        this.whereClauseForUpdate = StringUtil.isEmptyString(string) ? null : string;
    }

    @Override
    public void setTableList(List<TableIdentifier> list) {
        this.tablesToBeProcessed = list == null ? null : new ArrayList<TableIdentifier>(list);
    }

    @Override
    public void deleteTargetTables() throws SQLException {
        if (!this.isModeInsert()) {
            LogMgr.logWarning(new CallerInfo(){}, "Target tables will not be deleted because import mode is not set to 'insert'");
            this.messages.appendMessageKey("ErrImpNoDeleteUpd");
            this.messages.appendNewLine();
            return;
        }
        try {
            this.tableDeleter = new ImportTableDeleter(this.dbConn, true);
            this.tableDeleter.setRowMonitor(this.progressMonitor);
            this.tableDeleter.deleteRows(this.tablesToBeProcessed, true);
            this.messages.append(this.tableDeleter.getMessages());
        }
        finally {
            this.tableDeleter = null;
        }
    }

    public void setCreateTarget(boolean bl) {
        this.createTarget = bl;
    }

    @Override
    public boolean getCreateTarget() {
        return this.createTarget;
    }

    public void setDeleteTarget(DeleteType deleteType) {
        this.deleteTarget = deleteType;
    }

    public boolean needsKeyColumnInformation() {
        return this.mode != ImportMode.insert;
    }

    public boolean isModeInsert() {
        return this.mode == ImportMode.insert;
    }

    public boolean isModeUpsert() {
        return this.mode == ImportMode.upsert;
    }

    public boolean isModeInsertIgnore() {
        return this.mode == ImportMode.insertIgnore;
    }

    public boolean isModeUpdate() {
        return this.mode == ImportMode.update;
    }

    public boolean isModeInsertUpdate() {
        return this.mode == ImportMode.insertUpdate;
    }

    public boolean isModeUpdateInsert() {
        return this.mode == ImportMode.updateInsert;
    }

    public static int estimateReportIntervalFromFileSize(File file) {
        try {
            long l = FileUtil.estimateRecords(file, 10L);
            if (l < 100L) {
                return 1;
            }
            if (l < 10000L) {
                return 10;
            }
            if (l < 250000L) {
                return 100;
            }
            return 1000;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when checking input file", exception);
            return 10;
        }
    }

    public void setMode(ImportMode importMode) {
        this.mode = importMode;
    }

    public static ImportMode getModeValue(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        if ((string = string.trim().toLowerCase()).indexOf(44) == -1) {
            switch (string) {
                case "insert": {
                    return ImportMode.insert;
                }
                case "insertignore": {
                    return ImportMode.insertIgnore;
                }
                case "updateinsert": {
                    return ImportMode.updateInsert;
                }
                case "insertupdate": {
                    return ImportMode.insertUpdate;
                }
                case "upsert": {
                    return ImportMode.upsert;
                }
                case "update": {
                    return ImportMode.update;
                }
            }
            return null;
        }
        List<String> list = StringUtil.stringToList(string, ",", true, true);
        String string3 = list.size() > 0 ? list.get(0) : null;
        String string4 = string2 = list.size() > 1 ? list.get(1) : null;
        if ("insert".equals(string3) && "update".equals(string2)) {
            return ImportMode.insertUpdate;
        }
        if ("update".equals(string3) && "insert".equals(string2)) {
            return ImportMode.updateInsert;
        }
        return null;
    }

    public boolean setMode(String string) {
        return this.setMode(string, this.dbConn);
    }

    public boolean setMode(String string, WbConnection wbConnection) {
        if (StringUtil.isEmptyString(string)) {
            return true;
        }
        ImportMode importMode = DataImporter.getModeValue(string);
        if (importMode == null) {
            return false;
        }
        if (importMode == ImportMode.insertIgnore && !ImportDMLStatementBuilder.supportsInsertIgnore(wbConnection)) {
            return false;
        }
        if (importMode == ImportMode.upsert && !ImportDMLStatementBuilder.supportsUpsert(wbConnection)) {
            return false;
        }
        this.setMode(importMode);
        return true;
    }

    public void setConstantColumnValues(ConstantColumnValues constantColumnValues) {
        this.columnConstants = null;
        if (constantColumnValues != null && constantColumnValues.getColumnCount() > 0) {
            this.columnConstants = constantColumnValues;
        }
    }

    public void setKeyColumns(String string) {
        List<String> list = StringUtil.stringToList(string, ",");
        int n = list.size();
        this.keyColumns = new ArrayList<ColumnIdentifier>();
        for (int i = 0; i < n; ++i) {
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(list.get(i));
            this.keyColumns.add(columnIdentifier);
        }
    }

    public List<ColumnIdentifier> getKeyColumns() {
        if (this.keyColumns == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.keyColumns);
    }

    public void setKeyColumns(List<ColumnIdentifier> list) {
        this.keyColumns = list == null ? null : new ArrayList<ColumnIdentifier>(list);
    }

    private int getColCount() {
        if (this.targetColumns == null) {
            return 0;
        }
        return this.targetColumns.size();
    }

    private boolean hasKeyColumns() {
        return CollectionUtil.isNonEmpty(this.keyColumns);
    }

    @Override
    public boolean ignoreColumn(ColumnIdentifier columnIdentifier) {
        if (columnIdentifier == null) {
            return true;
        }
        if (!this.ignoreIdentityColumns) {
            return false;
        }
        return columnIdentifier.isAutoGenerated();
    }

    public void startImport() throws IOException, SQLException, Exception {
        if (this.source == null) {
            return;
        }
        this.isRunning = true;
        this.source.setMessageBuffer(this.messages);
        try {
            this.source.start();
        }
        catch (CycleErrorException cycleErrorException) {
            this.hasErrors = true;
            this.messages.appendMessageKey("ErrImpCycle");
            this.messages.append(" (" + cycleErrorException.getRootTable() + ")");
            this.messages.append(this.source.getMessages());
            throw cycleErrorException;
        }
        catch (Exception exception) {
            this.hasErrors = true;
            this.messages.append(this.source.getMessages());
            if (this.parser != null) {
                String string = ResourceMgr.getFormattedString("ErrFileNotImported", this.parser.getSourceFilename());
                this.messages.append(string);
                this.messages.appendNewLine();
            }
            throw exception;
        }
    }

    public static boolean isDeleteTableAllowed(ImportMode importMode) {
        return importMode == ImportMode.insert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTarget() throws SQLException {
        if (this.deleteTarget == DeleteType.none) {
            return;
        }
        if (this.targetTable == null) {
            return;
        }
        String string = null;
        if (!this.isModeInsert()) {
            LogMgr.logWarning(new CallerInfo(){}, "Target table will not be deleted because import mode is not set to 'insert'");
            this.messages.append(ResourceMgr.getString("ErrImpNoDeleteUpd"));
            this.messages.appendNewLine();
            return;
        }
        string = this.deleteTarget == DeleteType.truncate ? "TRUNCATE TABLE " + this.targetTable.getTableExpression(this.dbConn) : "DELETE FROM " + this.targetTable.getTableExpression(this.dbConn);
        Statement statement = null;
        try {
            statement = this.dbConn.createStatement();
            LogMgr.logInfo(new CallerInfo(){}, "Executing: [" + string + "] to delete target table...");
            int n = statement.executeUpdate(string);
            if (this.deleteTarget == DeleteType.truncate) {
                String string2 = ResourceMgr.getString("MsgImportTableTruncated").replace("%table%", this.targetTable.getTableExpression(this.dbConn));
                this.messages.append(string2);
                this.messages.appendNewLine();
            } else {
                this.messages.append(n + " " + ResourceMgr.getString("MsgImporterRowsDeleted") + " " + this.targetTable.getTableExpression(this.dbConn) + "\n");
            }
        }
        finally {
            JdbcUtils.closeStatement(statement);
        }
    }

    private void createTarget() throws SQLException {
        TableCreator tableCreator = new TableCreator(this.dbConn, this.createType, this.targetTable, this.targetColumns);
        tableCreator.useDbmsDataType(true);
        tableCreator.createTable();
        String string = tableCreator.getTable().getTableName();
        String string2 = StringUtil.replace(ResourceMgr.getString("MsgImporterTableCreated"), "%table%", string);
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.dbConn);
        this.targetTable = dbObjectFinder.findTable(this.targetTable);
        this.messages.append(string2);
        this.messages.appendNewLine();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isSuccess() {
        return !this.hasErrors;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public long getAffectedRows() {
        return this.totalRows;
    }

    public long getInsertedRows() {
        return this.insertedRows;
    }

    public long getUpdatedRows() {
        return this.updatedRows;
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }

    @Override
    public void cancelExecution() {
        if (this.tableDeleter != null) {
            this.tableDeleter.cancel();
        }
        if (this.source != null) {
            this.source.cancel();
        }
        this.messages.append(ResourceMgr.getString("MsgImportCancelled") + "\n");
    }

    private void cancelStatement(BatchedStatement batchedStatement) {
        if (batchedStatement == null) {
            return;
        }
        try {
            batchedStatement.cancel();
        }
        catch (Exception exception) {
            LogMgr.logDebug(new CallerInfo(){}, "Error when cancelling statement", exception);
        }
    }

    @Override
    public void setTableCount(int n) {
        this.totalTables = n;
    }

    @Override
    public void setCurrentTable(int n) {
        this.currentTable = n;
    }

    private void addError(String string) {
        ++this.errorCount;
        if (this.errorCount < this.maxErrorCount) {
            this.messages.append(string);
        } else if (!this.errorLimitAdded) {
            this.messages.appendNewLine();
            this.messages.append(ResourceMgr.getString("MsgImpTooManyError"));
            this.messages.appendNewLine();
            this.errorLimitAdded = true;
        }
    }

    @Override
    public void recordRejected(String string, long l, Throwable throwable) {
        if (string == null) {
            return;
        }
        if (this.badWriter != null) {
            this.badWriter.recordRejected(string);
        } else {
            this.addError(ResourceMgr.getString("ErrImportingRow") + " " + l + "\n");
            this.addError(ResourceMgr.getString("ErrImportErrorMsg") + " " + ExceptionUtil.getAllExceptions(throwable) + "\n");
            this.addError(ResourceMgr.getString("ErrImportValues") + " " + string + "\n");
            if (this.errorLimitAdded) {
                LogMgr.logError(new CallerInfo(){}, "Values: " + string, throwable);
            }
        }
    }

    @Override
    public boolean shouldProcessNextRow() {
        return this.currentImportRow + 1L >= this.startRow && this.currentImportRow + 1L <= this.endRow;
    }

    @Override
    public void nextRowSkipped() {
        ++this.currentImportRow;
        if (this.currentImportRow >= this.endRow) {
            this.endRowReached();
        }
    }

    private void endRowReached() {
        LogMgr.logInfo(new CallerInfo(){}, "Import limit (" + this.endRow + ") for table " + this.targetTable + " reached. Stopping import");
        String string = ResourceMgr.getFormattedString("MsgPartialImportEnded", Long.toString(this.endRow));
        this.messages.append(string);
        this.messages.appendNewLine();
        this.source.stop();
    }

    @Override
    public void processFile(StreamImporter streamImporter) throws SQLException, IOException {
        if (streamImporter != null) {
            try {
                this.insertedRows += streamImporter.processStreamData();
                this.tableImportFinished();
            }
            catch (SQLException sQLException) {
                this.hasErrors = true;
                this.tableImportError();
                LogMgr.logError(new CallerInfo(){}, "Error during import:\n" + ExceptionUtil.getDisplay(sQLException), null);
                this.addError(sQLException.getLocalizedMessage() + "\n");
            }
        }
    }

    private boolean shouldCommitRow(long l) {
        if (!this.transactionControl) {
            return false;
        }
        if (this.commitEvery <= 0) {
            return false;
        }
        if (this.commitBatch) {
            return false;
        }
        if (this.dbConn.getAutoCommit()) {
            return false;
        }
        return l % (long)this.commitEvery == 0L;
    }

    @Override
    public void processRow(Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return;
        }
        if (objectArray.length != this.getColCount()) {
            throw new SQLException("Invalid row data received. Size of row array does not match column count");
        }
        CallerInfo callerInfo = new CallerInfo(){};
        ++this.currentImportRow;
        if (this.currentImportRow < this.startRow) {
            return;
        }
        if (this.currentImportRow >= this.endRow) {
            this.endRowReached();
        }
        if (this.progressMonitor != null && this.reportInterval > 0 && (this.currentImportRow == 1L || this.currentImportRow % (long)this.reportInterval == 0L)) {
            if (this.totalTables > 0) {
                StringBuilder stringBuilder = new StringBuilder(this.targetTable.getTableName().length() + 20);
                stringBuilder.append(this.targetTable.getTableName());
                stringBuilder.append(" [");
                stringBuilder.append(this.currentTable);
                stringBuilder.append('/');
                stringBuilder.append(this.totalTables);
                stringBuilder.append(']');
                this.progressMonitor.setCurrentObject(stringBuilder.toString(), this.currentImportRow, -1L);
            } else {
                this.progressMonitor.setCurrentObject(this.targetTable.getTableName(), this.currentImportRow, -1L);
            }
        }
        long l = 0L;
        try {
            switch (this.mode) {
                case insert: 
                case upsert: 
                case insertIgnore: {
                    l = this.insertRow(objectArray, this.useSavepoint && this.continueOnError);
                    break;
                }
                case insertUpdate: {
                    boolean bl = false;
                    try {
                        l = this.insertRow(objectArray, this.useSavepoint);
                        bl = l > 0L;
                    }
                    catch (SQLException sQLException) {
                        if (this.shouldIgnoreInsertError(sQLException)) {
                            bl = false;
                        }
                        throw sQLException;
                    }
                    catch (Exception exception) {
                        LogMgr.logDebug(callerInfo, "Unexpected error when inserting row in insert/update mode", exception);
                        throw new SQLException("Error during insert", exception);
                    }
                    if (bl || this.updateStatement == null) break;
                    l = this.updateRow(objectArray, this.useSavepoint && this.continueOnError);
                    break;
                }
                case updateInsert: {
                    if (this.updateStatement == null) {
                        l = this.insertRow(objectArray, this.useSavepoint && this.continueOnError);
                        break;
                    }
                    l = this.updateRow(objectArray, this.useSavepoint && this.continueOnError);
                    if (l > 0L) break;
                    l = this.insertRow(objectArray, this.useSavepoint && this.continueOnError);
                    break;
                }
                case update: {
                    l = this.updateRow(objectArray, this.useSavepoint && this.continueOnError);
                }
            }
            this.totalRows += l;
            if (this.shouldCommitRow(this.totalRows)) {
                LogMgr.logInfo(callerInfo, "Commit threshold (" + this.commitEvery + ") reached at " + this.totalRows + " rows. Committing changes.");
                this.dbConn.commit();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.hasErrors = true;
            this.closeStatements();
            this.messages.clear();
            System.gc();
            this.messages.append(ResourceMgr.getString("MsgOutOfMemoryGeneric"));
            this.messages.appendNewLine();
            if (this.batchSize > 0) {
                LogMgr.logError(callerInfo, "Not enough memory to hold statement batch! Use the -batchSize parameter to reduce the batch size!", null);
                this.messages.append(ResourceMgr.getString("MsgOutOfMemoryJdbcBatch"));
                this.messages.appendNewLine();
                this.messages.appendNewLine();
            } else {
                LogMgr.logError(callerInfo, "Not enough memory to run this import!", null);
            }
            throw new SQLException("Not enough memory!");
        }
        catch (SQLException sQLException) {
            boolean bl = LogMgr.isDebugEnabled();
            LogMgr.logError(callerInfo, "Error importing row " + this.currentImportRow + ": " + ExceptionUtil.getDisplay(sQLException), bl ? sQLException : null);
            String string = this.source.getLastRecord();
            if (string == null) {
                ValueDisplay valueDisplay = new ValueDisplay(objectArray);
                string = valueDisplay.toString();
            }
            this.recordRejected(string, this.currentImportRow, sQLException);
            if (this.continueOnError) {
                this.hasWarnings = true;
            }
            this.hasErrors = true;
            throw sQLException;
        }
        if (this.currentImportRow % 100L == 0L && MemoryWatcher.isMemoryLow(false)) {
            this.hasErrors = true;
            this.closeStatements();
            this.messages.clear();
            this.messages.append(ResourceMgr.getString("MsgLowMemoryError"));
            this.messages.appendNewLine();
            throw new SQLException("Not enough memory!");
        }
    }

    private boolean shouldIgnoreInsertError(SQLException sQLException) {
        String string = this.dbConn.getDbSettings().getUniqueKeyViolationErrorState();
        int n = this.dbConn.getDbSettings().getUniqueKeyViolationErrorCode();
        if (string != null) {
            return string.equals(sQLException.getSQLState());
        }
        if (n > 0) {
            return sQLException.getErrorCode() == n;
        }
        return true;
    }

    private void setUpdateSavepoint() {
        try {
            this.updateSavepoint = this.dbConn.getSqlConnection().setSavepoint();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not create pre-update Savepoint", exception);
        }
    }

    private void setInsertSavepoint() {
        try {
            this.insertSavepoint = this.dbConn.getSqlConnection().setSavepoint();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not set pre-insert Savepoint", exception);
        }
    }

    private void rollbackUpdate() {
        this.rollbackToSavepoint(this.updateSavepoint);
        this.updateSavepoint = null;
    }

    private void rollbackInsert() {
        this.rollbackToSavepoint(this.insertSavepoint);
        this.insertSavepoint = null;
    }

    private void rollbackToSavepoint(Savepoint savepoint) {
        if (savepoint == null) {
            return;
        }
        try {
            this.dbConn.getSqlConnection().rollback(savepoint);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when performing rollback to savepoint", exception);
        }
    }

    private void releaseInsertSavepoint() {
        this.releaseSavepoint(this.insertSavepoint);
        this.insertSavepoint = null;
    }

    private void releaseUpdateSavepoint() {
        this.releaseSavepoint(this.updateSavepoint);
        this.updateSavepoint = null;
    }

    private void releaseSavepoint(Savepoint savepoint) {
        if (savepoint == null) {
            return;
        }
        try {
            this.dbConn.getSqlConnection().releaseSavepoint(savepoint);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when releasing savepoint", throwable);
        }
    }

    private long insertRow(Object[] objectArray, boolean bl) throws SQLException {
        try {
            if (bl) {
                this.setInsertSavepoint();
            }
            long l = this.processRowData(this.insertStatement, objectArray, false);
            this.insertedRows += l;
            this.releaseInsertSavepoint();
            return l;
        }
        catch (SQLException sQLException) {
            if (bl) {
                this.rollbackInsert();
            }
            throw sQLException;
        }
    }

    private long updateRow(Object[] objectArray, boolean bl) throws SQLException {
        try {
            if (bl) {
                this.setUpdateSavepoint();
            }
            long l = this.processRowData(this.updateStatement, objectArray, true);
            this.updatedRows += l;
            this.releaseUpdateSavepoint();
            return l;
        }
        catch (SQLException sQLException) {
            if (bl) {
                this.rollbackUpdate();
            }
            throw sQLException;
        }
    }

    private long processRowData(BatchedStatement batchedStatement, Object[] objectArray, boolean bl) throws SQLException {
        Object object;
        Object object2;
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            ColumnIdentifier columnIdentifier = this.targetColumns.get(n2);
            if (this.ignoreColumn(columnIdentifier)) continue;
            ++n3;
            if (bl) {
                n3 = this.columnMap[n2] + 1;
            }
            n = this.columnExpressions.containsKey(columnIdentifier.getColumnName());
            int n4 = columnIdentifier.getDataType();
            object2 = columnIdentifier.getDbmsType();
            object = objectArray[n2];
            try {
                if (object == null) {
                    if (this.useSetNull) {
                        batchedStatement.setNull(n3, this.mapJdbcType(n4));
                        continue;
                    }
                    batchedStatement.setObject(n3, null);
                    continue;
                }
                if (n == 0 && SqlUtil.isClobType(n4, (String)object2, this.dbConn.getDbSettings()) || SqlUtil.isXMLType(n4, (String)object2)) {
                    this.handleClobValue(batchedStatement, n3, object);
                    continue;
                }
                if (n == 0 && SqlUtil.isBlobType(n4) || "BLOB".equals(object2)) {
                    this.handleBlobValue(batchedStatement, n3, object, (String)object2);
                    continue;
                }
                if (n == 0 && this.arrayHandler != null && n4 == 2003) {
                    this.arrayHandler.setValue(batchedStatement, n3, object, columnIdentifier);
                    continue;
                }
                if (this.isOracle && n4 == 91 && object instanceof Date) {
                    Timestamp timestamp = new Timestamp(((Date)object).getTime());
                    batchedStatement.setTimestamp(n3, timestamp);
                    continue;
                }
                if (n4 == 2014 && this.tzHandler != null) {
                    object = this.tzHandler.convertTimestampTZ(object);
                }
                if (n == 0 && this.useJdbcType(n4)) {
                    batchedStatement.setObject(n3, object, this.mapJdbcType(n4));
                    continue;
                }
                batchedStatement.setObject(n3, object);
                continue;
            }
            catch (SQLException sQLException) {
                String string = String.format("Could not set %s value for column=%s, type=%s, index=%d. Error: %s", object == null ? "null" : "\"" + object.getClass().getSimpleName() + "\"", columnIdentifier.getColumnName(), object2, n3, sQLException.getMessage());
                LogMgr.logError(new CallerInfo(){}, string, null);
                throw sQLException;
            }
        }
        if (this.columnConstants != null && batchedStatement == this.insertStatement) {
            n2 = this.columnConstants.getColumnCount();
            int n5 = objectArray.length + 1;
            for (n = 0; n < n2; ++n) {
                if (this.columnConstants.isSelectStatement(n)) {
                    ValueStatement valueStatement = this.columnConstants.getStatement(n);
                    object2 = this.source.getInputColumnValues(valueStatement.getInputColumnIndexes());
                    object = valueStatement.getDatabaseValue(this.dbConn, (Map<Integer, Object>)object2);
                    batchedStatement.getStatement().setObject(n5, object);
                    ++n5;
                    continue;
                }
                if (this.columnConstants.isLineNumber(n)) {
                    batchedStatement.getStatement().setLong(n5, this.currentImportRow);
                    continue;
                }
                if (this.columnConstants.isFunctionCall(n)) continue;
                this.columnConstants.setParameter(batchedStatement.getStatement(), n5, n);
                ++n5;
            }
        }
        long l = batchedStatement.executeUpdate();
        return l;
    }

    private void handleBlobValue(BatchedStatement batchedStatement, int n, Object object, String string) throws SQLException {
        InputStream inputStream = null;
        int n2 = -1;
        if (object instanceof File) {
            ImportFileHandler importFileHandler = this.parser != null ? this.parser.getFileHandler() : null;
            File file = (File)object;
            try {
                if (importFileHandler != null) {
                    inputStream = new BufferedInputStream(importFileHandler.getAttachedFileStream(file));
                    n2 = (int)importFileHandler.getLength(file);
                }
                if (!file.isAbsolute()) {
                    File file2 = new File(this.parser.getSourceFilename());
                    file = new File(file2.getParentFile(), file.getName());
                }
                inputStream = new BufferedInputStream(new FileInputStream(file), 65536);
                n2 = (int)file.length();
            }
            catch (IOException iOException) {
                this.hasErrors = true;
                String string2 = ResourceMgr.getFormattedString("ErrFileNotAccessible", file.getAbsolutePath(), iOException.getMessage());
                this.messages.append(string2);
                throw new SQLException(iOException.getMessage());
            }
        } else if (object instanceof UUID && this.blobDecoder != null && string.startsWith("RAW")) {
            UUID uUID = (UUID)object;
            String string3 = uUID.toString();
            try {
                byte[] byArray = this.blobDecoder.decodeString(string3, BlobLiteralType.uuid);
                batchedStatement.setBytes(n, byArray);
                return;
            }
            catch (IOException iOException) {}
        } else if (object instanceof Blob) {
            Blob blob = (Blob)object;
            if (this.useSetBlob) {
                batchedStatement.setBlob(n, blob);
                return;
            }
            if (this.useSetBytes) {
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                batchedStatement.setBytes(n, byArray);
                return;
            }
            inputStream = blob.getBinaryStream();
            n2 = (int)blob.length();
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (this.useSetBlob) {
                Blob blob = this.dbConn.getSqlConnection().createBlob();
                blob.setBytes(1L, byArray);
                batchedStatement.setBlob(n, blob);
                return;
            }
            if (this.useSetBytes) {
                batchedStatement.setBytes(n, byArray);
                return;
            }
            inputStream = new ByteArrayInputStream(byArray);
            n2 = byArray.length;
        }
        if (inputStream != null && n2 > -1) {
            batchedStatement.setBinaryStream(n, inputStream, n2);
        } else {
            batchedStatement.setNull(n, 2004);
            this.messages.append(ResourceMgr.getFormattedString("MsgBlobNotRead", n));
            this.messages.appendNewLine();
        }
    }

    private void handleClobValue(BatchedStatement batchedStatement, int n, Object object) throws SQLException {
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            if (this.useSetClob) {
                batchedStatement.setClob(n, clob);
            } else {
                Reader reader = clob.getCharacterStream();
                batchedStatement.setCharacterStream(n, reader, (int)clob.length());
            }
        } else if (object instanceof File) {
            String string;
            int n2 = -1;
            ImportFileHandler importFileHandler = this.parser != null ? this.parser.getFileHandler() : null;
            String string2 = string = importFileHandler != null ? importFileHandler.getEncoding() : null;
            if (string == null) {
                string = this.parser != null ? this.parser.getEncoding() : Settings.getInstance().getDefaultDataEncoding();
            }
            Reader reader = null;
            File file = (File)object;
            try {
                if (importFileHandler != null) {
                    reader = EncodingUtil.createReader(importFileHandler.getAttachedFileStream(file), string);
                    n2 = this.checkRealClobLength ? (int)importFileHandler.getCharacterLength(file) : (int)importFileHandler.getLength(file);
                } else {
                    if (!file.isAbsolute()) {
                        File file2 = new File(this.parser.getSourceFilename());
                        file = new File(file2.getParentFile(), file.getName());
                    }
                    reader = EncodingUtil.createBufferedReader(file, string);
                    n2 = this.checkRealClobLength ? (int)FileUtil.getCharacterLength(file, string) : (int)file.length();
                }
                batchedStatement.setCharacterStream(n, reader, n2);
            }
            catch (IOException iOException) {
                this.hasErrors = true;
                String string3 = ResourceMgr.getFormattedString("ErrFileNotAccessible", file.getAbsolutePath(), iOException.getMessage());
                this.messages.append(string3);
                throw new SQLException(iOException.getMessage());
            }
        } else if (this.useSetClob) {
            Clob clob = this.dbConn.getSqlConnection().createClob();
            clob.setString(1L, object.toString());
            batchedStatement.setClob(n, clob);
        } else if (this.useSetStringForClobs) {
            batchedStatement.setString(n, object.toString());
        } else {
            batchedStatement.setObject(n, object);
        }
    }

    private int mapJdbcType(int n) {
        return this.typeMapping.getOrDefault(n, n);
    }

    private boolean useJdbcType(int n) {
        switch (this.useSetObjectWithType) {
            case Never: {
                return false;
            }
            case Always: {
                return true;
            }
            case KnownTypes: {
                return n != 1111;
            }
        }
        return false;
    }

    private void checkConstantValues(File file) throws SQLException {
        if (this.columnConstants == null) {
            return;
        }
        try {
            this.columnConstants.initFileVariables(this.targetTable, this.dbConn, file);
        }
        catch (ConverterException converterException) {
            throw new SQLException("Could not convert constant values", converterException);
        }
        for (ColumnIdentifier columnIdentifier : this.targetColumns) {
            if (!this.columnConstants.removeColumn(columnIdentifier)) continue;
            String string = ResourceMgr.getFormattedString("MsgImporterConstIgnored", columnIdentifier.getColumnName());
            this.messages.append(string);
            this.messages.appendNewLine();
            if (this.continueOnError) {
                LogMgr.logWarning(new CallerInfo(){}, string);
                continue;
            }
            throw new SQLException(string);
        }
    }

    @Override
    public void tableImportFinished() throws SQLException {
        block3: {
            if (this.targetTable != null) {
                try {
                    this.finishTable();
                    this.targetTable = null;
                }
                catch (SQLException sQLException) {
                    if (this.continueOnError) break block3;
                    this.targetTable = null;
                    this.hasErrors = true;
                    throw sQLException;
                }
            }
        }
    }

    public void skipTargetCheck(boolean bl) {
        this.verifyTargetTable = !bl;
    }

    @Override
    public void setTargetTable(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, File file) throws SQLException {
        block24: {
            if (this.isRunning && this.targetTable != null) {
                try {
                    this.finishTable();
                }
                catch (SQLException sQLException) {
                    if (this.continueOnError) break block24;
                    this.hasErrors = true;
                    throw sQLException;
                }
            }
        }
        this.currentImportRow = 0L;
        this.updatedRows = 0L;
        this.insertedRows = 0L;
        this.errorCount = 0;
        this.errorLimitAdded = false;
        CallerInfo callerInfo = new CallerInfo(){};
        this.targetTable = tableIdentifier.createCopy();
        String string = this.targetTable.getTableExpression(this.dbConn);
        try {
            block25: {
                this.targetColumns = new ArrayList<ColumnIdentifier>(list);
                if (this.multiTable) {
                    this.keyColumns = null;
                }
                String string2 = null;
                string2 = this.parser != null ? ResourceMgr.getFormattedString("MsgImportingFile", this.parser.getSourceFilename(), string) : ResourceMgr.getFormattedString("MsgImportingTableData", string);
                this.messages.append(string2);
                this.messages.appendNewLine();
                if (this.createTarget) {
                    try {
                        this.createTarget();
                    }
                    catch (SQLException sQLException) {
                        String string3 = ResourceMgr.getFormattedString("ErrImportTableNotCreated", string, ExceptionUtil.getDisplay(sQLException));
                        this.messages.append(string3);
                        this.messages.appendNewLine();
                        LogMgr.logError(callerInfo, "Could not create target: " + string, sQLException);
                        this.hasErrors = true;
                        throw sQLException;
                    }
                }
                if (this.verifyTargetTable) {
                    try {
                        this.checkTable();
                    }
                    catch (SQLException sQLException) {
                        this.messages.append(ResourceMgr.getFormattedString("ErrTargetTableNotFound", string));
                        if (this.parser != null) {
                            this.messages.appendNewLine();
                            this.messages.append(ResourceMgr.getFormattedString("ErrImportFileNotProcessed", this.parser.getSourceFilename()));
                        }
                        this.hasErrors = true;
                        this.messages.appendNewLine();
                        this.targetTable = null;
                        throw sQLException;
                    }
                }
                this.checkConstantValues(file);
                this.currentImportRow = 0L;
                this.totalRows = 0L;
                if (this.mode != ImportMode.update) {
                    this.prepareInsertStatement();
                }
                if (this.mode == ImportMode.update || this.mode == ImportMode.insertUpdate || this.mode == ImportMode.updateInsert) {
                    this.prepareUpdateStatement();
                }
                if (this.deleteTarget != DeleteType.none && this.tablesToBeProcessed == null) {
                    if (this.progressMonitor != null) {
                        this.progressMonitor.saveCurrentType("importDelete");
                        this.progressMonitor.setMonitorType(7);
                        String string4 = ResourceMgr.getFormattedString("TxtDeletingTable", string);
                        this.progressMonitor.setCurrentObject(string4, -1L, -1L);
                    }
                    try {
                        this.deleteTarget();
                    }
                    catch (SQLException sQLException) {
                        this.hasErrors = true;
                        String string5 = ResourceMgr.getString("ErrDeleteTableData");
                        string5 = string5.replace("%table%", string);
                        string5 = string5.replace("%error%", ExceptionUtil.getDisplay(sQLException));
                        this.messages.append(string5);
                        this.messages.appendNewLine();
                        LogMgr.logError(callerInfo, "Could not delete contents of table " + string, sQLException);
                        if (this.continueOnError) break block25;
                        throw sQLException;
                    }
                }
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.restoreType("importDelete");
            }
            if (this.reportInterval == 0 && this.progressMonitor != null) {
                this.progressMonitor.setMonitorType(7);
                this.progressMonitor.setCurrentObject(ResourceMgr.getFormattedString("MsgImportingTableData", string + " (" + this.getModeString() + ")"), -1L, -1L);
            }
            if (LogMgr.isInfoEnabled()) {
                LogMgr.logInfo(callerInfo, "Starting import for table " + string);
            }
            this.badWriter = this.badfileName != null ? new BadfileWriter(this.badfileName, this.targetTable, "UTF8") : null;
            this.runPreTableStatement();
        }
        catch (Exception exception) {
            String string6 = "Error initializing import for table " + string;
            if (this.continueOnError) {
                this.hasWarnings = true;
            } else {
                this.hasErrors = true;
            }
            LogMgr.logError(callerInfo, string6, exception);
            throw exception;
        }
    }

    private void runPreTableStatement() throws SQLException {
        try {
            if (this.tableStatements != null) {
                this.tableStatements.runPreTableStatement(this.dbConn, this.targetTable);
            }
        }
        catch (TableStatementError tableStatementError) {
            String string = ResourceMgr.getFormattedString("ErrTableStmt", tableStatementError.getTable(), tableStatementError.getMessage());
            this.messages.append(string);
            this.messages.appendNewLine();
            throw tableStatementError;
        }
    }

    private void runPostTableStatement() throws SQLException {
        try {
            if (this.tableStatements != null && this.tableStatements.wasSuccess()) {
                this.tableStatements.runPostTableStatement(this.dbConn, this.targetTable);
            }
        }
        catch (TableStatementError tableStatementError) {
            String string = ResourceMgr.getFormattedString("ErrTableStmt", tableStatementError.getTable(), tableStatementError.getMessage());
            this.messages.append(string);
            this.messages.appendNewLine();
            throw tableStatementError;
        }
    }

    private String getModeString() {
        if (this.mode == null) {
            return "";
        }
        switch (this.mode) {
            case insert: {
                return "insert";
            }
            case insertIgnore: {
                return "insertIgnore";
            }
            case insertUpdate: {
                return "insert/update";
            }
            case updateInsert: {
                return "update/insert";
            }
            case upsert: {
                return "upsert";
            }
            case update: {
                return "update";
            }
        }
        return "";
    }

    private void checkTable() throws SQLException {
        if (this.dbConn == null) {
            return;
        }
        if (this.targetTable == null) {
            return;
        }
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.dbConn);
        DbMetadata dbMetadata = this.dbConn.getMetadata();
        boolean bl = dbObjectFinder.objectExists(this.targetTable, dbMetadata.getTablesAndViewTypes());
        if (!bl) {
            throw new SQLException("Table " + this.targetTable.getTableExpression(this.dbConn) + " not found!");
        }
    }

    private void checkBatchMode() {
        if (this.useBatch) {
            if (!this.supportsBatch()) {
                LogMgr.logWarning(new CallerInfo(){}, "JDBC driver does not support batch updates. Ignoring request to use batch updates");
                this.messages.append(ResourceMgr.getString("MsgJDBCDriverNoBatch") + "\n");
                this.useBatch = false;
            } else if (this.isModeInsertUpdate() || this.isModeUpdateInsert()) {
                this.useBatch = false;
                this.messages.appendMessageKey("ErrImportNoBatchMode");
                this.messages.appendNewLine();
            }
        }
    }

    private void prepareInsertStatement() throws SQLException {
        boolean bl = !this.verifyTargetTable;
        ImportDMLStatementBuilder importDMLStatementBuilder = new ImportDMLStatementBuilder(this.dbConn, this.targetTable, this.targetColumns, this, bl);
        importDMLStatementBuilder.setColumnExpressions(this.columnExpressions);
        importDMLStatementBuilder.setOverrideStrategy(this.overrideIdentity);
        if (this.mode != ImportMode.insert) {
            this.verifyKeyColumns();
            importDMLStatementBuilder.setKeyColumns(this.keyColumns);
        }
        String string = null;
        if (this.mode == ImportMode.upsert && importDMLStatementBuilder.isModeSupported(this.mode)) {
            string = importDMLStatementBuilder.createUpsertStatement(this.columnConstants, this.insertSqlStart);
        } else if (this.mode == ImportMode.insertIgnore && importDMLStatementBuilder.isModeSupported(this.mode)) {
            string = importDMLStatementBuilder.createInsertIgnore(this.columnConstants, this.insertSqlStart);
        } else if (this.mode == ImportMode.insertUpdate && importDMLStatementBuilder.hasNativeInsertIgnore()) {
            string = importDMLStatementBuilder.createInsertIgnore(this.columnConstants, this.insertSqlStart);
        }
        CallerInfo callerInfo = new CallerInfo(){};
        if (string == null) {
            if (this.mode == ImportMode.upsert) {
                this.mode = ImportMode.insertUpdate;
                LogMgr.logInfo(callerInfo, "Database does not support native UPSERT. Reverting to insert/update.");
            }
            string = importDMLStatementBuilder.createInsertStatement(this.columnConstants, this.insertSqlStart);
        }
        this.checkBatchMode();
        try {
            PreparedStatement preparedStatement = this.dbConn.getSqlConnection().prepareStatement(string);
            this.insertStatement = new BatchedStatement(preparedStatement, this.dbConn, this.getRealBatchSize());
            this.insertStatement.setCommitBatch(this.commitBatch);
            LogMgr.logInfo(callerInfo, "Statement for insert: " + string);
        }
        catch (Exception exception) {
            LogMgr.logError(callerInfo, "Error when preparing INSERT statement: " + string, exception);
            this.messages.append(ResourceMgr.getString("ErrImportInitTargetFailed"));
            this.messages.append(ExceptionUtil.getDisplay(exception));
            this.insertStatement = null;
            this.hasErrors = true;
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new SQLException("Could not prepare instert statement", exception);
        }
    }

    private void verifyKeyColumns() throws SQLException {
        if (this.hasKeyColumns()) {
            return;
        }
        this.retrieveKeyColumns();
        if (!this.hasKeyColumns()) {
            if (this.messages.getLength() > 0) {
                this.messages.appendNewLine();
            }
            this.messages.append(ResourceMgr.getFormattedString("ErrImportNoKeyForUpdate", this.targetTable.getTableExpression()));
            throw new SQLException("No key columns defined for update mode");
        }
    }

    private void prepareUpdateStatement() throws SQLException, ModeNotPossibleException {
        int n;
        this.verifyKeyColumns();
        DbMetadata dbMetadata = this.dbConn.getMetadata();
        DmlExpressionBuilder dmlExpressionBuilder = DmlExpressionBuilder.Factory.getBuilder(this.dbConn);
        this.columnMap = new int[this.getColCount()];
        int n2 = this.getColCount() - this.keyColumns.size();
        int n3 = 0;
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder(this.getColCount() * 20 + 80);
        StringBuilder stringBuilder2 = new StringBuilder(this.keyColumns.size() * 10);
        stringBuilder.append("UPDATE ");
        stringBuilder.append(this.targetTable.getFullyQualifiedName(this.dbConn));
        stringBuilder.append(" SET ");
        stringBuilder2.append(" WHERE ");
        boolean bl = false;
        boolean bl2 = false;
        if (this.columnConstants != null && this.columnConstants.getColumnCount() > 0) {
            String string;
            ColumnData columnData;
            SqlLiteralFormatter sqlLiteralFormatter = new SqlLiteralFormatter(this.dbConn);
            for (ColumnIdentifier columnIdentifier : this.keyColumns) {
                columnData = this.columnConstants.getColumnData(columnIdentifier.getColumnName());
                if (columnData == null) continue;
                string = dbMetadata.quoteObjectname(columnData.getIdentifier().getColumnName());
                if (bl) {
                    stringBuilder2.append(" AND ");
                } else {
                    bl = true;
                }
                stringBuilder2.append(string);
                stringBuilder2.append(" = ");
                stringBuilder2.append(sqlLiteralFormatter.getDefaultLiteral(columnData));
                columnData.getIdentifier().setIsPkColumn(true);
                ++n3;
                ++n2;
            }
            int n5 = this.columnConstants.getColumnCount();
            for (int i = 0; i < n5; ++i) {
                columnData = this.columnConstants.getColumnData(i);
                if (columnData.getIdentifier().isPkColumn()) continue;
                if (bl2) {
                    stringBuilder.append(", ");
                } else {
                    bl2 = true;
                }
                string = dbMetadata.quoteObjectname(columnData.getIdentifier().getColumnName());
                stringBuilder.append(string);
                stringBuilder.append(" = ");
                String string2 = this.columnExpressions.get(columnData.getIdentifier().getColumnName());
                if (StringUtil.isNonBlank(string2)) {
                    stringBuilder.append(string2);
                    continue;
                }
                if (this.columnConstants.isFunctionCall(i)) {
                    stringBuilder.append(this.columnConstants.getFunctionLiteral(i));
                    continue;
                }
                stringBuilder.append(sqlLiteralFormatter.getDefaultLiteral(columnData));
            }
        }
        for (n = 0; n < this.getColCount(); ++n) {
            ColumnIdentifier columnIdentifier = this.targetColumns.get(n);
            if (this.ignoreColumn(columnIdentifier)) continue;
            String string = columnIdentifier.getDisplayName();
            if (!this.verifyTargetTable) {
                string = dbMetadata.adjustObjectnameCase(dbMetadata.removeQuotes(string));
            }
            string = dbMetadata.quoteObjectname(string);
            if (this.keyColumns.contains(columnIdentifier)) {
                this.columnMap[n] = n2;
                if (bl) {
                    stringBuilder2.append(" AND ");
                } else {
                    bl = true;
                }
                stringBuilder2.append(string);
                stringBuilder2.append(" = ");
                stringBuilder2.append(dmlExpressionBuilder.getDmlExpression(columnIdentifier, DmlExpressionType.Import));
                ++n2;
                ++n3;
                continue;
            }
            this.columnMap[n] = n4;
            if (bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = true;
            }
            stringBuilder.append(string);
            stringBuilder.append(" = ");
            stringBuilder.append(dmlExpressionBuilder.getDmlExpression(columnIdentifier, DmlExpressionType.Import));
            ++n4;
        }
        if (!bl) {
            LogMgr.logError(new CallerInfo(){}, "No primary key columns defined! Update mode not available\n", null);
            this.messages.append(ResourceMgr.getString("ErrImportNoKeyForUpdate"));
            this.messages.appendNewLine();
            this.updateStatement = null;
            this.hasErrors = true;
            throw new SQLException("No key columns defined for update mode");
        }
        if (n3 != this.keyColumns.size()) {
            LogMgr.logError(new CallerInfo(){}, "At least one of the supplied primary key columns was not found in the target table!", null);
            this.messages.append(ResourceMgr.getString("ErrImportUpdateKeyColumnNotFound") + "\n");
            this.updateStatement = null;
            this.hasErrors = true;
            throw new SQLException("Not enough key columns defined for update mode");
        }
        if (n4 == 0) {
            LogMgr.logError(new CallerInfo(){}, "Only PK columns defined! Update mode is not available!", null);
            this.messages.append(ResourceMgr.getString("ErrImportOnlyKeyColumnsForUpdate"));
            this.messages.appendNewLine();
            this.updateStatement = null;
            if (this.isModeUpdate()) {
                this.hasErrors = true;
                throw new ModeNotPossibleException("Only key columns available. No update mode possible");
            }
            this.hasWarnings = true;
            return;
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        if (StringUtil.isNonEmpty(this.whereClauseForUpdate)) {
            n = 0;
            String string = this.whereClauseForUpdate.trim().toUpperCase();
            if (!string.startsWith("AND") && !string.startsWith("OR")) {
                stringBuilder.append(" AND (");
                n = 1;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.whereClauseForUpdate.trim());
            if (n != 0) {
                stringBuilder.append(")");
            }
        }
        String string = stringBuilder.toString();
        try {
            LogMgr.logInfo(new CallerInfo(){}, "Statement for update: " + string);
            PreparedStatement preparedStatement = this.dbConn.getSqlConnection().prepareStatement(string);
            this.updateStatement = new BatchedStatement(preparedStatement, this.dbConn, this.getRealBatchSize());
            this.updateStatement.setCommitBatch(this.commitBatch);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when preparing UPDATE statement", exception);
            this.messages.append(ResourceMgr.getString("ErrImportInitTargetFailed"));
            this.messages.append(ExceptionUtil.getDisplay(exception));
            this.updateStatement = null;
            this.hasErrors = true;
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new SQLException("Could not prepare instert statement", exception);
        }
    }

    private void retrieveKeyColumns() {
        try {
            List<ColumnIdentifier> list = this.dbConn.getMetadata().getTableColumns(this.targetTable);
            PkDefinition pkDefinition = this.dbConn.getMetadata().getIndexReader().getPrimaryKey(this.targetTable);
            this.keyColumns = new ArrayList<ColumnIdentifier>();
            for (String string : pkDefinition.getColumns()) {
                ColumnIdentifier columnIdentifier = ColumnIdentifier.findColumnInList(list, string);
                this.keyColumns.add(columnIdentifier);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when retrieving key columns", exception);
            this.columnMap = null;
            this.keyColumns = null;
        }
    }

    private void finishTable() throws SQLException {
        if (this.targetTable == null) {
            return;
        }
        boolean bl = this.transactionControl && !this.dbConn.getAutoCommit() && this.commitEvery != Integer.MIN_VALUE;
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            SequenceAdjuster sequenceAdjuster;
            if (this.useBatch) {
                if (this.insertStatement != null) {
                    this.insertedRows += this.insertStatement.flush();
                }
                if (this.updateStatement != null) {
                    this.updatedRows += this.updateStatement.flush();
                }
                if (this.commitBatch) {
                    bl = false;
                }
            }
            this.closeStatements();
            this.runPostTableStatement();
            String string = this.targetTable.getTableName() + ": " + this.getInsertedRows() + " row(s) inserted. " + this.getUpdatedRows() + " row(s) updated.";
            string = !this.transactionControl ? string + " Transaction control disabled. No commit sent to server." : string + " Committing changes.";
            if (bl) {
                this.dbConn.commit();
            }
            if (this.adjustSequences && (sequenceAdjuster = SequenceAdjuster.Factory.getSequenceAdjuster(this.dbConn)) != null) {
                int n = sequenceAdjuster.adjustTableSequences(this.dbConn, this.targetTable, this.transactionControl);
                LogMgr.logInfo(callerInfo, "Adjusted " + n + " sequence(s) for table " + this.targetTable.getTableExpression(this.dbConn));
            }
            LogMgr.logInfo(callerInfo, string);
            if (this.insertedRows > -1L || this.updatedRows > -1L) {
                this.messages.appendNewLine();
            }
            if (this.insertedRows > -1L) {
                this.messages.append(this.insertedRows + " " + ResourceMgr.getString("MsgCopyNumRowsInserted"));
                this.messages.appendNewLine();
            }
            if (this.updatedRows > -1L) {
                this.messages.append(this.updatedRows + " " + ResourceMgr.getString("MsgCopyNumRowsUpdated"));
            }
            if (this.badWriter != null && this.badWriter.getRows() > 0) {
                this.messages.appendNewLine();
                this.messages.append(this.badWriter.getMessage());
            }
            this.messages.appendNewLine();
            this.hasErrors = this.hasErrors || this.source.hasErrors();
            this.hasWarnings = this.hasWarnings || this.source.hasWarnings();
        }
        catch (SQLException sQLException) {
            if (bl) {
                this.dbConn.rollbackSilently();
            }
            LogMgr.logError(callerInfo, "Error commiting changes", sQLException);
            this.hasErrors = true;
            this.messages.append(ExceptionUtil.getDisplay(sQLException));
            this.messages.appendNewLine();
            throw sQLException;
        }
    }

    public CharSequence getMessages() {
        return this.messages.getBuffer();
    }

    public void copyMessages(MessageBuffer messageBuffer) {
        messageBuffer.append(this.messages);
        this.clearMessages();
    }

    public void clearMessages() {
        this.messages.clear();
    }

    @Override
    public void importFinished() {
        if (!this.isRunning) {
            return;
        }
        try {
            this.finishTable();
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error when commiting changes", exception);
            this.messages.append(ExceptionUtil.getDisplay(exception));
            this.hasErrors = true;
        }
        finally {
            this.isRunning = false;
            if (!this.multiTable && this.progressMonitor != null) {
                this.progressMonitor.jobFinished();
            }
        }
        this.hasErrors = this.hasErrors || this.source.hasErrors();
        this.hasWarnings = this.hasWarnings || this.source.hasWarnings();
    }

    private void cleanupRollback() {
        try {
            this.cancelStatement(this.insertStatement);
            this.cancelStatement(this.updateStatement);
            this.closeStatements();
            if (this.transactionControl && !this.dbConn.getAutoCommit()) {
                LogMgr.logInfo(new CallerInfo(){}, "Rollback changes");
                this.dbConn.rollback();
                this.updatedRows = 0L;
                this.insertedRows = 0L;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error on rollback", exception);
            this.messages.append(ExceptionUtil.getDisplay(exception));
            this.hasErrors = true;
        }
        this.isRunning = false;
        if (this.progressMonitor != null) {
            this.progressMonitor.jobFinished();
        }
    }

    @Override
    public void tableImportError() {
        this.cleanupRollback();
        if (this.tableStatements != null && this.tableStatements.getRunPostStatementAfterError() && this.targetTable != null) {
            try {
                this.tableStatements.runPostTableStatement(this.dbConn, this.targetTable);
            }
            catch (TableStatementError tableStatementError) {
                LogMgr.logWarning(new CallerInfo(){}, "Error running post-table statement", tableStatementError);
                String string = ResourceMgr.getFormattedString("ErrTableStmt", tableStatementError.getTable(), tableStatementError.getMessage());
                this.messages.append(string);
                this.messages.appendNewLine();
            }
            catch (Exception exception) {
                LogMgr.logWarning(new CallerInfo(){}, "Error running post-table statement", exception);
            }
        }
    }

    @Override
    public void importCancelled() {
        if (!this.isRunning) {
            return;
        }
        if (this.partialImportEnded) {
            this.importFinished();
            return;
        }
        this.cleanupRollback();
        this.hasErrors = this.hasErrors || this.source.hasErrors();
        this.hasWarnings = this.hasWarnings || this.source.hasWarnings();
    }

    private void closeStatements() {
        if (this.insertStatement != null) {
            try {
                this.insertStatement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.updateStatement != null) {
            try {
                this.updateStatement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.columnConstants != null) {
            this.columnConstants.done();
        }
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    @Override
    public void setReportInterval(int n) {
        this.reportInterval = n > 0 ? n : 0;
    }
}

