/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import workbench.db.importer.SpreadsheetReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.MessageBuffer;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class ExcelReader
implements SpreadsheetReader {
    private static final long ONE_DAY = 86400000L;
    private int sheetIndex = -1;
    private String sheetName;
    private final WbFile inputFile;
    private final List<String> sheetNames = new ArrayList<String>();
    private Workbook workbook;
    private Sheet dataSheet;
    private List<String> headerColumns;
    private String nullString;
    private List<CellRangeAddress> mergedRegions;
    private final Set<String> tsFormats = CollectionUtil.treeSet("HH", "mm", "ss", "SSS", "KK", "kk");
    private final boolean useXLSX;
    private MessageBuffer messages = new MessageBuffer();
    private boolean emptyStringIsNull;
    private boolean useStringDates;
    private DataFormatter dataFormatter = new DataFormatter(true);
    private boolean recalcOnLoad = true;
    private boolean useSAXReader;

    public ExcelReader(File file, int n, String string) {
        this.inputFile = new WbFile(file);
        this.sheetIndex = n > -1 ? n : -1;
        this.sheetName = this.sheetIndex < 0 && StringUtil.isNonBlank(string) ? string.trim() : null;
        this.useXLSX = this.inputFile.getExtension().equalsIgnoreCase("xlsx");
        this.useSAXReader = this.useXLSX && Settings.getInstance().getUseXLSXSaxReader();
    }

    @Override
    public void enableRecalcOnLoad(boolean bl) {
        this.recalcOnLoad = bl;
        if (this.recalcOnLoad && this.useSAXReader) {
            LogMgr.logDebug(new CallerInfo(){}, "Disabling streaming SAX reader to support recalculation of formulas.");
            this.useSAXReader = false;
        }
    }

    @Override
    public void setReturnDatesAsString(boolean bl) {
        this.useStringDates = bl;
    }

    @Override
    public void setEmptyStringIsNull(boolean bl) {
        this.emptyStringIsNull = bl;
    }

    @Override
    public MessageBuffer getMessages() {
        return this.messages;
    }

    @Override
    public List<String> getSheets() {
        if (this.useXLSX) {
            if (this.sheetNames.isEmpty()) {
                this.readSheetNamesFromIterator();
            }
        } else {
            this.readSheetNamesFromWorkbook();
        }
        return Collections.unmodifiableList(this.sheetNames);
    }

    private void readSheetNamesFromWorkbook() {
        if (this.workbook == null) {
            try {
                this.load();
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not load Excel file: " + this.inputFile.getFullPath(), exception);
            }
        }
        this.sheetNames.clear();
        int n = this.workbook.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            this.sheetNames.add(this.workbook.getSheetName(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSheetNamesFromIterator() {
        OPCPackage oPCPackage = null;
        try {
            this.sheetNames.clear();
            oPCPackage = OPCPackage.open((File)this.inputFile, (PackageAccess)PackageAccess.READ);
            XSSFReader xSSFReader = new XSSFReader(oPCPackage);
            XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xSSFReader.getSheetsData();
            while (sheetIterator.hasNext()) {
                sheetIterator.next();
                this.sheetNames.add(sheetIterator.getSheetName());
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not load Excel file", exception);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(oPCPackage);
                throw throwable;
            }
            FileUtil.closeQuietely((Closeable)oPCPackage);
        }
        FileUtil.closeQuietely((Closeable)oPCPackage);
    }

    private boolean shouldLoadSheet() {
        if (this.dataSheet != null) {
            if (this.sheetIndex > -1 && this.dataSheet.getSheetName().equals(this.sheetNames.get(this.sheetIndex))) {
                return false;
            }
            if (this.sheetName != null && this.sheetName.equals(this.dataSheet.getSheetName())) {
                return false;
            }
        }
        return this.sheetName != null || this.sheetIndex > -1;
    }

    @Override
    public void load() throws IOException {
        if (this.useSAXReader) {
            if (this.sheetNames.isEmpty()) {
                this.readSheetNamesFromIterator();
            }
            if (this.shouldLoadSheet()) {
                this.initActiveSheet();
            }
            return;
        }
        if (this.workbook != null) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.inputFile);
            this.workbook = this.useXLSX ? new XSSFWorkbook((InputStream)fileInputStream) : new HSSFWorkbook((InputStream)fileInputStream);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietely(fileInputStream);
            throw throwable;
        }
        FileUtil.closeQuietely(fileInputStream);
        this.initActiveSheet();
        try {
            if (this.recalcOnLoad) {
                if (this.useXLSX) {
                    XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)((XSSFWorkbook)this.workbook));
                } else {
                    HSSFFormulaEvaluator.evaluateAllFormulaCells((HSSFWorkbook)((HSSFWorkbook)this.workbook));
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not refresh formulas!", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSheet(final String string) {
        XSSFWorkbook xSSFWorkbook = null;
        try (FileInputStream fileInputStream = new FileInputStream(this.inputFile);){
            xSSFWorkbook = new XSSFWorkbook(fileInputStream){

                public void parseSheet(Map<String, XSSFSheet> map, CTSheet cTSheet) {
                    if (string.equals(cTSheet.getName())) {
                        super.parseSheet(map, cTSheet);
                    }
                }
            };
            this.dataSheet = xSSFWorkbook.getSheet(string);
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not load sheet " + string + " for file " + this.inputFile, exception);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(xSSFWorkbook);
                throw throwable;
            }
            FileUtil.closeQuietely((Closeable)xSSFWorkbook);
        }
        FileUtil.closeQuietely((Closeable)xSSFWorkbook);
    }

    private void initActiveSheet() {
        int n;
        if (this.useSAXReader) {
            if (this.sheetIndex > -1) {
                this.loadSheet(this.sheetNames.get(this.sheetIndex));
            } else {
                this.loadSheet(this.sheetName);
            }
        } else if (this.workbook != null) {
            if (this.sheetIndex > -1) {
                this.dataSheet = this.workbook.getSheetAt(this.sheetIndex);
                if (this.dataSheet == null) {
                    throw new IndexOutOfBoundsException("Sheet with index " + this.sheetIndex + " does not exist in file: " + this.inputFile.getFullPath());
                }
            } else if (this.sheetName != null) {
                this.dataSheet = this.workbook.getSheet(this.sheetName);
                if (this.dataSheet == null) {
                    throw new IllegalArgumentException("Sheet with name '" + this.sheetName + "' does not exist in file: " + this.inputFile.getFullPath());
                }
            } else {
                n = this.workbook.getActiveSheetIndex();
                this.dataSheet = this.workbook.getSheetAt(n);
            }
        }
        if (this.dataSheet != null) {
            this.headerColumns = null;
            n = this.dataSheet.getNumMergedRegions();
            this.mergedRegions = new ArrayList<CellRangeAddress>(n);
            for (int i = 0; i < n; ++i) {
                this.mergedRegions.add(this.dataSheet.getMergedRegion(i));
            }
        }
    }

    @Override
    public List<String> getHeaderColumns() {
        if (this.dataSheet == null) {
            this.initActiveSheet();
        }
        if (this.headerColumns == null) {
            int n;
            this.headerColumns = new ArrayList<String>();
            Row row = this.dataSheet.getRow(0);
            int n2 = n = row != null ? row.getLastCellNum() : 0;
            if (row == null || n == 0) {
                LogMgr.logError(new CallerInfo(){}, "Cannot retrieve column names because no data is available in the first row of the sheet: " + this.dataSheet.getSheetName(), null);
                String string = ResourceMgr.getFormattedString("ErrExportNoCols", this.dataSheet.getSheetName());
                this.messages.append(string);
                this.messages.appendNewLine();
                return this.headerColumns;
            }
            for (int i = 0; i < n; ++i) {
                Cell cell = row.getCell(i);
                Object object = this.getCellValue(cell);
                if (object != null) {
                    this.headerColumns.add(object.toString());
                    continue;
                }
                this.headerColumns.add("Col" + Integer.toString(i));
            }
        }
        return this.headerColumns;
    }

    @Override
    public void setActiveWorksheet(String string) {
        if (StringUtil.isNonBlank(string) && !StringUtil.equalStringIgnoreCase(string, this.sheetName)) {
            this.sheetName = string;
            this.sheetIndex = -1;
            this.initActiveSheet();
        }
    }

    @Override
    public void setActiveWorksheet(int n) {
        if (n > -1 && n != this.sheetIndex) {
            this.sheetIndex = n;
            this.sheetName = null;
            this.initActiveSheet();
        }
    }

    private boolean isTimestampFormat(String string) {
        for (String string2 : this.tsFormats) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private java.util.Date getJavaDate(double d) {
        int n = (int)Math.floor(d);
        int n2 = (int)((d - (double)n) * 8.64E7 + 0.5);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n3 = 1900;
        int n4 = -1;
        if (n < 61) {
            n4 = 0;
        }
        int n5 = (int)((long)n2 / 3600000L);
        n2 = (int)((long)n2 - (long)n5 * 3600000L);
        int n6 = (int)((long)n2 / 60000L);
        n2 = (int)((long)n2 - (long)n6 * 60000L);
        int n7 = (int)Math.floor((long)n2 / 1000L);
        n2 = (int)((long)n2 - (long)n7 * 1000L);
        gregorianCalendar.set(n3, 0, n + n4, n5, n6, n7);
        gregorianCalendar.set(14, n2);
        return gregorianCalendar.getTime();
    }

    private boolean isMerged(Cell cell) {
        if (cell == null) {
            return false;
        }
        for (CellRangeAddress cellRangeAddress : this.mergedRegions) {
            if (!cellRangeAddress.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> getRowValues(int n) {
        Row row = this.dataSheet.getRow(n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (row == null) {
            return arrayList;
        }
        int n2 = 0;
        int n3 = row.getLastCellNum();
        for (int i = 0; i < n3; ++i) {
            Cell cell = row.getCell(i);
            if (this.isMerged(cell)) {
                LogMgr.logDebug(new CallerInfo(){}, this.dataSheet.getSheetName() + ": column:" + cell.getColumnIndex() + ", row:" + cell.getRowIndex() + " is merged. Ignoring row!");
                return Collections.emptyList();
            }
            Object object = this.getCellValue(cell);
            if (object == null) {
                ++n2;
            }
            arrayList.add(object);
        }
        if (n2 == arrayList.size()) {
            arrayList.clear();
        }
        return arrayList;
    }

    private Object getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = cell.getCachedFormulaResultType();
        }
        Object object = null;
        switch (cellType) {
            case BLANK: 
            case ERROR: {
                object = null;
                break;
            }
            case NUMERIC: {
                boolean bl = HSSFDateUtil.isCellDateFormatted((Cell)cell);
                if (bl) {
                    if (this.useStringDates) {
                        object = this.dataFormatter.formatCellValue(cell);
                        break;
                    }
                    object = this.getDateValue(cell);
                    break;
                }
                double d = cell.getNumericCellValue();
                object = d;
                break;
            }
            default: {
                String string = cell.getStringCellValue();
                object = this.isNullString(string) ? null : string;
            }
        }
        return object;
    }

    private java.util.Date getDateValue(Cell cell) {
        java.util.Date date = null;
        try {
            date = cell.getDateCellValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = cell.getCellStyle().getDataFormatString();
        double d = cell.getNumericCellValue();
        if (date == null) {
            date = this.getJavaDate(d);
        }
        if (date != null) {
            if (this.isTimestampFormat(string)) {
                return new Timestamp(date.getTime());
            }
            return new Date(date.getTime());
        }
        return null;
    }

    private boolean isNullString(String string) {
        if (string == null) {
            return true;
        }
        if (this.emptyStringIsNull && StringUtil.isEmptyString(string)) {
            return true;
        }
        return StringUtil.equalString(string, this.nullString);
    }

    @Override
    public void setNullString(String string) {
        this.nullString = string;
    }

    @Override
    public int getRowCount() {
        return this.dataSheet.getLastRowNum() + 1;
    }

    @Override
    public void done() {
        this.dataSheet = null;
        this.workbook = null;
    }
}

