/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Column;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;
import workbench.db.importer.SpreadsheetReader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.MessageBuffer;
import workbench.util.StringUtil;
import workbench.util.ValueConverter;

public class OdsReader
implements SpreadsheetReader {
    private String nullIndicator;
    private File inputFile;
    private SpreadsheetDocument dataFile;
    private Table worksheet;
    private int worksheetIndex;
    private String worksheetName;
    private List<String> headerColumns;
    private final Set<String> tsFormats = CollectionUtil.treeSet("HH", "mm", "ss", "SSS", "KK", "kk");
    private MessageBuffer messages = new MessageBuffer();
    private final ValueConverter converter = new ValueConverter();
    private boolean emptyStringIsNull;

    public OdsReader(File file, int n, String string) {
        this.inputFile = file;
        if (n > -1 && StringUtil.isBlank(string)) {
            this.worksheetIndex = n;
        } else if (StringUtil.isNonBlank(string)) {
            this.worksheetIndex = -1;
            this.worksheetName = string;
        } else {
            this.worksheetIndex = 0;
        }
    }

    @Override
    public void enableRecalcOnLoad(boolean bl) {
    }

    @Override
    public void setReturnDatesAsString(boolean bl) {
    }

    @Override
    public MessageBuffer getMessages() {
        return this.messages;
    }

    @Override
    public synchronized List<String> getHeaderColumns() {
        if (this.headerColumns == null) {
            this.headerColumns = new ArrayList<String>();
            if (Settings.getInstance().getBoolProperty("workbench.ods.use.get_cell_count", true)) {
                this.readHeaderColsDefault();
            } else {
                this.readHeaderColsAlternate();
            }
        }
        return this.headerColumns;
    }

    @Override
    public void setEmptyStringIsNull(boolean bl) {
        this.emptyStringIsNull = bl;
    }

    private void readHeaderColsDefault() {
        Row row = this.worksheet.getRowByIndex(0);
        int n = 0;
        try {
            if (row != null) {
                n = row.getCellCount();
            }
        }
        catch (Exception exception) {
            n = -1;
        }
        if (n <= 0) {
            LogMgr.logError(new CallerInfo(){}, "Cannot retrieve column names because no columns are available in the first row of the sheet: " + this.worksheet.getTableName(), null);
            String string = ResourceMgr.getFormattedString("ErrExportNoCols", this.worksheet.getTableName());
            this.messages.append(string);
            this.messages.appendNewLine();
            return;
        }
        for (int i = 0; i < n; ++i) {
            Cell cell = row.getCellByIndex(i);
            String string = cell.getDisplayText();
            if (string != null) {
                this.headerColumns.add(string);
                continue;
            }
            this.headerColumns.add("Col" + Integer.toString(i));
        }
    }

    private void readHeaderColsAlternate() {
        List list = this.worksheet.getColumnList();
        if (CollectionUtil.isEmpty(list)) {
            LogMgr.logError(new CallerInfo(){}, "Cannot retrieve column names because no columns are available in the first row of the sheet: " + this.worksheet.getTableName(), null);
            String string = ResourceMgr.getFormattedString("ErrExportNoCols", this.worksheet.getTableName());
            this.messages.append(string);
            this.messages.appendNewLine();
            return;
        }
        for (Column column : list) {
            String string;
            Cell cell = column.getCellByIndex(0);
            if (cell == null || cell.getColumnSpannedNumber() != 1 || !StringUtil.isNonBlank(string = cell.getDisplayText())) continue;
            this.headerColumns.add(string);
        }
    }

    @Override
    public void setActiveWorksheet(int n) {
        this.worksheetIndex = n;
        this.worksheetName = null;
        this.headerColumns = null;
        this.initCurrentWorksheet();
    }

    @Override
    public void setActiveWorksheet(String string) {
        this.worksheetIndex = -1;
        this.worksheetName = string;
        this.headerColumns = null;
        this.initCurrentWorksheet();
    }

    private void initCurrentWorksheet() {
        if (this.dataFile == null) {
            return;
        }
        this.worksheet = this.worksheetIndex > -1 ? this.dataFile.getSheetByIndex(this.worksheetIndex) : (this.worksheetName != null ? this.dataFile.getSheetByName(this.worksheetName) : this.dataFile.getSheetByIndex(0));
    }

    private boolean isTimestampFormat(String string) {
        for (String string2 : this.tsFormats) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> getRowValues(int n) {
        ArrayList<Object> arrayList;
        Row row = this.worksheet.getRowByIndex(n);
        int n2 = 0;
        if (this.headerColumns != null) {
            n2 = this.headerColumns.size();
        } else if (Settings.getInstance().getBoolProperty("workbench.ods.use.get_cell_count", true)) {
            n2 = row.getCellCount();
        } else {
            arrayList = this.worksheet.getColumnList();
            n2 = arrayList.size();
        }
        arrayList = new ArrayList<Object>(n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string;
            Cell cell = row.getCellByIndex(i);
            String string2 = cell.getValueType();
            Object object = null;
            if ("boolean".equals(string2)) {
                object = cell.getBooleanValue();
            } else if ("time".equals(string2)) {
                string = cell.getDisplayText();
                try {
                    object = this.converter.parseTime(string);
                }
                catch (Exception exception) {
                    LogMgr.logWarning(new CallerInfo(){}, "Could not parse time value: " + string, exception);
                    object = this.getTime(cell);
                }
            } else {
                object = "date".equals(string2) ? this.getDate(cell) : ("float".equals(string2) ? cell.getDoubleValue() : ("currency".equals(string2) ? cell.getCurrencyValue() : (this.isNullString(string = cell.getStringValue()) ? null : string)));
            }
            if (object == null) {
                ++n3;
            }
            arrayList.add(object);
        }
        if (n3 == arrayList.size()) {
            arrayList.clear();
        }
        return arrayList;
    }

    private Time getTime(Cell cell) {
        Calendar calendar = cell.getTimeValue();
        if (calendar != null) {
            return new Time(calendar.getTime().getTime());
        }
        return null;
    }

    private Object getDate(Cell cell) {
        String string = cell.getFormatString();
        if (!this.isTimestampFormat(string)) {
            return this.getDateValue(cell, string);
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            String string2 = cell.getDisplayText();
            java.util.Date date = simpleDateFormat.parse(string2);
            return new Timestamp(date.getTime());
        }
        catch (Exception exception) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not parse date format: " + string, exception);
            return this.getDateValue(cell, string);
        }
    }

    private Object getDateValue(Cell cell, String string) {
        java.util.Date date = null;
        Calendar calendar = cell.getDateValue();
        if (calendar != null) {
            date = calendar.getTime();
        }
        if (date == null) {
            return null;
        }
        if (this.isTimestampFormat(string)) {
            return new Timestamp(date.getTime());
        }
        return new Date(date.getTime());
    }

    private boolean isNullString(String string) {
        if (string == null) {
            return true;
        }
        if (this.emptyStringIsNull && StringUtil.isEmptyString(string)) {
            return true;
        }
        return StringUtil.equalString(string, this.nullIndicator);
    }

    @Override
    public void setNullString(String string) {
        this.nullIndicator = string;
    }

    @Override
    public int getRowCount() {
        return this.worksheet.getRowCount();
    }

    @Override
    public void done() {
        if (this.dataFile != null) {
            this.dataFile.close();
        }
        this.dataFile = null;
        this.worksheet = null;
    }

    @Override
    public void load() throws IOException {
        try {
            this.dataFile = SpreadsheetDocument.loadDocument((File)this.inputFile);
            this.initCurrentWorksheet();
            LogMgr.logDebug(new CallerInfo(){}, "Document loaded. Rows: " + this.getRowCount());
        }
        catch (Exception exception) {
            throw new IOException("Could not load file " + this.inputFile.getAbsolutePath(), exception);
        }
    }

    @Override
    public List<String> getSheets() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.dataFile == null) {
            try {
                this.load();
            }
            catch (IOException iOException) {
                LogMgr.logError(new CallerInfo(){}, iOException.getMessage(), iOException);
                return arrayList;
            }
        }
        int n = this.dataFile.getSheetCount();
        for (int i = 0; i < n; ++i) {
            String string = this.dataFile.getSheetByIndex(i).getTableName();
            arrayList.add(string);
        }
        return arrayList;
    }
}

