/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import workbench.db.DbObjectFinder;
import workbench.db.DependencyNode;
import workbench.db.DependencyTreeDumper;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.AggregatingMap;

public class TableDependencySorter {
    private final WbConnection dbConn;
    private final List<TableIdentifier> cycleErrors = new ArrayList<TableIdentifier>();
    private ScriptGenerationMonitor monitor;
    private TableDependency dependencyReader;
    private final DbObjectFinder finder;
    private boolean cancel;
    private boolean validateInputTables = true;

    public TableDependencySorter(WbConnection wbConnection) {
        this.dbConn = wbConnection;
        this.finder = new DbObjectFinder(wbConnection);
    }

    public void setValidateTables(boolean bl) {
        this.validateInputTables = bl;
    }

    public void setProgressMonitor(ScriptGenerationMonitor scriptGenerationMonitor) {
        this.monitor = scriptGenerationMonitor;
    }

    public List<TableIdentifier> sortForInsert(List<TableIdentifier> list) {
        return this.getSortedTableList(list, false, false);
    }

    public List<TableIdentifier> sortForDelete(List<TableIdentifier> list, boolean bl) {
        return this.getSortedTableList(list, bl, true);
    }

    public boolean hasErrors() {
        return this.cycleErrors.size() > 0;
    }

    public List<TableIdentifier> getErrorTables() {
        if (this.cycleErrors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.cycleErrors);
    }

    private List<TableIdentifier> getSortedTableList(List<TableIdentifier> list, boolean bl, boolean bl2) {
        Collection<Object> collection;
        this.cancel = false;
        if (this.validateInputTables) {
            list = this.validateTables(list);
        }
        List<DependencyNode> list2 = this.collectRoots(list);
        if (this.cancel) {
            return Collections.emptyList();
        }
        if (this.monitor != null) {
            this.monitor.setCurrentObject(ResourceMgr.getFormattedString("MsgCalcDelDeps", new Object[0]), -1, -1);
        }
        if (bl) {
            collection = new HashSet();
            for (DependencyNode dependencyNode : list2) {
                if (list.contains(dependencyNode.getTable())) continue;
                collection.add(dependencyNode.getTable());
            }
            list.addAll(collection);
        }
        collection = TableDependencySorter.sortTables(list2, list, bl2);
        return collection;
    }

    private List<TableIdentifier> validateTables(List<TableIdentifier> list) {
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>(list.size());
        for (TableIdentifier tableIdentifier : list) {
            TableIdentifier tableIdentifier2 = this.finder.findTable(tableIdentifier);
            if (tableIdentifier2 == null) continue;
            arrayList.add(tableIdentifier2);
        }
        return arrayList;
    }

    private DependencyNode findChildTree(Collection<DependencyNode> collection, TableIdentifier tableIdentifier) {
        int n = Integer.MIN_VALUE;
        DependencyNode dependencyNode = null;
        for (DependencyNode dependencyNode2 : collection) {
            DependencyNode dependencyNode3 = dependencyNode2.findChildTree(tableIdentifier);
            if (dependencyNode3 == null) continue;
            int n2 = dependencyNode3.getLevel();
            if (dependencyNode3.getLevel() <= n) continue;
            n = n2;
            dependencyNode = dependencyNode3;
        }
        return dependencyNode;
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public void cancel() {
        this.cancel = true;
        if (this.dependencyReader != null) {
            this.dependencyReader.cancel();
        }
    }

    private List<DependencyNode> collectRoots(List<TableIdentifier> list) {
        DependencyNode dependencyNode;
        ArrayList<DependencyNode> arrayList = new ArrayList<DependencyNode>(list.size() * 2);
        HashSet<DependencyNode> hashSet = new HashSet<DependencyNode>(list.size());
        this.dependencyReader = new TableDependency(this.dbConn);
        int n = 1;
        for (TableIdentifier serializable : list) {
            if (this.cancel) break;
            if (this.monitor != null) {
                this.monitor.setCurrentObject(serializable.getTableExpression(), n, list.size());
            }
            ++n;
            dependencyNode = this.findChildTree(arrayList, serializable);
            if (dependencyNode == null) {
                this.dependencyReader.setMainTable(serializable);
                this.dependencyReader.readTreeForChildren();
                if (this.dependencyReader.wasAborted()) {
                    this.cycleErrors.add(serializable);
                }
                dependencyNode = this.dependencyReader.getRootNode();
                hashSet.add(dependencyNode);
            } else {
                LogMgr.logDebug(new CallerInfo(){}, "Re-using child tree for " + serializable + " with level: " + dependencyNode.getLevel());
            }
            List<DependencyNode> list2 = this.getAllNodes(dependencyNode);
            arrayList.addAll(list2);
        }
        if (this.cancel) {
            return Collections.emptyList();
        }
        for (DependencyNode dependencyNode2 : hashSet) {
            dependencyNode = this.findNodeForTable(arrayList, dependencyNode2.getTable());
            if (dependencyNode != null) continue;
            arrayList.add(dependencyNode2);
        }
        return arrayList;
    }

    public static List<TableIdentifier> sortTables(final Collection<DependencyNode> collection, Collection<TableIdentifier> collection2, final boolean bl) {
        ArrayList<TableIdentifier> arrayList;
        long l;
        block4: {
            l = System.currentTimeMillis();
            arrayList = new ArrayList<TableIdentifier>(collection2);
            final AggregatingMap<TableIdentifier, DependencyNode> aggregatingMap = new AggregatingMap<TableIdentifier, DependencyNode>(false);
            final HashMap<TableIdentifier, Integer> hashMap = new HashMap<TableIdentifier, Integer>();
            final HashMap hashMap2 = new HashMap();
            for (DependencyNode dependencyNode : collection) {
                aggregatingMap.addValue(dependencyNode.getTable(), dependencyNode);
                int n = 0;
                Integer n2 = (Integer)hashMap.get(dependencyNode.getTable());
                if (n2 != null) {
                    n = n2;
                }
                hashMap.put(dependencyNode.getTable(), n += dependencyNode.getLevel());
            }
            Comparator<TableIdentifier> comparator = new Comparator<TableIdentifier>(){
                final int factor;
                {
                    this.factor = bl ? -1 : 1;
                }

                @Override
                public int compare(TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2) {
                    int n;
                    if (tableIdentifier.equals(tableIdentifier2)) {
                        return 0;
                    }
                    int n2 = this.getLevelTotal(tableIdentifier);
                    int n3 = this.getLevelTotal(tableIdentifier2);
                    int n4 = 0;
                    if (n2 == n3) {
                        n = this.getReferenceCounter(tableIdentifier);
                        int n5 = this.getReferenceCounter(tableIdentifier2);
                        n4 = this.factor * (n - n5);
                    } else {
                        n4 = this.factor * (n2 - n3);
                    }
                    n = (int)Math.signum(n4);
                    if (n4 == 0 || n == this.factor) {
                        Set set = aggregatingMap.get(tableIdentifier2);
                        for (DependencyNode dependencyNode : set) {
                            if (dependencyNode.containsParentTable(tableIdentifier)) {
                                return -this.factor;
                            }
                            if (n4 != 0 || !dependencyNode.containsChildTable(tableIdentifier)) continue;
                            return this.factor;
                        }
                    }
                    if (n4 == 0 || n == -this.factor) {
                        Set set = aggregatingMap.get(tableIdentifier);
                        for (DependencyNode dependencyNode : set) {
                            if (dependencyNode.containsParentTable(tableIdentifier2)) {
                                return this.factor;
                            }
                            if (n4 != 0 || !dependencyNode.containsChildTable(tableIdentifier2)) continue;
                            return -this.factor;
                        }
                    }
                    if (n4 == 0) {
                        n4 = tableIdentifier.getTableExpression().compareTo(tableIdentifier2.getTableExpression());
                    }
                    return n4;
                }

                private int getReferenceCounter(TableIdentifier tableIdentifier) {
                    Integer n = (Integer)hashMap2.get(tableIdentifier);
                    if (n != null) {
                        return n;
                    }
                    int n2 = 0;
                    for (DependencyNode dependencyNode : collection) {
                        if (!dependencyNode.getTable().equals(tableIdentifier) && !dependencyNode.containsParentTable(tableIdentifier)) continue;
                        ++n2;
                    }
                    hashMap2.put(tableIdentifier, n2);
                    return n2;
                }

                private int getLevelTotal(TableIdentifier tableIdentifier) {
                    Integer n = (Integer)hashMap.get(tableIdentifier);
                    if (n == null) {
                        return 0;
                    }
                    return n;
                }
            };
            try {
                Collections.sort(arrayList, comparator);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not sort dependency tree " + (bl ? "up" : "down"), throwable);
                if (!Settings.getInstance().getBoolProperty("workbench.dependencysorter.dump.onerror", false)) break block4;
                DependencyTreeDumper dependencyTreeDumper = new DependencyTreeDumper();
                dependencyTreeDumper.dumpNodes(collection);
                LogMgr.logInfo(new CallerInfo(){}, "All nodes dumped to configuration directory");
            }
        }
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Sorting " + arrayList.size() + " tables took " + l2 + "ms");
        return arrayList;
    }

    private DependencyNode findNodeForTable(Collection<DependencyNode> collection, TableIdentifier tableIdentifier) {
        int n = Integer.MIN_VALUE;
        DependencyNode dependencyNode = null;
        for (DependencyNode dependencyNode2 : collection) {
            int n2;
            if (!dependencyNode2.getTable().compareNames(tableIdentifier) || (n2 = dependencyNode2.getLevel()) <= n) continue;
            dependencyNode = dependencyNode2;
            n = n2;
        }
        return dependencyNode;
    }

    public List<DependencyNode> getAllNodes(DependencyNode dependencyNode) {
        if (dependencyNode == null) {
            return Collections.emptyList();
        }
        List<DependencyNode> list = dependencyNode.getChildren();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DependencyNode> arrayList = new ArrayList<DependencyNode>();
        for (DependencyNode dependencyNode2 : list) {
            if (!dependencyNode2.getTable().compareNames(dependencyNode.getTable())) {
                arrayList.add(dependencyNode2);
            }
            arrayList.addAll(this.getAllNodes(dependencyNode2));
        }
        return arrayList;
    }
}

