/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.importer.TableStatementError;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.ArgumentParser;
import workbench.util.StringUtil;

public class TableStatements {
    private String preStatement;
    private String postStatement;
    private boolean ignoreErrors;
    private boolean success;
    private boolean runPostStatementAfterError;

    public TableStatements(String string, String string2) {
        this.preStatement = string;
        this.postStatement = string2;
        this.runPostStatementAfterError = Settings.getInstance().getBoolProperty("workbench.sql.tablestatements.on.error", true);
    }

    public TableStatements(ArgumentParser argumentParser) {
        String string = argumentParser.getValue("preTableStatement");
        if (!StringUtil.isBlank(string)) {
            this.preStatement = string;
        }
        if (!StringUtil.isBlank(string = argumentParser.getValue("postTableStatement"))) {
            this.postStatement = string;
        }
        boolean bl = Settings.getInstance().getBoolProperty("workbench.sql.tablestatements.on.error", true);
        this.ignoreErrors = argumentParser.getBoolean("ignorePrePostErrors", true);
        this.runPostStatementAfterError = argumentParser.getBoolean("runTableStatementOnError", bl);
    }

    public boolean getRunPostStatementAfterError() {
        return this.runPostStatementAfterError;
    }

    public boolean hasStatements() {
        return this.preStatement != null || this.postStatement != null;
    }

    public void runPreTableStatement(WbConnection wbConnection, TableIdentifier tableIdentifier) throws SQLException {
        this.runStatement(wbConnection, tableIdentifier, this.getPreStatement(tableIdentifier));
    }

    public void runPostTableStatement(WbConnection wbConnection, TableIdentifier tableIdentifier) throws SQLException {
        this.runStatement(wbConnection, tableIdentifier, this.getPostStatement(tableIdentifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void runStatement(WbConnection wbConnection, TableIdentifier tableIdentifier, String string) throws SQLException {
        if (StringUtil.isBlank(string)) {
            this.success = true;
            return;
        }
        Savepoint savepoint = null;
        Statement statement = null;
        boolean bl = wbConnection.getDbSettings().useSavepointForTableStatements() && wbConnection.supportsSavepoints();
        this.success = false;
        try {
            if (bl) {
                savepoint = wbConnection.setSavepoint();
            }
            statement = wbConnection.createStatement();
            LogMgr.logDebug(new CallerInfo(){}, "Executing statement: " + string);
            statement.execute(string);
            wbConnection.releaseSavepoint(savepoint);
            this.success = true;
        }
        catch (SQLException sQLException) {
            wbConnection.rollback(savepoint);
            String string2 = "Error running statement: [" + string + "] for table: " + tableIdentifier.getFullyQualifiedName(wbConnection);
            if (!this.ignoreErrors) {
                LogMgr.logError(new CallerInfo(){}, string2 + string, sQLException);
                throw new TableStatementError(sQLException, tableIdentifier);
            }
            LogMgr.logWarning(new CallerInfo(){}, string2 + ": " + sQLException.getMessage());
            JdbcUtils.closeStatement(statement);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error running statement: " + string, throwable);
            wbConnection.rollback(savepoint);
            {
                catch (Throwable throwable2) {
                    JdbcUtils.closeStatement(statement);
                    throw throwable2;
                }
            }
            JdbcUtils.closeStatement(statement);
        }
        JdbcUtils.closeStatement(statement);
    }

    public boolean wasSuccess() {
        return this.success;
    }

    public String getPostStatement(TableIdentifier tableIdentifier) {
        return this.getTableStatement(this.postStatement, tableIdentifier);
    }

    public String getPreStatement(TableIdentifier tableIdentifier) {
        return this.getTableStatement(this.preStatement, tableIdentifier);
    }

    private String getTableStatement(String string, TableIdentifier tableIdentifier) {
        if (string == null) {
            return null;
        }
        if (tableIdentifier == null) {
            return string;
        }
        String string2 = StringUtil.replace(string, "${table.name}", tableIdentifier.getTableName());
        string2 = StringUtil.replace(string2, "${table.expression}", tableIdentifier.getTableExpression());
        return string2;
    }
}

