/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer.detector;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import workbench.db.importer.detector.ColType;

public class ColumnStatistics {
    private final String name;
    private final SortedMap<ColType, Integer> typeCounts;
    private int maxLength = -1;
    private int maxDigits = -1;

    public ColumnStatistics(String string) {
        this.name = string;
        this.typeCounts = new TreeMap<ColType, Integer>();
    }

    public void addValidType(ColType colType, int n, int n2) {
        int n3 = this.getValidCount(colType);
        this.typeCounts.put(colType, ++n3);
        if (n > this.maxLength) {
            this.maxLength = n;
        }
        if (n2 > this.maxDigits) {
            this.maxDigits = n2;
        }
    }

    public ColType getBestType() {
        ColType colType;
        if (this.typeCounts.isEmpty()) {
            return ColType.String;
        }
        if (this.typeCounts.size() == 1) {
            return this.typeCounts.firstKey();
        }
        ColType colType2 = this.getMostFrequentType();
        if (colType2 == (colType = this.typeCounts.firstKey())) {
            return colType2;
        }
        if (this.sameBaseType(colType2, colType)) {
            return colType;
        }
        return ColType.String;
    }

    public List<ColType> getDetectedTypes() {
        return new ArrayList<ColType>(this.typeCounts.keySet());
    }

    public boolean sameBaseType(ColType colType, ColType colType2) {
        return colType == ColType.Decimal && colType2 == ColType.Integer || colType == ColType.Integer && colType2 == ColType.Decimal || colType == ColType.Date && colType2 == ColType.Timestamp || colType == ColType.Timestamp && colType2 == ColType.Date;
    }

    public int getValidCount(ColType colType) {
        Integer n = (Integer)this.typeCounts.get((Object)colType);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public ColType getMostFrequentType() {
        int n = 0;
        ColType colType = null;
        for (ColType colType2 : this.typeCounts.keySet()) {
            int n2 = this.getValidCount(colType2);
            if (n2 <= n) continue;
            n = n2;
            colType = colType2;
        }
        return colType;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMaxDigits() {
        return this.maxDigits;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

