/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer.detector;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.WbConnection;
import workbench.db.importer.SpreadsheetReader;
import workbench.db.importer.detector.ColumnStatistics;
import workbench.db.importer.detector.TableDetector;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class SpreadSheetTableDetector
extends TableDetector {
    private int sheetIndex;
    private String sheetName;
    private Map<String, List<ColumnStatistics>> sheetMap = new HashMap<String, List<ColumnStatistics>>();

    public SpreadSheetTableDetector(File file, boolean bl, int n) {
        this.inputFile = new WbFile(file);
        this.withHeader = bl;
        this.sheetIndex = n < 0 ? -1 : n;
    }

    @Override
    protected void processFile() {
        this.analyzeSpreadSheet();
    }

    @Override
    protected void checkResults() {
        for (Map.Entry<String, List<ColumnStatistics>> entry : this.sheetMap.entrySet()) {
            super.checkResults(entry.getValue(), entry.getKey());
        }
    }

    @Override
    protected String getDisplayFilename() {
        String string = super.getDisplayFilename();
        if (StringUtil.isNonBlank(this.sheetName)) {
            string = string + ":" + SqlUtil.cleanupIdentifier(this.sheetName);
        }
        return string;
    }

    @Override
    public String getCreateTable(WbConnection wbConnection) throws SQLException {
        if (this.sheetMap.size() == 1) {
            return super.getCreateTable(wbConnection, this.sheetMap.values().iterator().next());
        }
        StringBuilder stringBuilder = new StringBuilder(this.sheetMap.size() * 100);
        for (Map.Entry<String, List<ColumnStatistics>> entry : this.sheetMap.entrySet()) {
            String string = super.getCreateTable(wbConnection, entry.getValue(), entry.getKey());
            stringBuilder.append(string);
            stringBuilder.append("\n\n");
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getTableNameToUse() {
        if (StringUtil.isNonBlank(this.sheetName)) {
            return SqlUtil.cleanupIdentifier(this.sheetName);
        }
        return super.getTableNameToUse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeSpreadSheet() {
        SpreadsheetReader spreadsheetReader = SpreadsheetReader.Factory.createReader(this.inputFile, this.sheetIndex, null);
        if (spreadsheetReader == null) {
            return;
        }
        try {
            spreadsheetReader.load();
            List<String> list = spreadsheetReader.getSheets();
            int n = -1;
            int n2 = -1;
            if (this.sheetIndex == -1) {
                n = 0;
                n2 = list.size() - 1;
            } else {
                n = this.sheetIndex;
                n2 = this.sheetIndex;
            }
            for (int i = n; i <= n2; ++i) {
                int n3;
                String string = list.get(i);
                spreadsheetReader.setActiveWorksheet(i);
                List<String> list2 = spreadsheetReader.getHeaderColumns();
                if (!this.withHeader) {
                    for (int j = 0; j < list2.size(); ++j) {
                        list2.set(j, "column_" + Integer.toString(i + 1));
                    }
                }
                ArrayList<ColumnStatistics> arrayList = new ArrayList<ColumnStatistics>(list2.size());
                for (String string2 : list2) {
                    arrayList.add(new ColumnStatistics(string2));
                }
                int n4 = Math.min(spreadsheetReader.getRowCount(), this.sampleSize);
                for (int j = n3 = this.withHeader ? 1 : 0; j < n4; ++j) {
                    List<Object> list3 = spreadsheetReader.getRowValues(j);
                    this.analyzeValues(list3, arrayList);
                }
                this.sheetMap.put(string, arrayList);
            }
            if (this.sheetMap.size() == 1) {
                this.columns = this.sheetMap.values().iterator().next();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error reading spreadsheet", throwable);
            this.messages.append(ExceptionUtil.getDisplay(throwable));
        }
        finally {
            spreadsheetReader.done();
        }
    }
}

